/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class TargetUtils {
    private static final int MAX_DISTANCE = 256;
    private static final double MAX_DISTANCE_SQ = 65536.0;

    public static double getReachDistanceSq(EntityPlayer player) {
        return 36.0;
    }

    public static boolean canReachTarget(EntityPlayer player, Entity target) {
        return player.func_70685_l(target) && player.func_70068_e(target) < TargetUtils.getReachDistanceSq(player);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isMouseOverEntity(Entity entity) {
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        return mop != null && mop.field_72308_g == entity;
    }

    @SideOnly(value=Side.CLIENT)
    public static Entity getMouseOverEntity() {
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        return mop == null ? null : mop.field_72308_g;
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius) {
        return TargetUtils.acquireLookTarget(seeker, distance, radius, false);
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius, boolean closestToSeeker) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        EntityLivingBase currentTarget = null;
        double currentDistance = 65536.0;
        Vec3 vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            List list = seeker.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((targetX += vec3.field_72450_a) - radius), (double)((targetY += vec3.field_72448_b) - radius), (double)((targetZ += vec3.field_72449_c) - radius), (double)(targetX + radius), (double)(targetY + radius), (double)(targetZ + radius)));
            for (EntityLivingBase target : list) {
                if (target == seeker || !target.func_70067_L() || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target)) continue;
                double d = closestToSeeker ? target.func_70068_e((Entity)seeker) : target.func_70092_e(targetX, targetY, targetZ);
                double newDistance = d;
                if (!(newDistance < currentDistance)) continue;
                currentTarget = target;
                currentDistance = newDistance;
            }
        }
        return currentTarget;
    }

    public static final List<EntityLivingBase> acquireAllLookTargets(EntityLivingBase seeker, int distance, double radius) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        Vec3 vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            List list = seeker.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((targetX += vec3.field_72450_a) - radius), (double)((targetY += vec3.field_72448_b) - radius), (double)((targetZ += vec3.field_72449_c) - radius), (double)(targetX + radius), (double)(targetY + radius), (double)(targetZ + radius)));
            for (EntityLivingBase target : list) {
                if (target == seeker || !target.func_70067_L() || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target) || targets.contains(target)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    public static final boolean isTargetInFrontOf(Entity seeker, Entity target, float fov) {
        double vecX = target.field_70165_t - seeker.field_70165_t;
        double vecZ = target.field_70161_v - seeker.field_70161_v;
        float rotation = (float)(Math.atan2(vecX, vecZ) * 180.0 / Math.PI);
        while (seeker.field_70177_z > 360.0f) {
            seeker.field_70177_z -= 360.0f;
        }
        return Math.abs(Math.abs(seeker.field_70177_z) - Math.abs(rotation)) < fov;
    }

    public static final boolean isTargetInSight(EntityLivingBase seeker, Entity target) {
        return TargetUtils.isTargetInSight(seeker.func_70040_Z(), seeker, target);
    }

    private static final boolean isTargetInSight(Vec3 vec3, EntityLivingBase seeker, Entity target) {
        return (vec3.field_72450_a < 0.0 ? target.field_70165_t <= seeker.field_70165_t : target.field_70165_t >= seeker.field_70165_t) && (vec3.field_72449_c < 0.0 ? target.field_70161_v <= seeker.field_70161_v : target.field_70161_v >= seeker.field_70161_v) && seeker.func_70685_l(target);
    }
}

