/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.lib.Config;
import dynamicswordskills.network.ActivateSkillPacket;
import dynamicswordskills.network.MortalDrawPacket;
import dynamicswordskills.skills.ArmorBreak;
import dynamicswordskills.skills.Dash;
import dynamicswordskills.skills.Dodge;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.LeapingBlow;
import dynamicswordskills.skills.MortalDraw;
import dynamicswordskills.skills.Parry;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.SpinAttack;
import dynamicswordskills.skills.SwordBasic;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;

public class DSSCombatEvents {
    private static final Map<Class<? extends EntityLivingBase>, ItemStack> dropsList = new HashMap<Class<? extends EntityLivingBase>, ItemStack>();

    public static void addDrop(Class<? extends EntityLivingBase> mobClass, int orbID) {
        if (orbID < 16 && SkillBase.getSkillList()[orbID] != null) {
            ItemStack stack = new ItemStack(DynamicSwordSkills.skillOrb, 1, (int)SkillBase.getSkillList()[orbID].id);
            dropsList.put(mobClass, stack);
        }
    }

    public static void initializeDrops() {
        DSSCombatEvents.addDrop(EntityZombie.class, SkillBase.swordBasic.id);
        DSSCombatEvents.addDrop(EntitySkeleton.class, SkillBase.swordBasic.id);
        DSSCombatEvents.addDrop(EntityEnderman.class, SkillBase.dodge.id);
        DSSCombatEvents.addDrop(EntitySilverfish.class, SkillBase.dodge.id);
        DSSCombatEvents.addDrop(EntitySlime.class, SkillBase.dash.id);
        DSSCombatEvents.addDrop(EntityHorse.class, SkillBase.dash.id);
        DSSCombatEvents.addDrop(EntityPigZombie.class, SkillBase.parry.id);
        DSSCombatEvents.addDrop(EntityOcelot.class, SkillBase.parry.id);
        DSSCombatEvents.addDrop(EntitySpider.class, SkillBase.leapingBlow.id);
        DSSCombatEvents.addDrop(EntityMagmaCube.class, SkillBase.leapingBlow.id);
        DSSCombatEvents.addDrop(EntityBlaze.class, SkillBase.spinAttack.id);
        DSSCombatEvents.addDrop(EntityBat.class, SkillBase.spinAttack.id);
        DSSCombatEvents.addDrop(EntityCreeper.class, SkillBase.armorBreak.id);
        DSSCombatEvents.addDrop(EntityIronGolem.class, SkillBase.armorBreak.id);
        DSSCombatEvents.addDrop(EntityGhast.class, SkillBase.superSpinAttack.id);
        DSSCombatEvents.addDrop(EntityWitch.class, SkillBase.mortalDraw.id);
    }

    private static ItemStack getOrbDrop(EntityLivingBase mob) {
        if (dropsList.get(mob.getClass()) != null && mob.field_70170_p.field_73012_v.nextFloat() > Config.getChanceForRandomDrop()) {
            return dropsList.get(mob.getClass());
        }
        ItemStack orb = null;
        boolean flag = mob instanceof EntityPlayer;
        int id = mob.field_70170_p.field_73012_v.nextInt(16);
        if (SkillBase.getSkillList()[id] != null && (!flag || Config.arePlayerDropsEnabled())) {
            float chance = (flag ? Config.getPlayerDropFactor() : 1.0f) * Config.getRandomMobDropChance();
            if (dropsList.get(mob.getClass()) != null || mob.field_70170_p.field_73012_v.nextFloat() < chance) {
                orb = new ItemStack(DynamicSwordSkills.skillOrb, 1, id);
            }
        }
        return orb;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EntityLivingBase mob;
        ItemStack orb;
        if (event.source.func_76346_g() instanceof EntityPlayer && (orb = DSSCombatEvents.getOrbDrop(mob = event.entityLiving)) != null && mob.field_70170_p.field_73012_v.nextFloat() < Config.getDropChance(orb.func_77960_j()) + 0.005f * (float)event.lootingLevel) {
            event.drops.clear();
            event.drops.add(new EntityItem(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, orb.func_77946_l()));
            mob.field_70170_p.func_72908_a(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, "dynamicswordskills:special_drop", 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseChanged(MouseEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        DSSPlayerInfo skills = DSSPlayerInfo.get((EntityPlayer)player);
        ILockOnTarget skill = DSSPlayerInfo.get((EntityPlayer)player).getTargetingSkill();
        if ((event.buttonstate || event.button == -1) && skills.isSkillActive(SkillBase.mortalDraw)) {
            event.setCanceled(true);
            return;
        }
        if (skill != null && skill.isLockedOn()) {
            if (event.button == 0 && event.buttonstate) {
                if (Config.allowVanillaControls() && PlayerUtils.isHoldingSword((EntityPlayer)player)) {
                    if (skill instanceof SwordBasic) {
                        boolean canCharge = true;
                        if (!skills.canInteract()) {
                            if (skills.isSkillActive(SkillBase.spinAttack)) {
                                ((SpinAttack)skills.getPlayerSkill(SkillBase.spinAttack)).keyPressed(mc.field_71474_y.field_74312_F, (EntityPlayer)mc.field_71439_g);
                            }
                            canCharge = false;
                            event.setCanceled(true);
                        } else if (skills.hasSkill(SkillBase.dash) && player.field_70122_E && ((Dash)skills.getPlayerSkill(SkillBase.dash)).isRMBDown()) {
                            DynamicSwordSkills.dispatcher.sendToServer(new ActivateSkillPacket(SkillBase.dash));
                            event.setCanceled(player.func_71011_bu() == null);
                        } else {
                            DSSCombatEvents.performComboAttack(mc, skill);
                        }
                        if (skills.hasSkill(SkillBase.armorBreak) && canCharge) {
                            ((ArmorBreak)skills.getPlayerSkill(SkillBase.armorBreak)).keyPressed((EntityPlayer)player);
                        }
                    } else {
                        DSSCombatEvents.performComboAttack(mc, skill);
                    }
                } else if (skills.hasSkill(SkillBase.mortalDraw) && ((MortalDraw)skills.getPlayerSkill(SkillBase.mortalDraw)).isRMBDown() && player.func_70694_bm() == null) {
                    DynamicSwordSkills.dispatcher.sendToServer(new ActivateSkillPacket(SkillBase.mortalDraw));
                    event.setCanceled(true);
                } else {
                    DSSCombatEvents.performComboAttack(mc, skill);
                }
                event.setResult(Event.Result.DENY);
            } else if (event.button == 1 && Config.allowVanillaControls() && skill instanceof SwordBasic) {
                if (skills.isSkillActive(SkillBase.spinAttack) || skills.isSkillActive(SkillBase.leapingBlow)) {
                    event.setCanceled(true);
                } else if (skills.hasSkill(SkillBase.dash) && PlayerUtils.isHoldingSword((EntityPlayer)player)) {
                    ((Dash)skills.getPlayerSkill(SkillBase.dash)).keyPressed(event.buttonstate);
                } else if (skills.hasSkill(SkillBase.mortalDraw) && player.func_70694_bm() == null) {
                    ((MortalDraw)skills.getPlayerSkill(SkillBase.mortalDraw)).keyPressed(event.buttonstate);
                }
            } else if (event.button == -1) {
                player.field_71071_by.func_70453_c(event.dwheel);
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void performComboAttack(Minecraft mc, ILockOnTarget skill) {
        if (!mc.field_71439_g.func_71039_bw() || DSSPlayerInfo.get((EntityPlayer)mc.field_71439_g).isSkillActive(SkillBase.mortalDraw)) {
            mc.field_71439_g.func_71038_i();
            if (skill instanceof ICombo && ((ICombo)((Object)skill)).onAttack((EntityPlayer)mc.field_71439_g)) {
                Entity entity = TargetUtils.getMouseOverEntity();
                mc.field_71442_b.func_78764_a((EntityPlayer)mc.field_71439_g, entity != null ? entity : skill.getCurrentTarget());
            }
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        if (!event.isCanceled() && event.entity instanceof EntityPlayer && DSSPlayerInfo.get(player = (EntityPlayer)event.entity) != null) {
            DSSPlayerInfo skills = DSSPlayerInfo.get(player);
            if (skills.isSkillActive(SkillBase.dodge)) {
                event.setCanceled(((Dodge)skills.getPlayerSkill(SkillBase.dodge)).dodgeAttack(player));
            } else if (skills.isSkillActive(SkillBase.parry)) {
                if (event.source.func_76364_f() instanceof EntityLivingBase) {
                    EntityLivingBase attacker = (EntityLivingBase)event.source.func_76364_f();
                    event.setCanceled(((Parry)skills.getPlayerSkill(SkillBase.parry)).parryAttack(player, attacker));
                }
            } else if (skills.isSkillActive(SkillBase.mortalDraw) && event.source.func_76346_g() != null && !player.field_70170_p.field_72995_K && ((MortalDraw)skills.getPlayerSkill(SkillBase.mortalDraw)).drawSword(player, event.source.func_76346_g())) {
                DynamicSwordSkills.dispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHurt(LivingHurtEvent event) {
        ICombo combo;
        EntityPlayer player;
        if (event.source.func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.source.func_76346_g();
            DSSPlayerInfo skills = DSSPlayerInfo.get(player);
            ICombo combo2 = skills.getComboSkill();
            if (combo2 != null && combo2.getCombo() != null && !combo2.getCombo().isFinished()) {
                event.ammount += (float)combo2.getCombo().getSize();
            }
            if (skills.isSkillActive(SkillBase.armorBreak)) {
                ((ArmorBreak)skills.getPlayerSkill(SkillBase.armorBreak)).onImpact(player, event);
                return;
            }
            if (skills.isSkillActive(SkillBase.mortalDraw)) {
                ((MortalDraw)skills.getPlayerSkill(SkillBase.mortalDraw)).onImpact(player, event);
            }
        }
        if (event.ammount > 0.0f && event.entity instanceof EntityPlayer && (combo = DSSPlayerInfo.get(player = (EntityPlayer)event.entity).getComboSkill()) != null && event.ammount > 0.0f) {
            combo.onPlayerHurt(player, event);
        }
        if (event.ammount > 0.0f && event.source.func_76346_g() instanceof EntityPlayer && (combo = DSSPlayerInfo.get(player = (EntityPlayer)event.source.func_76346_g()).getComboSkill()) != null) {
            combo.onHurtTarget(player, event);
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            DSSPlayerInfo.saveProxyData((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            DSSPlayerInfo.loadProxyData(player);
            DSSPlayerInfo.get(player).verifyStartingGear();
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && DSSPlayerInfo.get((EntityPlayer)event.entity) == null) {
            DSSPlayerInfo.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        EntityPlayer player;
        if (event.entity instanceof EntityPlayer && event.entity.field_70170_p.field_72995_K && DSSPlayerInfo.get(player = (EntityPlayer)event.entity) != null && DSSPlayerInfo.get(player).isSkillActive(SkillBase.leapingBlow)) {
            ((LeapingBlow)DSSPlayerInfo.get(player).getPlayerSkill(SkillBase.leapingBlow)).onImpact(player, event.distance);
        }
    }

    @SubscribeEvent
    public void onCreativeFall(PlayerFlyableFallEvent event) {
        if (DSSPlayerInfo.get(event.entityPlayer) != null && event.entityPlayer.field_70170_p.field_72995_K && DSSPlayerInfo.get(event.entityPlayer).isSkillActive(SkillBase.leapingBlow)) {
            EntityPlayer player = event.entityPlayer;
            ((LeapingBlow)DSSPlayerInfo.get(player).getPlayerSkill(SkillBase.leapingBlow)).onImpact(player, event.distance);
        }
    }
}

