/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.lib.Config;
import dynamicswordskills.network.EndComboPacket;
import dynamicswordskills.skills.Combo;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.SkillBase;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

@SideOnly(value=Side.CLIENT)
public class ComboOverlay
extends Gui {
    private Minecraft mc;
    private Combo combo = null;
    private int lastComboSize = 0;
    private long displayStartTime;
    private static final long DISPLAY_TIME = 5000L;

    public ComboOverlay(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        this.displayComboText();
    }

    private void displayComboText() {
        ICombo iCombo = DSSPlayerInfo.get((EntityPlayer)this.mc.field_71439_g).getComboSkill();
        if (iCombo != null && iCombo.getCombo() != null && this.combo != iCombo.getCombo()) {
            this.combo = iCombo.getCombo();
            this.lastComboSize = this.combo.getSize();
            this.displayStartTime = Minecraft.func_71386_F();
            if (iCombo.getCombo().isFinished()) {
                iCombo.setCombo(null);
                DynamicSwordSkills.dispatcher.sendToServer(new EndComboPacket((SkillBase)((Object)iCombo)));
            }
        }
        if (this.combo != null) {
            if (this.lastComboSize != this.combo.getSize()) {
                this.lastComboSize = this.combo.getSize();
                this.displayStartTime = Minecraft.func_71386_F();
            }
            if (Minecraft.func_71386_F() - this.displayStartTime < 5000L) {
                String s = this.combo.isFinished() ? StatCollector.func_74838_a((String)"combo.finished") + "! " : StatCollector.func_74838_a((String)"combo.combo") + ": ";
                this.mc.field_71466_p.func_78276_b(s + this.combo.getLabel(), 10, 10, this.combo.isFinished() ? 255 : -256);
                this.mc.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"combo.size") + ": " + this.combo.getSize() + "/" + this.combo.getMaxSize(), 10, 20, -1);
                this.mc.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"combo.damage") + ": " + String.format("%.1f", Float.valueOf(this.combo.getDamage())), 10, 30, -1);
                List<Float> damageList = this.combo.getDamageList();
                for (int i = 0; i < damageList.size() && i < Config.getHitsToDisplay(); ++i) {
                    this.mc.field_71466_p.func_78276_b(" +" + String.format("%.1f", damageList.get(damageList.size() - i - 1)), 10, 40 + 10 * i, -1);
                }
            }
        }
    }
}

