/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network;

import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractPacket;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class TargetIdPacket
extends AbstractPacket {
    private byte skillId;
    private Entity entity;
    private int entityId;
    boolean isNull = false;

    public TargetIdPacket() {
    }

    public TargetIdPacket(SkillBase skill) throws IllegalArgumentException {
        if (!(skill instanceof ILockOnTarget)) {
            throw new IllegalArgumentException("Parameter 'skill' must be an instance of ILockOnTarget while constructing TargetIdPacket");
        }
        this.skillId = skill.id;
        this.entity = ((ILockOnTarget)((Object)skill)).getCurrentTarget();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (this.entity != null) {
            buffer.writeByte(1);
            buffer.writeByte((int)this.skillId);
            buffer.writeInt(this.entity.func_145782_y());
        } else {
            buffer.writeByte(0);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (buffer.readByte() == 1) {
            this.skillId = buffer.readByte();
            this.entityId = buffer.readInt();
        } else {
            this.isNull = true;
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
        if (skill != null) {
            if (!this.isNull) {
                Entity entity = player.field_70170_p.func_73045_a(this.entityId);
                if (entity != null) {
                    skill.setCurrentTarget(entity);
                } else {
                    skill.setCurrentTarget(null);
                }
            } else {
                skill.setCurrentTarget(null);
            }
        }
    }
}

