/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.network.UpdateComboPacket;
import dynamicswordskills.skills.SkillBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class Combo {
    private final byte skillId;
    private final int maxComboSize;
    private final int timeLimit;
    private int comboTimer = 0;
    private final List<Float> damageList = new ArrayList<Float>();
    private float comboDamage = 0.0f;
    private boolean isFinished = false;

    public Combo(EntityPlayer player, SkillBase skill, int maxComboSize, int timeLimit) {
        this.skillId = skill.id;
        this.maxComboSize = maxComboSize;
        this.timeLimit = timeLimit;
        DynamicSwordSkills.dispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
    }

    private Combo(byte skillId, int maxComboSize, int timeLimit) {
        this.skillId = skillId;
        this.maxComboSize = maxComboSize;
        this.timeLimit = timeLimit;
    }

    public byte getSkill() {
        return this.skillId;
    }

    public int getSize() {
        return this.damageList.size();
    }

    public int getMaxSize() {
        return this.maxComboSize;
    }

    public float getDamage() {
        return this.comboDamage;
    }

    public List<Float> getDamageList() {
        return new ArrayList<Float>(this.damageList);
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public String getLabel() {
        return StatCollector.func_74838_a((String)("combo.label." + Math.min(this.getSize(), 10)));
    }

    public void onUpdate(EntityPlayer player) {
        if (this.comboTimer > 0) {
            --this.comboTimer;
            if (this.comboTimer == 0) {
                this.endCombo(player);
            }
        }
    }

    public void add(EntityPlayer player, float damage) {
        if (this.getSize() < this.maxComboSize && (this.comboTimer > 0 || this.getSize() == 0)) {
            this.damageList.add(Float.valueOf(damage));
            this.comboDamage += damage;
            DynamicSwordSkills.dispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            if (this.getSize() == this.maxComboSize) {
                this.endCombo(player);
            } else {
                this.comboTimer = this.timeLimit;
            }
        } else {
            this.endCombo(player);
        }
    }

    public void addDamageOnly(EntityPlayer player, float damage) {
        if (!this.isFinished()) {
            this.comboDamage += damage;
            if (this.getSize() == 0) {
                this.comboTimer = this.timeLimit;
            }
            DynamicSwordSkills.dispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
        }
    }

    public void endCombo(EntityPlayer player) {
        if (!this.isFinished) {
            this.isFinished = true;
            if (!player.field_70170_p.field_72995_K) {
                DynamicSwordSkills.dispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    public final NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("SkillID", this.skillId);
        compound.func_74768_a("MaxSize", this.maxComboSize);
        compound.func_74768_a("TimeLimit", this.timeLimit);
        compound.func_74768_a("CurrentSize", this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            compound.func_74776_a("Dmg" + i, this.damageList.get(i).floatValue());
        }
        compound.func_74776_a("TotalDamage", this.comboDamage);
        compound.func_74757_a("Finished", this.isFinished);
        return compound;
    }

    public static final Combo readFromNBT(NBTTagCompound compound) {
        Combo combo = new Combo(compound.func_74771_c("SkillID"), compound.func_74762_e("MaxSize"), compound.func_74762_e("TimeLimit"));
        int size = compound.func_74762_e("CurrentSize");
        for (int i = 0; i < size; ++i) {
            combo.damageList.add(Float.valueOf(compound.func_74760_g("Dmg" + i)));
        }
        combo.comboDamage = compound.func_74760_g("TotalDamage");
        combo.isFinished = compound.func_74767_n("Finished");
        return combo;
    }
}

