/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.DamageUtils;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Dash
extends SkillActive {
    private boolean isActive = false;
    private double distance;
    private Entity target;
    @SideOnly(value=Side.CLIENT)
    private boolean isRMBDown;

    public Dash(String name, byte id) {
        super(name, id);
        this.setDisablesLMB();
        this.addDescription(Arrays.asList("dash.desc.0", "dash.desc.1"));
    }

    private Dash(Dash skill) {
        super(skill);
    }

    @Override
    public Dash newInstance() {
        return new Dash(this);
    }

    @Override
    public List<String> getDescription(EntityPlayer player) {
        ArrayList<String> desc = new ArrayList<String>(4);
        desc.add((String)this.tooltip.get(0));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.dash.desc.2", (Object[])new Object[]{String.format("%.1f", this.getRange())}));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.dash.desc.3", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.getDamage()))}));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.dash.desc.4", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getExhaustion()))}));
        return desc;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && DSSPlayerInfo.get(player).isSkillActive(swordBasic) && PlayerUtils.isHoldingSword(player);
    }

    private float getDamage() {
        return 4.0f + (float)this.level;
    }

    private double getRange() {
        return 3.0 + (double)this.level;
    }

    private void deactivate() {
        this.isActive = false;
        this.distance = 0.0;
    }

    @Override
    protected float getExhaustion() {
        return 1.0f - 0.1f * (float)this.level;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        this.isActive = super.activate(world, player);
        if (this.isActive) {
            ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
            this.target = skill != null && skill.isLockedOn() ? skill.getCurrentTarget() : TargetUtils.acquireLookTarget((EntityLivingBase)player, (int)this.getRange(), this.getRange(), true);
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
        if (player.field_70170_p.field_72995_K && (skill == null || !skill.isLockedOn())) {
            this.isRMBDown = false;
        }
        if (this.isActive()) {
            if (this.target instanceof EntityLivingBase) {
                double d0 = 0.15 * (this.target.field_70165_t - player.field_70165_t);
                double d1 = 0.15 * (this.target.field_70163_u + (double)(this.target.field_70131_O / 3.0f) - player.field_70163_u);
                double d2 = 0.15 * (this.target.field_70161_v - player.field_70161_v);
                Vec3 vec3 = player.field_70170_p.func_82732_R().func_72345_a(d0, d1, d2);
                player.func_70024_g(vec3.field_72450_a, 0.0, vec3.field_72449_c);
                this.distance += vec3.func_72433_c();
                if (this.target.func_70068_e((Entity)player) <= 9.0) {
                    if (this.distance > 2.0 - 0.2 * (double)this.level) {
                        this.target.func_70097_a(DamageUtils.causeNonSwordDamage((Entity)player), this.getDamage());
                        this.target.func_70024_g(vec3.field_72450_a * (0.2 + 0.1 * (double)this.level), 0.1 + (double)this.level * 0.025, vec3.field_72449_c * (0.2 + 0.1 * (double)this.level));
                    }
                    player.field_70179_y = 0.0;
                    player.field_70159_w = 0.0;
                    player.func_70024_g(-vec3.field_72450_a, 0.0, -vec3.field_72449_c);
                    player.field_70170_p.func_72956_a((Entity)player, "dynamicswordskills:slam", player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f));
                    this.deactivate();
                }
                if (this.distance > this.getRange()) {
                    this.deactivate();
                }
            } else {
                this.deactivate();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(boolean pressed) {
        this.isRMBDown = pressed;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isRMBDown() {
        return this.isRMBDown;
    }
}

