/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.lib.Config;
import dynamicswordskills.network.ActivateSkillPacket;
import dynamicswordskills.skills.SkillActive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Dodge
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private int dodgeTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keyPressed;

    public Dodge(String name, byte id) {
        super(name, id);
        this.setDisablesLMB();
        this.addDescription("dodge.desc.0");
    }

    private Dodge(Dodge skill) {
        super(skill);
    }

    @Override
    public Dodge newInstance() {
        return new Dodge(this);
    }

    @Override
    public boolean isActive() {
        return this.dodgeTimer > 0;
    }

    @Override
    public List<String> getDescription(EntityPlayer player) {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip);
        desc.add(StatCollector.func_74837_a((String)"skill.dss.dodge.desc.1", (Object[])new Object[]{(int)(this.getDodgeChance(player) * 100.0f)}));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.dodge.desc.2", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getExhaustion()))}));
        return desc;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && DSSPlayerInfo.get(player).isSkillActive(swordBasic);
    }

    @Override
    protected float getExhaustion() {
        return 0.05f;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (this.canUse(player)) {
            DSSPlayerInfo.get(player).setCurrentActiveSkill(this);
            this.dodgeTimer = this.getDodgeTime();
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_71020_j(this.getExhaustion());
            }
        }
        return this.isActive();
    }

    private int getDodgeTime() {
        return 5 + this.level;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            --this.dodgeTimer;
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            if (!Config.requiresDoubleTap() && !this.keyPressed.func_151470_d()) {
                this.activate(player.field_70170_p, player);
                DynamicSwordSkills.dispatcher.sendToServer(new ActivateSkillPacket(this));
                this.ticksTilFail = 0;
            } else {
                --this.ticksTilFail;
            }
        }
    }

    private float getDodgeChance(EntityPlayer player) {
        return (float)this.level * 0.1f + (float)this.dodgeTimer * 0.02f;
    }

    public boolean dodgeAttack(EntityPlayer player) {
        return player.field_70170_p.field_73012_v.nextFloat() < this.getDodgeChance(player);
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(KeyBinding key, EntityPlayer player) {
        if (!this.isActive()) {
            if (Config.requiresDoubleTap() && this.ticksTilFail > 0 && key == this.keyPressed) {
                this.activate(player.field_70170_p, player);
                DynamicSwordSkills.dispatcher.sendToServer(new ActivateSkillPacket(this));
                this.ticksTilFail = 0;
            } else {
                this.keyPressed = key;
                this.ticksTilFail = Config.requiresDoubleTap() ? 6 : 3;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender() {
        return this.dodgeTimer > this.level;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player) {
        if (this.shouldRender()) {
            double d = 0.05;
            Vec3 vec3 = player.func_70040_Z();
            if (this.keyPressed == DSSKeyHandler.keys[4] || Config.allowVanillaControls() && this.keyPressed == Minecraft.func_71410_x().field_71474_y.field_74366_z) {
                player.func_70024_g(-vec3.field_72449_c * d, 0.0, vec3.field_72450_a * d);
            } else {
                player.func_70024_g(vec3.field_72449_c * d, 0.0, -vec3.field_72450_a * d);
            }
            return true;
        }
        return false;
    }
}

