/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.MortalDrawPacket;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class MortalDraw
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private boolean isRMBDown;
    private static final int DELAY = 30;
    private int attackTimer;
    private int swordSlot;

    public MortalDraw(String name, byte id) {
        super(name, id);
        this.setDisablesLMB();
        this.addDescription(Arrays.asList("mortaldraw.desc.0", "mortaldraw.desc.1"));
    }

    private int getAttackTime() {
        return this.level + 30 + 2;
    }

    private MortalDraw(MortalDraw skill) {
        super(skill);
    }

    @Override
    public MortalDraw newInstance() {
        return new MortalDraw(this);
    }

    @Override
    public List<String> getDescription(EntityPlayer player) {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip);
        desc.add(StatCollector.func_74837_a((String)"skill.dss.mortaldraw.desc.2", (Object[])new Object[]{this.getAttackTime() - 30}));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.mortaldraw.desc.3", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getExhaustion()))}));
        return desc;
    }

    @Override
    public boolean isActive() {
        return this.attackTimer > 30;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && this.attackTimer == 0 && this.swordSlot > -1 && DSSPlayerInfo.get(player).isSkillActive(swordBasic) && player.func_70694_bm() == null;
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (this.attackTimer == 0) {
            this.swordSlot = -1;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemSword)) continue;
                this.swordSlot = i;
                break;
            }
        }
        if (super.activate(world, player)) {
            this.attackTimer = this.getAttackTime();
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.attackTimer > 0) {
            --this.attackTimer;
            if (this.attackTimer == 30 && !player.field_70170_p.field_72995_K) {
                this.drawSword(player, null);
                if (player.func_70694_bm() != null) {
                    DynamicSwordSkills.dispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                }
            }
        }
    }

    public boolean drawSword(EntityPlayer player, Entity attacker) {
        if (this.swordSlot > -1 && this.swordSlot != player.field_71071_by.field_70461_c) {
            player.func_70062_b(0, player.field_71071_by.func_70301_a(this.swordSlot));
            player.field_71071_by.func_70299_a(this.swordSlot, null);
            this.swordSlot = -1;
            if (player.field_70170_p.field_72995_K) {
                this.isRMBDown = false;
            } else {
                ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
                return skill != null && skill.getCurrentTarget() == attacker;
            }
        }
        return false;
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        this.attackTimer = 30;
        event.ammount *= 2.0f;
        player.field_70170_p.func_72956_a((Entity)player, "dynamicswordskills:mortaldraw", player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f));
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(boolean pressed) {
        this.isRMBDown = pressed;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isRMBDown() {
        return this.isRMBDown;
    }
}

