/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.lib.Config;
import dynamicswordskills.network.ActivateSkillPacket;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class Parry
extends SkillActive {
    private int parryTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private boolean playMissSound;

    public Parry(String name, byte id) {
        super(name, id);
        this.setDisablesLMB();
        this.addDescription("parry.desc.0");
    }

    private Parry(Parry skill) {
        super(skill);
    }

    @Override
    public Parry newInstance() {
        return new Parry(this);
    }

    @Override
    public List<String> getDescription(EntityPlayer player) {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip);
        desc.add(StatCollector.func_74837_a((String)"skill.dss.parry.desc.1", (Object[])new Object[]{(int)(this.getDisarmChance(player, null) * 100.0f)}));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.parry.desc.2", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getExhaustion()))}));
        return desc;
    }

    @Override
    public boolean isActive() {
        return this.parryTimer > 0;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && DSSPlayerInfo.get(player).isSkillActive(swordBasic) && PlayerUtils.isHoldingSword(player);
    }

    @Override
    protected float getExhaustion() {
        return 0.3f - 0.02f * (float)this.level;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (super.activate(world, player)) {
            this.parryTimer = 6 + this.level;
            player.func_71038_i();
            this.playMissSound = true;
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (--this.parryTimer <= this.getParryDelay() && this.playMissSound) {
                this.playMissSound = false;
                player.func_85030_a("dynamicswordskills:swordmiss", player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f));
            }
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            if (!Config.requiresDoubleTap() && !Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
                DynamicSwordSkills.dispatcher.sendToServer(new ActivateSkillPacket(this));
                this.ticksTilFail = 0;
            } else {
                --this.ticksTilFail;
            }
        }
    }

    private int getParryDelay() {
        return 5 - this.level / 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(EntityPlayer player) {
        if (!this.isActive()) {
            if (Config.requiresDoubleTap() && this.ticksTilFail > 0) {
                DynamicSwordSkills.dispatcher.sendToServer(new ActivateSkillPacket(this));
                this.ticksTilFail = 0;
            } else {
                this.ticksTilFail = Config.requiresDoubleTap() ? 6 : 3;
            }
        }
    }

    public boolean parryAttack(EntityPlayer player, EntityLivingBase attacker) {
        if (this.parryTimer > this.getParryDelay() && attacker.func_70694_bm() != null) {
            this.parryTimer = this.getParryDelay();
            player.field_70170_p.func_72956_a((Entity)player, "dynamicswordskills:swordstrike", player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f));
            this.playMissSound = false;
            if (player.field_70170_p.field_73012_v.nextFloat() < this.getDisarmChance(player, attacker)) {
                this.disarm(attacker);
            }
            return true;
        }
        return false;
    }

    private float getDisarmChance(EntityPlayer player, EntityLivingBase attacker) {
        float penalty = 0.0f;
        float bonus = 0.025f * (float)(this.parryTimer > 0 ? this.parryTimer - this.getParryDelay() : 0);
        if (attacker instanceof EntityPlayer) {
            penalty = 0.1f * (float)DSSPlayerInfo.get((EntityPlayer)attacker).getSkillLevel(this);
        }
        return (float)this.level * 0.1f - penalty + bonus;
    }

    private void disarm(EntityLivingBase attacker) {
        if (attacker.func_70694_bm() != null) {
            EntityItem drop = new EntityItem(attacker.field_70170_p, attacker.field_70165_t, attacker.field_70163_u - (double)0.3f + (double)attacker.func_70047_e(), attacker.field_70161_v, attacker.func_70694_bm().func_77946_l());
            float f = 0.3f;
            float f1 = attacker.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            drop.field_70159_w = -MathHelper.func_76126_a((float)(attacker.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(attacker.field_70125_A / 180.0f * (float)Math.PI)) * f;
            drop.field_70179_y = MathHelper.func_76134_b((float)(attacker.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(attacker.field_70125_A / 180.0f * (float)Math.PI)) * f;
            drop.field_70181_x = -MathHelper.func_76126_a((float)(attacker.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f * attacker.field_70170_p.field_73012_v.nextFloat();
            drop.field_70159_w += Math.cos(f1) * (double)f;
            drop.field_70181_x += (double)((attacker.field_70170_p.field_73012_v.nextFloat() - attacker.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
            drop.field_70179_y += Math.sin(f1) * (double)f;
            drop.field_145804_b = 40;
            attacker.field_70170_p.func_72838_d((Entity)drop);
            attacker.func_70062_b(0, (ItemStack)null);
        }
    }
}

