/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.ActivateSkillPacket;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class SkillActive
extends SkillBase {
    private boolean allowUserActivation = true;
    private boolean disablesLMB = false;

    protected SkillActive(String name, byte id) {
        super(name, id, true);
    }

    protected SkillActive(SkillActive skill) {
        super(skill);
        this.allowUserActivation = skill.allowUserActivation;
        this.disablesLMB = skill.disablesLMB;
    }

    @Override
    public List<String> getDescription(EntityPlayer player) {
        return this.tooltip;
    }

    public abstract boolean isActive();

    protected abstract float getExhaustion();

    public boolean activate(World world, EntityPlayer player) {
        if (this.allowUserActivation) {
            return this.trigger(world, player);
        }
        return false;
    }

    public boolean trigger(World world, EntityPlayer player) {
        if (this.canUse(player)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_71020_j(this.getExhaustion());
            }
            if (!world.field_72995_K) {
                DynamicSwordSkills.dispatcher.sendTo(new ActivateSkillPacket(this), (EntityPlayerMP)player);
            } else if (this.disablesLMB) {
                DSSPlayerInfo.get(player).setCurrentActiveSkill(this);
            }
            return true;
        }
        if (this.level > 0) {
            PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.dss.skill.use.fail", (Object[])new Object[]{this.name}));
        }
        return false;
    }

    public boolean canUse(EntityPlayer player) {
        return this.level > 0 && player.func_71024_bL().func_75116_a() > 0;
    }

    protected SkillActive disableUserActivation() {
        this.allowUserActivation = false;
        return this;
    }

    protected SkillActive setDisablesLMB() {
        this.disablesLMB = true;
        return this;
    }

    @Override
    protected void levelUp(EntityPlayer player) {
    }

    @Override
    public final void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("id", this.id);
        compound.func_74774_a("level", this.level);
    }

    @Override
    public final void readFromNBT(NBTTagCompound compound) {
        this.level = compound.func_74771_c("level");
    }

    @Override
    public final SkillActive loadFromNBT(NBTTagCompound compound) {
        SkillActive skill = (SkillActive)SkillActive.getSkillList()[compound.func_74771_c("id")].newInstance();
        skill.readFromNBT(compound);
        return skill;
    }
}

