/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.network.SyncSkillPacket;
import dynamicswordskills.skills.ArmorBreak;
import dynamicswordskills.skills.Dash;
import dynamicswordskills.skills.Dodge;
import dynamicswordskills.skills.LeapingBlow;
import dynamicswordskills.skills.MortalDraw;
import dynamicswordskills.skills.Parry;
import dynamicswordskills.skills.SpinAttack;
import dynamicswordskills.skills.SwordBasic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public abstract class SkillBase {
    public static final byte MAX_NUM_SKILLS = 16;
    public static final byte MAX_LEVEL = 5;
    private static int skillIndex = 0;
    private static final SkillBase[] skillsList = new SkillBase[16];
    public static final SkillBase swordBasic = new SwordBasic("Basic Sword Skill", (byte)skillIndex++);
    public static final SkillBase armorBreak = new ArmorBreak("Armor Break", (byte)skillIndex++);
    public static final SkillBase dodge = new Dodge("Dodge", (byte)skillIndex++);
    public static final SkillBase leapingBlow = new LeapingBlow("Leaping Blow", (byte)skillIndex++);
    public static final SkillBase parry = new Parry("Parry", (byte)skillIndex++);
    public static final SkillBase dash = new Dash("Dash", (byte)skillIndex++);
    public static final SkillBase spinAttack = new SpinAttack("Spin Attack", (byte)skillIndex++);
    public static final SkillBase superSpinAttack = new SpinAttack("Super Spin Attack", (byte)skillIndex++);
    public static final SkillBase mortalDraw = new MortalDraw("Mortal Draw", (byte)skillIndex++);
    public final String name;
    protected final String unlocalizedName;
    public final byte id;
    protected byte level = 0;
    protected final List<String> tooltip = new ArrayList<String>();

    public SkillBase(String name, byte id, boolean register) {
        this.name = name;
        this.unlocalizedName = this.name.replace(" ", "").toLowerCase();
        this.id = id;
        if (register) {
            if (skillsList[id] != null) {
                System.out.println("CONFLICT @ skill " + id + " id already occupied by " + SkillBase.skillsList[id].name + " while adding " + name);
            }
            SkillBase.skillsList[id] = this;
        }
    }

    public SkillBase(SkillBase skill) {
        this.name = skill.name;
        this.unlocalizedName = skill.unlocalizedName;
        this.id = skill.id;
        this.tooltip.addAll(skill.tooltip);
    }

    public static final SkillBase[] getSkillList() {
        return skillsList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SkillBase skill = (SkillBase)o;
            return skill.id == this.id && skill.level == this.level;
        }
        return false;
    }

    public abstract SkillBase newInstance();

    public final String getUnlocalizedName() {
        return "skill.dss." + this.unlocalizedName + ".name";
    }

    public boolean canDrop() {
        return true;
    }

    public final byte getLevel() {
        return this.level;
    }

    public int getMaxLevel() {
        return 5;
    }

    public final List<String> getDescription() {
        return this.level > 0 ? this.getDescription() : this.tooltip;
    }

    public abstract List<String> getDescription(EntityPlayer var1);

    protected final SkillBase addDescription(String string) {
        this.tooltip.add(StatCollector.func_74838_a((String)("skill.dss." + string)));
        return this;
    }

    protected final SkillBase addDescription(List<String> list) {
        for (String s : list) {
            this.addDescription(s);
        }
        return this;
    }

    protected boolean canIncreaseLevel(EntityPlayer player, int targetLevel) {
        return this.level + 1 == targetLevel && targetLevel <= this.getMaxLevel();
    }

    protected abstract void levelUp(EntityPlayer var1);

    public void validateSkill(EntityPlayer player) {
        this.levelUp(player);
    }

    public final boolean grantSkill(EntityPlayer player) {
        return this.grantSkill(player, this.level + 1);
    }

    public final boolean grantSkill(EntityPlayer player, int targetLevel) {
        if (targetLevel <= this.level || targetLevel > this.getMaxLevel()) {
            return false;
        }
        byte oldLevel = this.level;
        while (this.level < targetLevel && this.canIncreaseLevel(player, this.level + 1)) {
            this.level = (byte)(this.level + 1);
            this.levelUp(player);
        }
        if (!player.field_70170_p.field_72995_K && oldLevel < this.level) {
            DynamicSwordSkills.dispatcher.sendTo(new SyncSkillPacket(this), (EntityPlayerMP)player);
        }
        return oldLevel < this.level;
    }

    public void onUpdate(EntityPlayer player) {
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract SkillBase loadFromNBT(NBTTagCompound var1);
}

