/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.lib.Config;
import dynamicswordskills.network.ActivateSkillPacket;
import dynamicswordskills.network.EndComboPacket;
import dynamicswordskills.network.TargetIdPacket;
import dynamicswordskills.skills.Combo;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class SwordBasic
extends SkillActive
implements ICombo,
ILockOnTarget {
    private boolean isActive = false;
    @SideOnly(value=Side.CLIENT)
    private boolean packetSent;
    private EntityLivingBase currentTarget = null;
    @SideOnly(value=Side.CLIENT)
    private EntityLivingBase prevTarget;
    private Combo combo = null;

    public SwordBasic(String name, byte id) {
        super(name, id);
        this.addDescription(Arrays.asList("basicswordskill.desc.0", "basicswordskill.desc.1"));
    }

    private SwordBasic(SwordBasic skill) {
        super(skill);
    }

    @Override
    public SwordBasic newInstance() {
        return new SwordBasic(this);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    protected float getExhaustion() {
        return 0.0f;
    }

    @Override
    public int getMaxLevel() {
        return 10;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (super.activate(world, player)) {
            boolean bl = this.isActive = !this.isActive;
            if (this.isActive) {
                if (!this.isComboInProgress()) {
                    this.combo = null;
                }
                this.currentTarget = TargetUtils.acquireLookTarget((EntityLivingBase)player, this.getMaxTargetDistance(), this.getMaxTargetDistance(), true);
            } else {
                this.currentTarget = null;
                if (world.field_72995_K) {
                    this.prevTarget = null;
                    if (this.packetSent) {
                        this.packetSent = false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive && player.field_70170_p.field_72995_K && !this.packetSent && (Minecraft.func_71410_x().field_71462_r != null || !this.updateTargets(player))) {
            DynamicSwordSkills.dispatcher.sendToServer(new ActivateSkillPacket(this));
            this.packetSent = true;
        }
        if (this.isComboInProgress()) {
            this.combo.onUpdate(player);
        }
    }

    @Override
    public final boolean isLockedOn() {
        return this.currentTarget != null;
    }

    public final EntityLivingBase getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public void setCurrentTarget(Entity entity) {
        if (entity == null || entity instanceof EntityLivingBase) {
            this.currentTarget = (EntityLivingBase)entity;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void getNextTarget(EntityPlayer player) {
        EntityLivingBase nextTarget = null;
        double dTarget = 0.0;
        List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, this.getMaxTargetDistance(), this.getMaxTargetDistance());
        for (EntityLivingBase entity : list) {
            if (entity == player || entity == this.currentTarget || entity == this.prevTarget || !this.isTargetValid(player, entity)) continue;
            if (nextTarget == null) {
                dTarget = player.func_70068_e((Entity)entity);
                nextTarget = entity;
                continue;
            }
            double distance = player.func_70068_e((Entity)entity);
            if (!(distance < dTarget)) continue;
            nextTarget = entity;
            dTarget = distance;
        }
        if (nextTarget != null) {
            this.prevTarget = this.currentTarget;
            this.currentTarget = nextTarget;
        } else {
            nextTarget = this.currentTarget;
            this.currentTarget = this.prevTarget;
            this.prevTarget = nextTarget;
        }
        DynamicSwordSkills.dispatcher.sendToServer(new TargetIdPacket(this));
    }

    private final int getMaxTargetDistance() {
        return 6 + this.level;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean updateTargets(EntityPlayer player) {
        if (!this.isTargetValid(player, this.prevTarget) || !TargetUtils.isTargetInSight((EntityLivingBase)player, (Entity)this.prevTarget)) {
            this.prevTarget = null;
        }
        if (!this.isTargetValid(player, this.currentTarget)) {
            this.currentTarget = null;
            if (Config.autoTargetEnabled()) {
                this.getNextTarget(player);
            }
        }
        return this.isTargetValid(player, this.currentTarget);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isTargetValid(EntityPlayer player, EntityLivingBase target) {
        return target != null && !target.field_70128_L && target.func_110143_aJ() > 0.0f && player.func_70032_d((Entity)target) < (float)this.getMaxTargetDistance();
    }

    @Override
    public final Combo getCombo() {
        return this.combo;
    }

    @Override
    public final void setCombo(Combo combo) {
        this.combo = combo;
    }

    @Override
    public final boolean isComboInProgress() {
        return this.combo != null && !this.combo.isFinished();
    }

    private final int getMaxComboSize() {
        return 2 + this.level;
    }

    private final int getComboTimeLimit(EntityPlayer player) {
        return 20 + this.level * 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onAttack(EntityPlayer player) {
        boolean attackHit;
        Entity mouseOver = TargetUtils.getMouseOverEntity();
        boolean bl = attackHit = this.isLockedOn() && (TargetUtils.isMouseOverEntity((Entity)this.getCurrentTarget()) && TargetUtils.canReachTarget(player, (Entity)this.getCurrentTarget()) || mouseOver != null && TargetUtils.canReachTarget(player, mouseOver));
        if (!attackHit && PlayerUtils.isHoldingSword(player)) {
            PlayerUtils.playSound(player, "dynamicswordskills:swordmiss", player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f));
            if (this.isComboInProgress()) {
                DynamicSwordSkills.dispatcher.sendToServer(new EndComboPacket(this));
            }
        }
        return attackHit;
    }

    @Override
    public void onHurtTarget(EntityPlayer player, LivingHurtEvent event) {
        if (event.source.func_76352_a()) {
            return;
        }
        if ((this.combo == null || this.combo.isFinished()) && !player.field_70170_p.field_72995_K) {
            this.combo = new Combo(player, this, this.getMaxComboSize(), this.getComboTimeLimit(player));
        }
        if (event.source.field_76373_n.equals("indirectSword")) {
            this.combo.addDamageOnly(player, event.ammount);
        } else {
            this.combo.add(player, event.ammount);
        }
        if (event.source.field_76373_n.equals("player") && PlayerUtils.isHoldingSword(player)) {
            player.field_70170_p.func_72956_a((Entity)player, "dynamicswordskills:swordcut", player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f));
        }
    }

    @Override
    public void onPlayerHurt(EntityPlayer player, LivingHurtEvent event) {
        if (this.isComboInProgress() && event.ammount > 0.5f * (float)this.level) {
            this.combo.endCombo(player);
        }
    }
}

