/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels.proxy;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.TileEntityBarrel;
import need4speed402.mods.barrels.client.BarrelRender;
import need4speed402.mods.barrels.client.BarrelStepSound;
import need4speed402.mods.barrels.lib.BarrelType;
import need4speed402.mods.barrels.lib.LanguagePreSuf;
import need4speed402.mods.barrels.proxy.Proxy;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.util.StringTranslate;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy {
    @Override
    public void preInit() {
        TileEntityRendererDispatcher.field_147556_a.field_147559_m.put(TileEntityBarrel.class, BarrelRender.getInstance());
        BarrelRender.getInstance().func_147497_a(TileEntityRendererDispatcher.field_147556_a);
    }

    @Override
    public void init() {
        try {
            Field languageList;
            Method instance;
            ArrayList<String> languages = new ArrayList<String>();
            ArrayList<InputStream> languageFiles = new ArrayList<InputStream>();
            try {
                File file = new File(ProxyClient.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()));
                if (file.getPath().endsWith(".class")) {
                    file = new File(file.getPath().substring(0, file.getPath().lastIndexOf(this.getClass().getPackage().getName().replace(".", File.separator))));
                }
                if (file.isDirectory()) {
                    file = new File(file, "assets/barrels/lang");
                    for (File f : file.listFiles()) {
                        languages.add(f.getName().substring(0, f.getName().lastIndexOf(46)));
                        languageFiles.add(new BufferedInputStream(new FileInputStream(f)));
                    }
                } else {
                    JarEntry entry;
                    JarInputStream in = new JarInputStream(new BufferedInputStream(new FileInputStream(file)));
                    while ((entry = in.getNextJarEntry()) != null) {
                        int len;
                        if (!entry.getName().startsWith("assets/barrels/lang/") || entry.getName().endsWith("/")) continue;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((len = in.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                        languages.add(entry.getName().substring(entry.getName().lastIndexOf(47) + 1, entry.getName().lastIndexOf(46)));
                        languageFiles.add(new ByteArrayInputStream(out.toByteArray()));
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                LanguageManager manager = Minecraft.func_71410_x().func_135016_M();
                for (Language lang : manager.func_135040_d()) {
                    InputStream stream = this.getClass().getClassLoader().getResourceAsStream("assets/barrels/lang/" + lang.func_135034_a() + ".lang");
                    if (stream == null) continue;
                    languages.add(lang.func_135034_a());
                    languageFiles.add(stream);
                }
            }
            for (int i = 0; i < Math.min(languages.size(), languageFiles.size()); ++i) {
                Properties prop = new Properties();
                prop.load((InputStream)languageFiles.get(i));
                for (BarrelType barrel : Barrels.getBarrels()) {
                    if (barrel == null) continue;
                    LanguageRegistry.instance().addStringLocalization(barrel.getStack().func_77973_b().func_77657_g(barrel.getStack()) + ".name", (String)languages.get(i), prop.getProperty("T" + (barrel.getStack().func_77960_j() + 1) + "barrel"));
                }
                Barrels.addPrefixAndSuffex(new LanguagePreSuf((String)languages.get(i), prop.getProperty("prefix"), prop.getProperty("suffix")));
                ((InputStream)languageFiles.get(i)).close();
            }
            try {
                instance = StringTranslate.class.getDeclaredMethod("func_74808_a", new Class[0]);
                languageList = StringTranslate.class.getDeclaredField("field_74816_c");
            }
            catch (Exception e) {
                instance = StringTranslate.class.getDeclaredMethod("getInstance", new Class[0]);
                languageList = StringTranslate.class.getDeclaredField("languageList");
            }
            instance.setAccessible(true);
            languageList.setAccessible(true);
            Map map = (Map)languageList.get(instance.invoke(null, new Object[0]));
            LanguageRegistry.instance().loadLanguageTable(map, Minecraft.func_71410_x().field_71474_y.field_74363_ab);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init names", e);
        }
    }

    @Override
    public void postInit() {
        Barrels.getActiveBlock().func_149672_a((Block.SoundType)new BarrelStepSound(Block.field_149766_f));
    }

    private static String decode(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    sb.append(new String(new byte[]{Byte.parseByte(s.substring(i + 1, i + 3), 16)}, 0, 1, "UTF-8"));
                    i += 2;
                }
                catch (Exception e) {
                    sb.append(c);
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

