/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels.server.packet;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.BlockBarrel;
import need4speed402.mods.barrels.TileEntityBarrel;
import need4speed402.mods.barrels.lib.EntityItemFrame;
import need4speed402.mods.barrels.lib.Slot;
import need4speed402.mods.barrels.server.PacketType;
import need4speed402.mods.barrels.server.packet.PacketBarrel;
import need4speed402.mods.barrels.server.packet.PacketBarrelServer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapData;

public class PacketBarrelClient
extends PacketBarrel {
    public PacketBarrelClient() {
    }

    public PacketBarrelClient(int x, int y, int z, EntityItemFrame[] frames) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.frames = frames;
        this.mode = PacketType.FRAME;
    }

    public PacketBarrelClient(int x, int y, int z, int i, boolean isblockMetadata) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        if (isblockMetadata) {
            this.blockMetadata = i;
        } else {
            this.orientation = i;
        }
        this.mode = isblockMetadata ? PacketType.METADATA : PacketType.ORIENTATION;
    }

    public PacketBarrelClient(int x, int y, int z, MapData map, int id) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.map = map;
        this.itemMapID = id;
        this.mode = PacketType.MAP;
    }

    public PacketBarrelClient(int x, int y, int z, ItemStack item, int orientation, EntityItemFrame[] frames, boolean sendAll) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.item = item;
        this.orientation = orientation;
        this.frames = frames;
        this.mode = sendAll ? PacketType.ITEM_ALL : PacketType.ITEM;
    }

    public PacketBarrelClient(int x, int y, int z, int count, Slot[] playerSlots) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.item = new ItemStack((Item)null, count, 0);
        this.playerSlots = playerSlots;
        this.mode = playerSlots != null ? PacketType.COUNT_PLAYER : PacketType.COUNT;
    }

    public PacketBarrelClient(Slot[] playerSlots) {
        this();
        this.playerSlots = playerSlots;
        this.mode = PacketType.PLAYER;
    }

    public PacketBarrelClient(int x, int y, int z, ItemStack item, int orientation, EntityItemFrame[] frames, boolean sendAll, Slot[] playerSlots) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.item = item;
        this.orientation = orientation;
        this.frames = frames;
        this.playerSlots = playerSlots;
        this.mode = sendAll ? PacketType.ITEM_PLAYER_ALL : PacketType.ITEM_PLAYER;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler handeler) {
        this.processPacket((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e);
    }

    public void processPacket(EntityPlayer player, World world) {
        if (this.mode.forClient() && world.field_72995_K) {
            if (this.mode == PacketType.PLAYER) {
                this.setPlayerSlots(player);
            } else {
                TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, this.x, this.y, this.z);
                if (barrel != null) {
                    PacketBarrel responce = null;
                    switch (this.mode) {
                        case MAP: {
                            this.setMapData(world);
                            break;
                        }
                        case FRAME: {
                            this.setFrames(barrel, world);
                            break;
                        }
                        case ITEM_PLAYER_ALL: {
                            this.setMetadata(world);
                        }
                        case ITEM_PLAYER: {
                            this.setPlayerSlots(player);
                            this.setItem(barrel);
                            responce = this.checkIfNeedsMapData(world);
                            break;
                        }
                        case ITEM_ALL: {
                            this.setMetadata(world);
                        }
                        case ITEM: {
                            this.setItem(barrel);
                            responce = this.checkIfNeedsMapData(world);
                            break;
                        }
                        case METADATA: {
                            this.setMetadata(world);
                            break;
                        }
                        case ORIENTATION: {
                            barrel.setOrientation(this.orientation);
                            break;
                        }
                        case COUNT_PLAYER: {
                            this.setPlayerSlots(player);
                        }
                        case COUNT: {
                            this.setItemCount(barrel);
                            break;
                        }
                    }
                    this.setFrames(barrel, world);
                    this.setOrientation(barrel);
                    if (responce != null) {
                        Barrels.getPacketHandler().sendPacketToServer(responce);
                    }
                }
            }
        }
    }

    private void setItem(TileEntityBarrel barrel) {
        barrel.setItem(this.item);
    }

    private void setItemCount(TileEntityBarrel barrel) {
        ItemStack stack = barrel.getItem();
        if (stack != null) {
            stack.field_77994_a = this.item.field_77994_a;
            barrel.setItem(stack);
        }
    }

    private PacketBarrel checkIfNeedsMapData(World world) {
        MapData map;
        if (this.item != null && this.item.func_77973_b() == Items.field_151098_aY && (map = (MapData)world.func_72943_a(MapData.class, "map_" + this.item.func_77960_j())) == null) {
            return new PacketBarrelServer(this.x, this.y, this.z, false);
        }
        return null;
    }

    private void setOrientation(TileEntityBarrel barrel) {
        if (this.orientation != -1) {
            barrel.setOrientation(this.orientation);
        }
    }

    private void setMapData(World world) {
        String mapID = "map_" + this.itemMapID;
        MapData map = (MapData)world.func_72943_a(MapData.class, mapID);
        if (this.map instanceof MapData && (MapData)this.map != map) {
            map = (MapData)this.map;
            world.func_72823_a(mapID, (WorldSavedData)map);
        }
        if (map == null) {
            map = new MapData(mapID);
            world.func_72823_a(mapID, (WorldSavedData)map);
        }
        if (this.map instanceof NBTTagCompound) {
            map.func_76184_a((NBTTagCompound)this.map);
        }
        Minecraft.func_71410_x().field_71460_t.func_147701_i().func_148246_a(map);
    }

    private void setPlayerSlots(EntityPlayer player) {
        if (this.playerSlots != null) {
            ItemStack[] inv = player.field_71071_by.field_70462_a;
            for (int i = 0; i < this.playerSlots.length; ++i) {
                if (this.playerSlots[i].getItem() != null) {
                    this.playerSlots[i].getItem().field_77992_b = TileEntityBarrel.isSame(inv[this.playerSlots[i].getSlot()], this.playerSlots[i].getItem()) && inv[this.playerSlots[i].getSlot()].field_77992_b > 0 ? inv[this.playerSlots[i].getSlot()].field_77992_b : 5;
                }
                inv[this.playerSlots[i].getSlot()] = this.playerSlots[i].getItem();
            }
        }
    }

    private void setFrames(TileEntityBarrel barrel, World world) {
        if (this.frames != null) {
            for (int i = 0; i < barrel.getFrames().length; ++i) {
                if (this.frames[i] instanceof Boolean ? (Boolean)this.frames[i] != false : this.frames[i] != null) {
                    if (barrel.getFrames()[i] != null) continue;
                    EntityItemFrame entityItemFrame = barrel.getFrames()[i] = this.frames[i] instanceof Boolean ? new EntityItemFrame(world, this.x, this.y, this.z, i) : (EntityItemFrame)((Object)this.frames[i]);
                    if (barrel.getRawItem() != null) {
                        ItemStack item = barrel.getRawItem().func_77946_l();
                        item.field_77994_a = 1;
                        barrel.getFrames()[i].func_82334_a(item);
                        continue;
                    }
                    barrel.getFrames()[i].func_82334_a(null);
                    continue;
                }
                barrel.getFrames()[i] = null;
            }
        }
    }

    private void setMetadata(World world) {
        if (this.blockMetadata != -1) {
            world.func_72921_c(this.x, this.y, this.z, this.blockMetadata, 0);
            world.func_147471_g(this.x, this.y, this.z);
        }
    }

    private void checkChangedSlots(EntityPlayer player, TileEntityBarrel barrel) {
        int[] changedSlots = barrel.getChangedSlots(player);
        if (changedSlots != null) {
            boolean[] list = new boolean[changedSlots.length];
            int len = list.length;
            block0: for (int i = 0; i < this.playerSlots.length; ++i) {
                int len2 = len;
                for (int ii = 0; ii < Math.min(list.length, len2); ++ii) {
                    if (list[ii]) {
                        ++len2;
                        continue;
                    }
                    if (this.playerSlots[i].getSlot() != changedSlots[ii]) continue;
                    list[ii] = true;
                    --len;
                    continue block0;
                }
            }
            if (len > 0) {
                Slot[] slots = new Slot[len];
                int slotIndex = 0;
                for (int i = 0; i < len; ++i) {
                    if (list[i]) {
                        ++len;
                        continue;
                    }
                    slots[slotIndex++] = new Slot(changedSlots[i]);
                }
                Barrels.getPacketHandler().sendServerRequestForPlayerInventory(this.x, this.y, this.z, slots);
            }
        }
        barrel.clearChangedSlots();
    }

    public PacketBarrelClient clone() {
        PacketBarrelClient p = new PacketBarrelClient();
        p.blockMetadata = this.blockMetadata;
        p.item = this.item;
        p.frames = this.frames;
        p.map = this.map;
        p.mode = this.mode;
        p.orientation = this.orientation;
        p.x = this.x;
        p.y = this.y;
        p.z = this.z;
        p.playerSlots = this.playerSlots;
        return p;
    }
}

