/*
 * Decompiled with CFR 0.152.
 */
package evilcraft;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import evilcraft.CustomRecipe;
import evilcraft.CustomRecipeRegistry;
import evilcraft.CustomRecipeResult;
import evilcraft.EvilCraft;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.blocks.BloodChest;
import evilcraft.blocks.BloodChestConfig;
import evilcraft.blocks.BloodInfuser;
import evilcraft.blocks.BloodInfuserConfig;
import evilcraft.blocks.BloodStainedBlock;
import evilcraft.blocks.DarkBlock;
import evilcraft.blocks.DarkBlockConfig;
import evilcraft.blocks.DarkOre;
import evilcraft.blocks.LightningBomb;
import evilcraft.blocks.LightningBombConfig;
import evilcraft.blocks.ObscuredGlass;
import evilcraft.blocks.ObscuredGlassConfig;
import evilcraft.blocks.UndeadLog;
import evilcraft.blocks.UndeadLogConfig;
import evilcraft.blocks.UndeadPlank;
import evilcraft.blocks.UndeadPlankConfig;
import evilcraft.blocks.UndeadSapling;
import evilcraft.blocks.UndeadSaplingConfig;
import evilcraft.enchantment.EnchantmentPoisonTip;
import evilcraft.enchantment.EnchantmentPoisonTipConfig;
import evilcraft.fluids.Blood;
import evilcraft.fluids.BloodConfig;
import evilcraft.fluids.Poison;
import evilcraft.items.BloodContainer;
import evilcraft.items.BloodContainerConfig;
import evilcraft.items.BloodExtractor;
import evilcraft.items.BloodExtractorConfig;
import evilcraft.items.BloodInfusionCore;
import evilcraft.items.BloodInfusionCoreConfig;
import evilcraft.items.BloodPearlOfTeleportation;
import evilcraft.items.BloodPearlOfTeleportationConfig;
import evilcraft.items.BucketPoison;
import evilcraft.items.BucketPoisonConfig;
import evilcraft.items.DarkGem;
import evilcraft.items.DarkGemConfig;
import evilcraft.items.DarkPowerGem;
import evilcraft.items.DarkPowerGemConfig;
import evilcraft.items.DarkStick;
import evilcraft.items.DarkStickConfig;
import evilcraft.items.HardenedBloodShard;
import evilcraft.items.HardenedBloodShardConfig;
import evilcraft.items.LightningGrenade;
import evilcraft.items.LightningGrenadeConfig;
import evilcraft.items.WeatherContainer;
import evilcraft.items.WeatherContainerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Recipes {
    public static Map<Item, FluidStack> BUCKETS = new HashMap<Item, FluidStack>();

    public static boolean isItemEnabled(Class<? extends ExtendedConfig> config) {
        try {
            return ((ExtendedConfig)config.getField("_instance").get(null)).isEnabled();
        }
        catch (NullPointerException e1) {
            return false;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
        catch (IllegalAccessException e3) {
            return false;
        }
        catch (NoSuchFieldException e3) {
            return false;
        }
        catch (SecurityException e4) {
            return false;
        }
    }

    public static void registerRecipes() {
        if (Recipes.isItemEnabled(DarkGemConfig.class) && Recipes.isItemEnabled(DarkBlockConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)DarkBlock.getInstance(), new Object[]{true, new Object[]{"GGG", "GGG", "GGG", Character.valueOf('G'), DarkGemConfig._instance.getOreDictionaryId()}}));
        }
        if (Recipes.isItemEnabled(DarkGemConfig.class) && Recipes.isItemEnabled(DarkBlockConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)DarkGem.getInstance(), 9), new Object[]{new ItemStack((Block)DarkBlock.getInstance())}));
        }
        if (Recipes.isItemEnabled(WeatherContainerConfig.class) && Recipes.isItemEnabled(DarkPowerGemConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)WeatherContainer.getInstance()), new Object[]{true, new Object[]{" G ", " P ", " S ", Character.valueOf('G'), new ItemStack((Item)DarkPowerGem.getInstance()), Character.valueOf('P'), new ItemStack(Items.field_151069_bo), Character.valueOf('S'), new ItemStack(Items.field_151102_aT)}}));
        }
        if (Recipes.isItemEnabled(BloodPearlOfTeleportationConfig.class) && Recipes.isItemEnabled(DarkPowerGemConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BloodPearlOfTeleportation.getInstance()), new Object[]{true, new Object[]{"EGE", "GEG", "EGE", Character.valueOf('G'), new ItemStack((Item)DarkPowerGem.getInstance()), Character.valueOf('E'), new ItemStack(Items.field_151079_bi)}}));
        }
        if (Recipes.isItemEnabled(BloodInfusionCoreConfig.class) && Recipes.isItemEnabled(HardenedBloodShardConfig.class) && Recipes.isItemEnabled(DarkPowerGemConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BloodInfusionCore.getInstance()), new Object[]{true, new Object[]{"SSS", "SGS", "SSS", Character.valueOf('S'), new ItemStack((Item)HardenedBloodShard.getInstance()), Character.valueOf('G'), new ItemStack((Item)DarkPowerGem.getInstance())}}));
        }
        if (Recipes.isItemEnabled(BloodInfusionCoreConfig.class) && Recipes.isItemEnabled(BloodInfuserConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)BloodInfuser.getInstance()), new Object[]{true, new Object[]{"CCC", "CIC", "CCC", Character.valueOf('C'), "cobblestone", Character.valueOf('I'), new ItemStack((Item)BloodInfusionCore.getInstance())}}));
        }
        if (Recipes.isItemEnabled(BloodInfusionCoreConfig.class) && Recipes.isItemEnabled(BloodChestConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)BloodChest.getInstance()), new Object[]{true, new Object[]{"PPP", "PIP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('I'), new ItemStack((Item)BloodInfusionCore.getInstance())}}));
        }
        if (Recipes.isItemEnabled(UndeadLogConfig.class) && Recipes.isItemEnabled(UndeadPlankConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)UndeadPlank.getInstance(), 4), new Object[]{new ItemStack((Block)UndeadLog.getInstance())}));
        }
        if (Recipes.isItemEnabled(UndeadPlankConfig.class) && Recipes.isItemEnabled(DarkGemConfig.class) && Recipes.isItemEnabled(DarkStickConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)DarkStick.getInstance()), new Object[]{true, new Object[]{" G ", " P ", " P ", Character.valueOf('G'), new ItemStack((Item)DarkGem.getInstance()), Character.valueOf('P'), new ItemStack((Block)UndeadPlank.getInstance())}}));
        }
        if (Recipes.isItemEnabled(BucketPoisonConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)BucketPoison.getInstance()), new Object[]{"materialPoisonous", "materialPoisonous", "materialPoisonous", "materialPoisonous", new ItemStack(Items.field_151131_as.func_77642_a(null))}));
        }
        if (Recipes.isItemEnabled(BucketPoisonConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151170_bI), new Object[]{new ItemStack(Items.field_151174_bG), new ItemStack((Item)BucketPoison.getInstance())}));
        }
        if (Recipes.isItemEnabled(BucketPoisonConfig.class) && Recipes.isItemEnabled(EnchantmentPoisonTipConfig.class)) {
            ItemStack poisonTipEnchant = new ItemStack((Item)Items.field_151134_bR);
            EnchantmentPoisonTip enchant = EnchantmentPoisonTip.getInstance();
            Items.field_151134_bR.func_92115_a(poisonTipEnchant, new EnchantmentData((Enchantment)enchant, enchant.func_77319_d()));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(poisonTipEnchant, new Object[]{new ItemStack((Item)BucketPoison.getInstance()), new ItemStack(Items.field_151122_aG)}));
        }
        if (Recipes.isItemEnabled(BucketPoisonConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)Items.field_151068_bn, 1, 8196), new Object[]{new ItemStack((Item)BucketPoison.getInstance()), new ItemStack(Items.field_151069_bo)}));
        }
        if (Recipes.isItemEnabled(ObscuredGlassConfig.class) && Recipes.isItemEnabled(DarkGemConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ObscuredGlass.getInstance(), 8), new Object[]{true, new Object[]{"GGG", "GDG", "GGG", Character.valueOf('D'), DarkGemConfig._instance.getOreDictionaryId(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w)}}));
        }
        if (Recipes.isItemEnabled(LightningGrenadeConfig.class) && Recipes.isItemEnabled(WeatherContainerConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)LightningGrenade.getInstance(), 8), new Object[]{true, new Object[]{"EEE", "ELE", "EEE", Character.valueOf('L'), new ItemStack((Item)WeatherContainer.getInstance(), 1, WeatherContainer.WeatherContainerTypes.LIGHTNING.ordinal()), Character.valueOf('E'), new ItemStack(Items.field_151079_bi)}}));
        }
        if (Recipes.isItemEnabled(LightningBombConfig.class) && Recipes.isItemEnabled(LightningGrenadeConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)LightningBomb.getInstance()), new Object[]{new ItemStack((Item)LightningGrenade.getInstance()), new ItemStack(Blocks.field_150335_W)}));
        }
        if (Recipes.isItemEnabled(BloodContainerConfig.class) && Recipes.isItemEnabled(DarkGemConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BloodContainer.getInstance(), 1, 0), new Object[]{true, new Object[]{"DDD", "DGD", "DDD", Character.valueOf('D'), new ItemStack((Item)DarkGem.getInstance()), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w)}}));
            for (int i = 1; i < BloodContainerConfig.getContainerLevels(); ++i) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)BloodContainer.getInstance(), 1, i), new Object[]{new ItemStack((Item)BloodContainer.getInstance(), 1, i - 1), new ItemStack((Item)BloodContainer.getInstance(), 1, i - 1)}));
            }
        }
        if (Recipes.isItemEnabled(BloodContainerConfig.class) && Recipes.isItemEnabled(BloodExtractorConfig.class)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)BloodExtractor.getInstance()), new Object[]{true, new Object[]{" I ", " S ", " C ", Character.valueOf('C'), new ItemStack((Item)BloodContainer.getInstance(), 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151120_aE), Character.valueOf('I'), new ItemStack(Items.field_151042_j)}}));
        }
        Recipes.registerCustomRecipes();
        Recipes.registerInterModRecipes();
    }

    private static void registerCustomRecipes() {
        if (Recipes.isItemEnabled(DarkGemConfig.class) && Recipes.isItemEnabled(DarkPowerGemConfig.class) && Recipes.isItemEnabled(BloodConfig.class)) {
            CustomRecipeRegistry.put(new CustomRecipe(new ItemStack((Item)DarkGem.getInstance()), new FluidStack((Fluid)Blood.getInstance(), 250), (Block)BloodInfuser.getInstance(), 200), new ItemStack((Item)DarkPowerGem.getInstance()));
        }
        if (Recipes.isItemEnabled(UndeadSaplingConfig.class)) {
            CustomRecipeRegistry.put(new CustomRecipe(new ItemStack((Block)Blocks.field_150330_I), new FluidStack((Fluid)Blood.getInstance(), 2000), (Block)BloodInfuser.getInstance(), 200), new ItemStack((Block)UndeadSapling.getInstance()));
        }
    }

    private static void registerInterModRecipes() {
        Recipes.registerThermalExpansionRecipes();
    }

    private static void registerThermalExpansionRecipes() {
        String TE = "ThermalExpansion";
        if (Loader.isModLoaded((String)TE)) {
            EvilCraft.log("Registering " + TE + " recipes");
            NBTTagCompound sawmillUndeadWood = new NBTTagCompound();
            sawmillUndeadWood.func_74768_a("energy", 2000);
            sawmillUndeadWood.func_74782_a("input", (NBTBase)new NBTTagCompound());
            sawmillUndeadWood.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            new ItemStack((Block)UndeadLog.getInstance()).func_77955_b(sawmillUndeadWood.func_74775_l("input"));
            new ItemStack((Block)UndeadPlank.getInstance(), 6).func_77955_b(sawmillUndeadWood.func_74775_l("primaryOutput"));
            FMLInterModComms.sendMessage((String)TE, (String)"SawmillRecipe", (NBTTagCompound)sawmillUndeadWood);
            NBTTagCompound pulverizerDarkOre = new NBTTagCompound();
            pulverizerDarkOre.func_74768_a("energy", 2000);
            pulverizerDarkOre.func_74782_a("input", (NBTBase)new NBTTagCompound());
            pulverizerDarkOre.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            new ItemStack((Block)DarkOre.getInstance()).func_77955_b(pulverizerDarkOre.func_74775_l("input"));
            new ItemStack((Item)DarkGem.getInstance(), 2).func_77955_b(pulverizerDarkOre.func_74775_l("primaryOutput"));
            FMLInterModComms.sendMessage((String)TE, (String)"PulverizerRecipe", (NBTTagCompound)pulverizerDarkOre);
            ArrayList materialPoisonousList = OreDictionary.getOres((String)"materialPoisonous");
            for (ItemStack materialPoisonous : materialPoisonousList) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74768_a("energy", 2000);
                nBTTagCompound.func_74782_a("input", (NBTBase)new NBTTagCompound());
                nBTTagCompound.func_74782_a("output", (NBTBase)new NBTTagCompound());
                materialPoisonous.func_77955_b(nBTTagCompound.func_74775_l("input"));
                new FluidStack((Fluid)Poison.getInstance(), 250).writeToNBT(nBTTagCompound.func_74775_l("output"));
                FMLInterModComms.sendMessage((String)TE, (String)"CrucibleRecipe", (NBTTagCompound)nBTTagCompound);
            }
            for (int i = 0; i < BloodStainedBlock.getInstance().getInnerBlocks(); ++i) {
                ItemStack materialPoisonous;
                materialPoisonous = new ItemStack((Block)BloodStainedBlock.getInstance(), 1, i);
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74768_a("energy", 2000);
                nBTTagCompound.func_74782_a("input", (NBTBase)new NBTTagCompound());
                nBTTagCompound.func_74782_a("output", (NBTBase)new NBTTagCompound());
                materialPoisonous.func_77955_b(nBTTagCompound.func_74775_l("input"));
                new FluidStack((Fluid)Blood.getInstance(), 750).writeToNBT(nBTTagCompound.func_74775_l("output"));
                FMLInterModComms.sendMessage((String)TE, (String)"CrucibleRecipe", (NBTTagCompound)nBTTagCompound);
            }
            Map<CustomRecipe, CustomRecipeResult> bloodInfuseRecipes = CustomRecipeRegistry.getRecipesForFactory((Block)BloodInfuser.getInstance());
            for (Map.Entry<CustomRecipe, CustomRecipeResult> entry : bloodInfuseRecipes.entrySet()) {
                NBTTagCompound bloodInfuse = new NBTTagCompound();
                bloodInfuse.func_74768_a("energy", entry.getKey().getDuration() * 100);
                bloodInfuse.func_74782_a("input", (NBTBase)new NBTTagCompound());
                bloodInfuse.func_74782_a("output", (NBTBase)new NBTTagCompound());
                bloodInfuse.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
                entry.getKey().getItemStack().func_77955_b(bloodInfuse.func_74775_l("input"));
                entry.getValue().getResult().func_77955_b(bloodInfuse.func_74775_l("output"));
                bloodInfuse.func_74757_a("reversible", false);
                FluidStack fluid = entry.getKey().getFluidStack().copy();
                fluid.amount = (int)((double)fluid.amount * 1.5);
                fluid.writeToNBT(bloodInfuse.func_74775_l("fluid"));
                FMLInterModComms.sendMessage((String)TE, (String)"TransposerFillRecipe", (NBTTagCompound)bloodInfuse);
            }
            for (Map.Entry<CustomRecipe, CustomRecipeResult> entry : BUCKETS.entrySet()) {
                NBTTagCompound fill = new NBTTagCompound();
                fill.func_74768_a("energy", 2000);
                fill.func_74782_a("input", (NBTBase)new NBTTagCompound());
                fill.func_74782_a("output", (NBTBase)new NBTTagCompound());
                fill.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
                new ItemStack((Item)entry.getKey()).func_77955_b(fill.func_74775_l("input"));
                new ItemStack(Items.field_151133_ar).func_77955_b(fill.func_74775_l("output"));
                fill.func_74757_a("reversible", true);
                ((FluidStack)entry.getValue()).copy().writeToNBT(fill.func_74775_l("fluid"));
                FMLInterModComms.sendMessage((String)TE, (String)"TransposerFillRecipe", (NBTTagCompound)fill);
            }
            NBTTagCompound compression = new NBTTagCompound();
            compression.func_74778_a("fluidName", Blood.getInstance().getName());
            compression.func_74768_a("energy", 600000);
            FMLInterModComms.sendMessage((String)TE, (String)"CompressionFuel", (NBTTagCompound)compression);
        }
    }
}

