/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.config;

import evilcraft.EvilCraft;
import evilcraft.api.config.ConfigPropertyCallback;
import evilcraft.api.config.ElementTypeCategory;
import java.lang.reflect.Field;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class ConfigProperty {
    private ElementTypeCategory category;
    private String name;
    private Object value;
    private String comment;
    private ConfigPropertyCallback callback;
    private boolean isCommandable;
    private Field field;

    public ConfigProperty(ElementTypeCategory category, String name, Object value, String comment, ConfigPropertyCallback callback, boolean isCommandable, Field field) {
        this.category = category;
        this.name = name;
        this.value = value;
        this.comment = comment;
        this.callback = callback;
        this.isCommandable = isCommandable;
        this.field = field;
    }

    public ConfigProperty(ElementTypeCategory category, String name, Object value, ConfigPropertyCallback callback, boolean isCommandable, Field field) {
        this(category, name, value, null, callback, isCommandable, field);
    }

    public ElementTypeCategory getCategory() {
        return this.category;
    }

    public void setCategory(ElementTypeCategory category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        try {
            this.field.set(null, this.value);
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ConfigPropertyCallback getCallback() {
        return this.callback;
    }

    public void setCallback(ConfigPropertyCallback callback) {
        this.callback = callback;
    }

    public boolean isCommandable() {
        return this.isCommandable;
    }

    public void setCommandable(boolean isCommandable) {
        this.isCommandable = isCommandable;
    }

    public void save(Configuration config) {
        this.save(config, false);
    }

    public void save(Configuration config, boolean forceUpdate) {
        String category = this.getCategory().toString();
        String name = this.getName();
        Object value = this.getValue();
        Property additionalProperty = null;
        if (value instanceof Integer) {
            additionalProperty = config.get(category, name, ((Integer)value).intValue());
            additionalProperty.comment = this.getComment();
            if (forceUpdate) {
                this.getCallback().run((Integer)value);
            } else {
                this.getCallback().run(additionalProperty.getInt());
            }
        } else if (value instanceof Boolean) {
            additionalProperty = config.get(category, name, ((Boolean)value).booleanValue());
            additionalProperty.comment = this.getComment();
            if (forceUpdate) {
                this.getCallback().run((Boolean)value);
            } else {
                this.getCallback().run(additionalProperty.getBoolean(((Boolean)value).booleanValue()));
            }
        } else if (value instanceof Double) {
            additionalProperty = config.get(category, name, ((Double)value).doubleValue());
            additionalProperty.comment = this.getComment();
            if (forceUpdate) {
                this.getCallback().run((Double)value);
            } else {
                this.getCallback().run(additionalProperty.getDouble(((Double)value).doubleValue()));
            }
        } else if (value instanceof String) {
            additionalProperty = config.get(category, name, (String)value);
            additionalProperty.comment = this.getComment();
            if (forceUpdate) {
                this.getCallback().run((String)value);
            } else {
                this.getCallback().run(additionalProperty.getString());
            }
        } else {
            EvilCraft.log("Invalid config property class.", Level.FATAL);
        }
    }
}

