/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.config;

import evilcraft.EvilCraft;
import evilcraft.api.config.ConfigProperty;
import evilcraft.api.config.ConfigPropertyCallback;
import evilcraft.api.config.ElementType;
import evilcraft.api.config.configurable.Configurable;
import evilcraft.api.config.configurable.ConfigurableProperty;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.Level;

public abstract class ExtendedConfig<C extends ExtendedConfig<C>>
implements Comparable<ExtendedConfig<C>> {
    private boolean enabled;
    public String NAMEDID;
    public String COMMENT;
    public Class ELEMENT;
    public List<ConfigProperty> configProperties = new LinkedList<ConfigProperty>();

    public ExtendedConfig(boolean enabled, String namedId, String comment, Class<?> element) {
        this.enabled = enabled;
        this.NAMEDID = namedId;
        this.COMMENT = comment;
        this.ELEMENT = element;
        try {
            this.generateConfigProperties();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
    }

    private void generateConfigProperties() throws IllegalArgumentException, IllegalAccessException {
        for (final Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigurableProperty.class)) continue;
            ConfigProperty configProperty = new ConfigProperty(field.getAnnotation(ConfigurableProperty.class).category(), this.NAMEDID + "." + field.getName(), field.get(null), field.getAnnotation(ConfigurableProperty.class).comment(), new ConfigPropertyCallback(){

                @Override
                public void run(Object newValue) {
                    try {
                        field.set(null, newValue);
                    }
                    catch (IllegalArgumentException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e2) {
                        e2.printStackTrace();
                    }
                }
            }, field.getAnnotation(ConfigurableProperty.class).isCommandable(), field);
            this.configProperties.add(configProperty);
        }
    }

    public void save() {
        try {
            this.getClass().getField("_instance").set(null, this);
            if (this.getHolderType().hasUniqueInstance()) {
                this.ELEMENT.getMethod("initInstance", ExtendedConfig.class).invoke(null, this);
            }
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (IllegalArgumentException e2) {
            e2.printStackTrace();
        }
        catch (NoSuchMethodException e3) {
            e3.printStackTrace();
        }
        catch (SecurityException e4) {
            e4.printStackTrace();
        }
        catch (NoSuchFieldException e5) {
            e5.printStackTrace();
        }
    }

    public ElementType getHolderType() {
        try {
            return (ElementType)((Object)this.ELEMENT.getField("TYPE").get(null));
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        catch (NoSuchFieldException e3) {
            e3.printStackTrace();
        }
        catch (SecurityException e4) {
            e4.printStackTrace();
        }
        return null;
    }

    public Configurable getSubInstance() {
        if (!this.getHolderType().hasUniqueInstance()) {
            return null;
        }
        try {
            return (Configurable)this.ELEMENT.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        catch (IllegalArgumentException e4) {
            e4.printStackTrace();
        }
        catch (InvocationTargetException e5) {
            e5.printStackTrace();
        }
        return null;
    }

    public String getSubUniqueName() {
        return this.NAMEDID;
    }

    public void onRegistered() {
    }

    @Override
    public int compareTo(ExtendedConfig<C> o) {
        return this.NAMEDID.compareTo(o.NAMEDID);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDisableable() {
        return true;
    }

    public void showDoubleInitError() {
        EvilCraft.log(this.getClass() + " caused a double registration of " + this.getSubInstance() + ". This is an error in the mod code.", Level.FATAL);
    }

    public C downCast() {
        ExtendedConfig c = this;
        return (C)c;
    }
}

