/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.entities.tileentitites.tickaction;

import evilcraft.api.entities.tileentitites.EvilCraftTileEntity;
import evilcraft.api.entities.tileentitites.tickaction.ITickAction;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TickComponent<C extends EvilCraftTileEntity, T extends ITickAction<C>> {
    private Map<Class<?>, T> tickActions;
    private C tile;
    private int tick = 0;
    private int requiredTicks = 0;
    private int slot;

    public TickComponent(C tile, Map<Class<?>, T> tickActions, int slot) {
        this.tile = tile;
        this.tickActions = tickActions;
        this.slot = slot;
    }

    protected T getTickAction(Item item) {
        for (Map.Entry<Class<?>, T> entry : this.tickActions.entrySet()) {
            if (!entry.getKey().isInstance(item)) continue;
            return (T)((ITickAction)entry.getValue());
        }
        return null;
    }

    public void tick(ItemStack itemStack, int slot) {
        if (itemStack != null) {
            C action = this.getTickAction(itemStack.func_77973_b());
            if (action != null && action.canTick(this.tile, itemStack, slot, this.tick)) {
                if (this.tick == 0) {
                    this.requiredTicks = action.getRequiredTicks(this.tile, slot);
                }
                ++this.tick;
                if (this.tick > this.requiredTicks) {
                    this.tick = 0;
                }
                action.onTick(this.tile, itemStack, slot, this.tick);
            } else {
                this.tick = 0;
            }
        } else {
            this.tick = 0;
        }
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public int getRequiredTicks() {
        return this.requiredTicks;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setRequiredTicks(int requiredTicks) {
        this.requiredTicks = requiredTicks;
    }
}

