/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.gui.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.entities.tileentitites.TickingTankInventoryTileEntity;
import evilcraft.api.entities.tileentitites.tickaction.ITickAction;
import evilcraft.api.entities.tileentitites.tickaction.TickComponent;
import evilcraft.api.gui.container.InventoryContainer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraftforge.fluids.FluidStack;

public class TickingTankInventoryContainer<T extends TickingTankInventoryTileEntity<T>>
extends InventoryContainer<T> {
    private Map<TickComponent<T, ITickAction<T>>, Integer> previousTicks = new HashMap<TickComponent<T, ITickAction<T>>, Integer>();
    private int lastTankAmount;
    private static final int INDEX_OFFSET = 1;
    private static final int INDEX_LIQUID_AMOUNT = 0;

    public TickingTankInventoryContainer(InventoryPlayer inventory, T tile) {
        super(inventory, tile);
        for (TickComponent tickComponent : ((TickingTankInventoryTileEntity)((Object)tile)).getTickers()) {
            this.previousTicks.put(tickComponent, tickComponent.getTick());
        }
        this.lastTankAmount = -1;
    }

    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        this.sendTankUpdates(icrafting, true);
        this.sendTickersUpdates(icrafting, true);
    }

    private void sendTankUpdates(ICrafting icrafting, boolean force) {
        if (((TickingTankInventoryTileEntity)this.tile).getTank() != null && (this.lastTankAmount != ((TickingTankInventoryTileEntity)this.tile).getTank().getFluidAmount() || force)) {
            icrafting.func_71112_a((Container)this, 0, ((TickingTankInventoryTileEntity)this.tile).getTank().getFluidAmount());
        }
    }

    private void sendTickersUpdates(ICrafting icrafting, boolean force) {
        int index = 0;
        for (TickComponent tickComponent : ((TickingTankInventoryTileEntity)this.tile).getTickers()) {
            if (this.previousTicks.get(tickComponent).intValue() != tickComponent.getTick() || force) {
                icrafting.func_71112_a((Container)this, 1 + index, tickComponent.getTick());
                icrafting.func_71112_a((Container)this, 1 + ((TickingTankInventoryTileEntity)this.tile).getTickers().size() + index, tickComponent.getRequiredTicks());
                this.previousTicks.put(tickComponent, tickComponent.getTick());
            }
            ++index;
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            this.sendTankUpdates(icrafting, false);
            this.sendTickersUpdates(icrafting, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int index, int value) {
        if (index >= ((TickingTankInventoryTileEntity)this.tile).getTickers().size() + 1) {
            ((TickingTankInventoryTileEntity)this.tile).getTickers().get(index - ((TickingTankInventoryTileEntity)this.tile).getTickers().size() - 1).setRequiredTicks(value);
        } else if (index >= 1) {
            ((TickingTankInventoryTileEntity)this.tile).getTickers().get(index - 1).setTick(value);
        } else if (((TickingTankInventoryTileEntity)this.tile).getTank() != null && index == 0) {
            if (((TickingTankInventoryTileEntity)this.tile).getTank().getFluid() == null) {
                ((TickingTankInventoryTileEntity)this.tile).getTank().setFluid(new FluidStack(((TickingTankInventoryTileEntity)this.tile).getTank().getAcceptedFluid(), value));
            } else {
                ((TickingTankInventoryTileEntity)this.tile).getTank().getFluid().amount = value;
            }
        }
    }
}

