/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.Helpers;
import evilcraft.api.config.BlockConfig;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.configurable.ConfigurableBlockContainerGuiTankInfo;
import evilcraft.api.entities.tileentitites.TankInventoryTileEntity;
import evilcraft.blocks.BloodInfuser;
import evilcraft.entities.tileentities.TileBloodChest;
import evilcraft.entities.tileentities.TileBloodInfuser;
import evilcraft.gui.client.GuiBloodChest;
import evilcraft.gui.container.ContainerBloodChest;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BloodChest
extends ConfigurableBlockContainerGuiTankInfo {
    private static BloodChest _instance = null;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new BloodChest(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BloodChest getInstance() {
        return _instance;
    }

    private BloodChest(ExtendedConfig<BlockConfig> eConfig) {
        super((ExtendedConfig)eConfig, Material.field_151575_d, (Class<? extends TankInventoryTileEntity>)TileBloodChest.class);
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149766_f);
        this.setRotatable(true);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        if (Helpers.isClientSide()) {
            this.setGUI(GuiBloodChest.class);
        }
        this.setContainer(ContainerBloodChest.class);
    }

    public int func_149645_b() {
        return 22;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return BloodInfuser.getInstance().func_149691_a(side, meta);
    }

    public Item func_149650_a(int par1, Random random, int zero) {
        return Item.func_150898_a((Block)this);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileBloodInfuser tile = (TileBloodInfuser)world.func_147438_o(x, y, z);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil(15.0f * output);
    }

    @Override
    public String getTankNBTName() {
        return TileBloodChest.TANKNAME;
    }

    @Override
    public int getTankCapacity() {
        return 10000;
    }
}

