/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.Helpers;
import evilcraft.api.IInformationProvider;
import evilcraft.api.config.BlockConfig;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.configurable.ConfigurableBlockContainer;
import evilcraft.entities.tileentities.TileEnvironmentalAccumulator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnvironmentalAccumulator
extends ConfigurableBlockContainer
implements IInformationProvider {
    private static EnvironmentalAccumulator _instance = null;
    public static final int BEAM_ACTIVE = 0;
    public static final int BEAM_INACTIVE = 1;
    public static final int MOVING_ITEM = 2;
    private IIcon sideIcon;
    private IIcon bottomIcon;
    private IIcon topIcon;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new EnvironmentalAccumulator(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static EnvironmentalAccumulator getInstance() {
        return _instance;
    }

    private EnvironmentalAccumulator(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileEnvironmentalAccumulator.class);
        this.setRotatable(true);
        this.func_149672_a(field_149777_j);
        this.func_149711_c(50.0f);
        this.func_149752_b(6000000.0f);
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.topIcon;
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.bottomIcon;
        }
        return this.sideIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.sideIcon = iconRegister.func_94245_a(this.func_149641_N() + "_side");
        this.bottomIcon = iconRegister.func_94245_a(this.func_149641_N() + "_bottom");
        this.topIcon = iconRegister.func_94245_a(this.func_149641_N() + "_top");
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        world.func_147468_f(x, y, z);
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        return Helpers.getLocalizedInfo((Block)this);
    }

    @Override
    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    public static boolean isBeamActive(int metadata) {
        return (metadata & 1) == 0;
    }

    public static boolean isMovingItem(int metadata) {
        return (metadata & 2) == 2;
    }

    public static boolean isDoneMovingItem(int metadata) {
        return !EnvironmentalAccumulator.isBeamActive(metadata) && EnvironmentalAccumulator.isMovingItem(metadata);
    }
}

