/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.entities.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.Helpers;
import evilcraft.blocks.EnvironmentalAccumulator;
import evilcraft.blocks.EnvironmentalAccumulatorConfig;
import evilcraft.entities.tileentities.EvilCraftBeaconTileEntity;
import evilcraft.items.WeatherContainer;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import org.lwjgl.util.vector.Vector4f;

public class TileEnvironmentalAccumulator
extends EvilCraftBeaconTileEntity {
    private static final int ITEM_MOVE_DURATION = 100;
    private static final int ITEM_MOVE_COOLDOWN_DURATION = 100;
    private static final float ITEM_MOVE_SPEED = 0.015000001f;
    private static final double WEATHER_CONTAINER_MIN_DROP_HEIGHT = 0.0;
    private static final double WEATHER_CONTAINER_MAX_DROP_HEIGHT = 2.0;
    private static final double WEATHER_CONTAINER_SPAWN_HEIGHT = 2.5;
    private int cooldownTick = 0;
    private boolean cooldown = false;
    private int moveItemTick = 0;
    private int moveItemCooldownTick = 0;
    private boolean movingItem = false;
    private int lastMetadata;
    @SideOnly(value=Side.CLIENT)
    private float movingItemY;

    public TileEnvironmentalAccumulator() {
        if (Helpers.isClientSide()) {
            this.setBeamInnerColor(this.getInnerColorByMetadata(1));
            this.setBeamOuterColor(this.getOuterColorByMetadata(1));
            this.movingItemY = -1.0f;
            this.lastMetadata = -1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private Vector4f getInnerColorByMetadata(int metadata) {
        if (EnvironmentalAccumulator.isMovingItem(metadata) && EnvironmentalAccumulator.isBeamActive(metadata)) {
            return new Vector4f(0.48046875f, 0.29296875f, 0.1171875f, 0.05f);
        }
        if (EnvironmentalAccumulator.isBeamActive(metadata)) {
            return new Vector4f(0.48046875f, 0.29296875f, 0.1171875f, 0.13f);
        }
        return new Vector4f(0.0f, 0.0f, 0.0f, 0.13f);
    }

    @SideOnly(value=Side.CLIENT)
    private Vector4f getOuterColorByMetadata(int metadata) {
        if (!EnvironmentalAccumulator.isBeamActive(metadata)) {
            return new Vector4f(0.0f, 0.0f, 0.0f, 0.13f);
        }
        return new Vector4f(0.30078125f, 0.1875f, 0.08203125f, 0.13f);
    }

    public int getMaxCooldownTick() {
        return EnvironmentalAccumulatorConfig.tickCooldown;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMovingItemY() {
        return this.movingItemY;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            --this.moveItemTick;
            --this.cooldownTick;
            if (this.cooldown && this.cooldownTick <= 0) {
                this.deactivateCooldown();
            }
            if (this.movingItem && this.moveItemTick <= 0) {
                this.deactivateMoveItem();
                this.dropWeatherContainer();
                this.activateCooldown();
            }
            if (this.cooldown) {
                this.updateDoneItemMoving();
            }
            if (!this.cooldown && !this.movingItem) {
                this.updateEnvironmentalAccumulator();
            }
        } else {
            this.updateClient();
        }
    }

    private void updateEnvironmentalAccumulator() {
        if (!this.field_145850_b.field_72995_K) {
            List containers = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)((double)this.field_145848_d + 0.0), (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 2.0), (double)((double)this.field_145849_e + 1.0)));
            boolean foundEmptyContainer = false;
            for (int i = 0; i < containers.size() && !foundEmptyContainer; ++i) {
                EntityItem container = (EntityItem)containers.get(i);
                ItemStack stack = container.func_92059_d();
                if (stack.func_77973_b() != WeatherContainer.getInstance() || !WeatherContainer.isEmpty(stack.func_77960_j())) continue;
                this.decreaseStackSize(container, stack);
                this.activateMoveItem();
            }
        }
    }

    private void updateClient() {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (metadata == this.lastMetadata) {
            if (EnvironmentalAccumulator.isMovingItem(metadata) && !EnvironmentalAccumulator.isDoneMovingItem(metadata)) {
                this.movingItemY += 0.015000001f;
            }
        } else {
            if (EnvironmentalAccumulator.isDoneMovingItem(metadata)) {
                this.field_145850_b.func_72926_e(2002, Math.round(this.field_145851_c), (int)Math.round((double)this.field_145848_d + 2.5), Math.round(this.field_145849_e), 16428);
                this.movingItemY = -1.0f;
            } else if (EnvironmentalAccumulator.isMovingItem(metadata)) {
                this.movingItemY = 0.0f;
            }
            this.setBeamColors(metadata);
            this.lastMetadata = metadata;
        }
    }

    private void decreaseStackSize(EntityItem container, ItemStack stack) {
        --stack.field_77994_a;
        if (stack.field_77994_a == 0) {
            container.func_70106_y();
        }
    }

    private void dropWeatherContainer() {
        ItemStack itemStack = WeatherContainer.createItemStack(WeatherContainer.WeatherContainerTypes.EMPTY, 1);
        ((WeatherContainer)itemStack.func_77973_b()).onFill(this.field_145850_b, itemStack);
        EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d + 2.5, (double)this.field_145849_e);
        entity.func_92058_a(itemStack);
        this.field_145850_b.func_72838_d((Entity)entity);
    }

    private void activateMoveItem() {
        this.moveItemTick = 100;
        this.movingItem = true;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 2);
    }

    private void deactivateMoveItem() {
        this.moveItemCooldownTick = 100;
        this.movingItem = false;
        this.moveItemTick = 0;
    }

    private void activateCooldown() {
        this.cooldownTick = this.getMaxCooldownTick();
        this.cooldown = true;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, 2);
    }

    private void deactivateCooldown() {
        this.cooldownTick = 0;
        this.cooldown = false;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
    }

    public void setBeamColors(int metadata) {
        if (this.field_145850_b.field_72995_K) {
            this.setBeamInnerColor(this.getInnerColorByMetadata(metadata));
            this.setBeamOuterColor(this.getOuterColorByMetadata(metadata));
        }
    }

    public void updateDoneItemMoving() {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (EnvironmentalAccumulator.isDoneMovingItem(metadata)) {
            --this.moveItemCooldownTick;
            if (this.moveItemCooldownTick <= 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cooldownTick = compound.func_74762_e("cooldownTick");
        if (this.cooldownTick > 0) {
            this.cooldown = true;
        }
        this.moveItemTick = compound.func_74762_e("moveItemTick");
        if (this.moveItemTick > 0) {
            this.movingItem = true;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("cooldownTick", this.cooldownTick);
        compound.func_74768_a("moveItemTick", this.moveItemTick);
    }
}

