/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import evilcraft.client.KeyHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.settings.KeyBinding;

public class KeyInputEventHook {
    private Map<KeyBinding, List<KeyHandler>> keyHandlerMap = new HashMap<KeyBinding, List<KeyHandler>>();
    private static KeyInputEventHook instance;

    public static KeyInputEventHook getInstance() {
        if (instance == null) {
            instance = new KeyInputEventHook();
        }
        return instance;
    }

    private KeyInputEventHook() {
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerKeyInput(InputEvent.KeyInputEvent event) {
        for (KeyBinding kb : this.keyHandlerMap.keySet()) {
            if (!kb.func_151468_f()) continue;
            this.fireKeyPressed(kb);
        }
    }

    private void fireKeyPressed(KeyBinding kb) {
        for (KeyHandler h : this.keyHandlerMap.get(kb)) {
            h.onKeyPressed(kb);
        }
    }

    public void addKeyHandler(KeyBinding kb, KeyHandler handler) {
        List<KeyHandler> handlers = this.keyHandlerMap.get(kb);
        if (handlers == null) {
            handlers = new LinkedList<KeyHandler>();
            this.keyHandlerMap.put(kb, handlers);
        }
        if (!handlers.contains(handler)) {
            handlers.add(handler);
        }
    }
}

