/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import evilcraft.api.HotbarIterator;
import evilcraft.blocks.BloodStainedBlock;
import evilcraft.fluids.Blood;
import evilcraft.items.BloodExtractor;
import evilcraft.render.particle.EntityBloodSplashFX;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ItemFluidContainer;

public class LivingDeathEventHook {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingDeath(LivingDeathEvent event) {
        this.bloodObtainEvent(event);
        this.bloodStainedBlockEvent(event);
    }

    private void bloodObtainEvent(LivingDeathEvent event) {
        Entity e = event.source.func_76346_g();
        if (e != null && e instanceof EntityPlayerMP && !e.field_70170_p.field_72995_K && event.entityLiving != null) {
            EntityPlayerMP player = (EntityPlayerMP)e;
            int health = MathHelper.func_76141_d((float)event.entityLiving.func_110138_aP());
            int toFill = health * 10 + new Random().nextInt(health * 90);
            HotbarIterator it = new HotbarIterator((EntityPlayer)player);
            while (it.hasNext() && toFill > 0) {
                ItemStack itemStack = it.next();
                if (itemStack == null || itemStack.func_77973_b() != BloodExtractor.getInstance()) continue;
                ItemFluidContainer container = (ItemFluidContainer)itemStack.func_77973_b();
                toFill -= container.fill(itemStack, new FluidStack((Fluid)Blood.getInstance(), toFill), true);
            }
        }
    }

    private void bloodStainedBlockEvent(LivingDeathEvent event) {
        if (event.source.field_76373_n == DamageSource.field_76379_h.field_76373_n) {
            int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)(event.entity.field_70163_u - event.entity.func_70033_W() - 1.0));
            int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
            Block block = event.entity.field_70170_p.func_147439_a(x, y, z);
            int meta = BloodStainedBlock.getInstance().getMetadataFromBlock(block);
            if (meta > -1) {
                if (!event.entity.field_70170_p.field_72995_K) {
                    event.entity.field_70170_p.func_147449_b(x, y, z, (Block)BloodStainedBlock.getInstance());
                    event.entity.field_70170_p.func_72921_c(x, y, z, meta, 2);
                } else {
                    Random random = new Random();
                    EntityBloodSplashFX.spawnParticles(event.entity.field_70170_p, x, y + 1, z, (int)event.entityLiving.func_110138_aP() + random.nextInt(15), 5 + random.nextInt(5));
                }
            }
        }
    }
}

