/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import evilcraft.ExtendedDamageSource;
import evilcraft.blocks.ExcrementPile;
import evilcraft.entities.monster.Werewolf;
import evilcraft.entities.villager.WerewolfVillagerConfig;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;

public class PlaySoundAtEntityEventHook {
    private static final int CHANCE_DROP_EXCREMENT = 500;
    private static final int CHANCE_DIE_WITHOUT_ANY_REASON = 1000000;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        this.dropExcrement(event);
        this.dieWithoutAnyReason(event);
        this.transformWerewolfVillager(event);
    }

    private void dropExcrement(PlaySoundAtEntityEvent event) {
        if (event.entity instanceof EntityAnimal) {
            EntityAnimal entity = (EntityAnimal)event.entity;
            World world = entity.field_70170_p;
            if (world.field_73012_v.nextInt(500) == 0) {
                int z;
                int y;
                int x = MathHelper.func_76128_c((double)entity.field_70165_t);
                if (world.func_147439_a(x, y = MathHelper.func_76128_c((double)entity.field_70163_u), z = MathHelper.func_76128_c((double)entity.field_70161_v)) == Blocks.field_150350_a && world.func_147439_a(x, y - 1, z).func_149637_q()) {
                    world.func_147449_b(x, y, z, (Block)ExcrementPile.getInstance());
                } else if (world.func_147439_a(x, y, z) == ExcrementPile.getInstance()) {
                    ExcrementPile.heightenPileAt(world, x, y, z);
                }
            }
        }
    }

    private void dieWithoutAnyReason(PlaySoundAtEntityEvent event) {
        if (event.entity instanceof EntityPlayer && event.entity.field_70170_p.field_73012_v.nextInt(1000000) == 0) {
            EntityPlayer entity = (EntityPlayer)event.entity;
            entity.func_70097_a((DamageSource)ExtendedDamageSource.dieWithoutAnyReason, Float.MAX_VALUE);
        }
    }

    private void transformWerewolfVillager(PlaySoundAtEntityEvent event) {
        if (event.entity instanceof EntityVillager) {
            World world = event.entity.field_70170_p;
            EntityVillager villager = (EntityVillager)event.entity;
            if (!world.field_72995_K && Werewolf.isWerewolfTime(world) && villager.func_70946_n() == WerewolfVillagerConfig._instance.ID) {
                Werewolf.replaceVillager(villager);
            }
        }
    }
}

