/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.items;

import evilcraft.api.config.ElementTypeCategory;
import evilcraft.api.config.ItemConfig;
import evilcraft.api.config.configurable.ConfigurableProperty;
import evilcraft.fluids.Blood;
import evilcraft.items.BloodContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BloodContainerConfig
extends ItemConfig {
    public static BloodContainerConfig _instance;
    @ConfigurableProperty(category=ElementTypeCategory.GENERAL, comment="The base amount of blood (mB) this container can hold * the level of container.")
    public static int containerSizeBase;
    public static String[] containerLevelNames;

    public BloodContainerConfig() {
        super(true, "bloodContainer", (String)null, (Class<? extends Item>)BloodContainer.class);
    }

    public static int getContainerLevels() {
        return containerLevelNames.length;
    }

    @Override
    public void onRegistered() {
        for (int level = 0; level < BloodContainerConfig.getContainerLevels(); ++level) {
            ItemStack itemStack = new ItemStack((Item)BloodContainer.getInstance(), 1, level);
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)Blood.getInstance().getName(), (int)BloodContainer.getInstance().getCapacity(itemStack)), (ItemStack)itemStack);
        }
    }

    static {
        containerSizeBase = 5000;
        containerLevelNames = new String[]{"bloodCell", "bloodCan", "bloodBasin"};
    }
}

