/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.render.tileentity;

import evilcraft.entities.tileentities.EvilCraftBeaconTileEntity;
import evilcraft.entities.tileentities.TileEnvironmentalAccumulator;
import evilcraft.items.WeatherContainerConfig;
import evilcraft.render.tileentity.TileEntityBeaconRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityEnvironmentalAccumulatorRenderer
extends TileEntityBeaconRenderer {
    private ResourceLocation weatherContainerTexture;
    private static final int ITEM_SPIN_SPEED = 3;
    private static final float ITEM_TICKNESS = 0.05f;

    private ResourceLocation getResourceLocation() {
        if (this.weatherContainerTexture == null) {
            this.weatherContainerTexture = new ResourceLocation("evilcraft", "textures/items/" + WeatherContainerConfig._instance.NAMEDID + ".png");
        }
        return this.weatherContainerTexture;
    }

    @Override
    public void renderBeacon(EvilCraftBeaconTileEntity tileentity, double x, double y, double z, float partialTickTime) {
        super.renderBeacon(tileentity, x, y, z, partialTickTime);
        TileEnvironmentalAccumulator tile = (TileEnvironmentalAccumulator)tileentity;
        if (tile.getMovingItemY() != -1.0f) {
            this.renderMovingWeatherContainer(tile, x, y + 1.0 + (double)tile.getMovingItemY(), z, partialTickTime);
        }
    }

    private void renderMovingWeatherContainer(TileEnvironmentalAccumulator tileentity, double x, double y, double z, float partialTickTime) {
        GL11.glPushMatrix();
        this.func_147499_a(this.getResourceLocation());
        GL11.glDisable((int)2896);
        double totalTickTime = (float)tileentity.func_145831_w().func_82737_E() + partialTickTime;
        double angle = 3.0 * (totalTickTime % 360.0);
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)0.0, (double)0.025f);
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)16, (int)16, (float)0.05f);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

