/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.worldgen;

import evilcraft.blocks.UndeadLeaves;
import evilcraft.blocks.UndeadLog;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGeneratorUndeadTree
extends WorldGenerator {
    private Block sapling = null;
    private Block leaves = UndeadLeaves.getInstance();
    private Block logs = UndeadLog.getInstance();

    public WorldGeneratorUndeadTree() {
    }

    public WorldGeneratorUndeadTree(boolean doNotify, Block sapling) {
        super(doNotify);
        this.sapling = sapling;
    }

    public boolean func_76484_a(World world, Random rand, int x, int retries, int z) {
        for (int c = 0; c < retries; ++c) {
            int y;
            for (y = world.func_72940_L() - 1; world.func_147437_c(x, y, z) && y > 0; --y) {
            }
            if (!this.growTree(world, rand, x, y + 1, z)) {
                --retries;
            }
            x += rand.nextInt(16) - 8;
            z += rand.nextInt(16) - 8;
        }
        return true;
    }

    public boolean growTree(World world, Random rand, int x, int y, int z) {
        Block block;
        int treeHeight = rand.nextInt(9) + 4;
        int worldHeight = world.func_72800_K();
        if (y >= 1 && y + treeHeight + 1 <= worldHeight && (block = world.func_147439_a(x, y - 1, z)) != null && block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)((BlockSapling)this.sapling)) && y < worldHeight - treeHeight - 1) {
            int zOffset;
            int xOffset;
            int yOffset;
            for (yOffset = y; yOffset <= y + 1 + treeHeight; ++yOffset) {
                int radius = 1;
                if (yOffset == y) {
                    radius = 0;
                }
                if (yOffset >= y + 1 + treeHeight - 3) {
                    radius = 3;
                }
                if (yOffset >= 0 & yOffset < worldHeight) {
                    for (xOffset = x - radius; xOffset <= x + radius; ++xOffset) {
                        for (zOffset = z - radius; zOffset <= z + radius; ++zOffset) {
                            block = world.func_147439_a(xOffset, yOffset, zOffset);
                            if (block == null || block.isLeaves((IBlockAccess)world, xOffset, yOffset, zOffset) || block == Blocks.field_150350_a || block.canBeReplacedByLeaves((IBlockAccess)world, xOffset, yOffset, zOffset)) continue;
                            return false;
                        }
                    }
                    continue;
                }
                return false;
            }
            block = world.func_147439_a(x, y - 1, z);
            if (block != null) {
                block.onPlantGrow(world, x, y - 1, z, x, y, z);
                for (yOffset = y - 3 + treeHeight; yOffset <= y + treeHeight; ++yOffset) {
                    int var12 = yOffset - (y + treeHeight);
                    int center = 1 - var12 / 2;
                    for (xOffset = x - center; xOffset <= x + center; ++xOffset) {
                        int xPos = xOffset - x;
                        int t = xPos >> 31;
                        xPos = xPos + t ^ t;
                        for (zOffset = z - center; zOffset <= z + center; ++zOffset) {
                            int zPos = zOffset - z;
                            t = zPos >> 31;
                            zPos = zPos + t ^ t;
                            block = world.func_147439_a(xOffset, yOffset, zOffset);
                            if (!(xPos != center | zPos != center) && (rand.nextInt(2) == 0 || var12 == 0) || block != null && !block.isLeaves((IBlockAccess)world, xOffset, yOffset, zOffset) && block != Blocks.field_150350_a && !block.canBeReplacedByLeaves((IBlockAccess)world, xOffset, yOffset, zOffset)) continue;
                            this.func_150516_a(world, xOffset, yOffset, zOffset, this.leaves, 0);
                        }
                    }
                }
                for (yOffset = 0; yOffset < treeHeight; ++yOffset) {
                    block = world.func_147439_a(x, y + yOffset, z);
                    if (block != null && block != Blocks.field_150350_a && !block.isLeaves((IBlockAccess)world, x, y + yOffset, z) && !block.isReplaceable((IBlockAccess)world, x, y + yOffset, z)) continue;
                    this.func_150516_a(world, x, y + yOffset, z, this.logs, 1);
                }
                return true;
            }
        }
        return false;
    }
}

