/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.worldgen.structure;

import evilcraft.api.Helpers;
import evilcraft.api.StairSlabMetadataHelper;
import evilcraft.blocks.EnvironmentalAccumulator;
import evilcraft.worldgen.structure.QuarterSymmetricalStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DarkTempleStructure
extends QuarterSymmetricalStructure {
    private static final int STRUCTURE_HEIGHT = 9;
    private static final int MAX_BUILD_HEIGHT = 247;
    private static final int MIN_BUILD_HEIGHT = 90;
    private static DarkTempleStructure _instance = null;

    public static DarkTempleStructure getInstance() {
        if (_instance == null) {
            _instance = new DarkTempleStructure();
        }
        return _instance;
    }

    private DarkTempleStructure() {
        super(6, 6);
    }

    private int findGround(World world, int x, int z) {
        int height;
        for (height = 247; height >= 90 && world.func_147437_c(x, height, z); --height) {
        }
        if (!world.func_147437_c(x, height, z)) {
            return height;
        }
        return -1;
    }

    private boolean canPlaceStructure(World world, int x, int y, int z) {
        for (int xr = x - 2; xr < x + 2; ++xr) {
            for (int zr = z - 2; zr < z + 2; ++zr) {
                if (world.func_147437_c(xr, y, zr)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSolidBlock(World world, int x, int y, int z) {
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        return material.func_76220_a() && material.func_76218_k();
    }

    @Override
    protected void generateLayers() {
        QuarterSymmetricalStructure.BlockWrapper us = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)Blocks.field_150333_U, StairSlabMetadataHelper.getSlabMetadata(StairSlabMetadataHelper.SlabType.STONE, true));
        QuarterSymmetricalStructure.BlockWrapper rs = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)Blocks.field_150333_U);
        QuarterSymmetricalStructure.BlockWrapper ds = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)Blocks.field_150334_T);
        QuarterSymmetricalStructure.BlockWrapper cb = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150417_aV, StairSlabMetadataHelper.getStoneBrickMetadata(StairSlabMetadataHelper.StoneBrickType.CHISELED));
        QuarterSymmetricalStructure.BlockWrapper sb = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150417_aV);
        QuarterSymmetricalStructure.BlockWrapper cs = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)Blocks.field_150333_U, StairSlabMetadataHelper.getSlabMetadata(StairSlabMetadataHelper.SlabType.COBBLESTONE, false));
        QuarterSymmetricalStructure.BlockWrapper co = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150347_e);
        QuarterSymmetricalStructure.BlockWrapper wa = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150355_j);
        QuarterSymmetricalStructure.BlockWrapper fe = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150422_aJ);
        QuarterSymmetricalStructure.BlockWrapper to = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150478_aa);
        QuarterSymmetricalStructure.BlockWrapper cw = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150463_bK);
        QuarterSymmetricalStructure.BlockWrapper ea = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)EnvironmentalAccumulator.getInstance());
        Object o = null;
        this.addLayer(1, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, us, ds, o, us, us, us, us, us, o, us, us, us, us, o, o, us, us, us, us, o, o, us, us, us, us, o, o});
        this.addLayer(2, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, cb, cb, o, sb, sb, sb, sb, cb, o, ds, co, wa, sb, o, o, co, co, co, sb, o, o, co, co, ds, sb, o, o});
        this.addLayer(3, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, sb, o, o, o, o, fe, o, o, rs, o, o, o, o, o, cs, rs, o, o, o, o, ea, cs, rs, o, o, o});
        this.addLayer(4, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, cb, o, o, o, o, to, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o});
        this.addLayer(5, new QuarterSymmetricalStructure.BlockWrapper[]{us, o, o, o, cw, o, o, o, o, o, sb, cw, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, us});
        this.addLayer(6, new QuarterSymmetricalStructure.BlockWrapper[]{cb, ds, rs, rs, rs, o, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, ds, o, co, co, co, co, cb});
        this.addLayer(7, new QuarterSymmetricalStructure.BlockWrapper[]{rs, o, o, o, o, o, cw, o, o, o, o, o, cs, cs, cs, o, o, o, co, co, cs, cs, o, o, co, co, co, cs, o, o, o, co, co, cs, cw, rs});
        this.addLayer(8, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, cs, cw, o, o, o, o, o, cs, o, o, o, o});
        this.addLayer(9, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, to, o, o, o, o, o, o, o, o, o, o});
    }

    @Override
    protected void postBuildCorner(World world, int x, int y, int z, int incX, int incZ) {
        int metadata1 = StairSlabMetadataHelper.getStairMetadata(Helpers.getForgeDirectionFromXSign(incX), true);
        int metadata2 = StairSlabMetadataHelper.getStairMetadata(Helpers.getForgeDirectionFromZSing(incZ), true);
        world.func_147465_d(x + 3 * incX, y + 5, z + 4 * incZ, Blocks.field_150446_ar, metadata1, 2);
        world.func_147465_d(x + 4 * incX, y + 5, z + 3 * incZ, Blocks.field_150446_ar, metadata2, 2);
        int xx = x + 4 * incX;
        int zz = z + 4 * incZ;
        while (!this.isSolidBlock(world, xx, y, zz)) {
            world.func_147465_d(xx, y, zz, Blocks.field_150347_e, 0, 2);
            --y;
        }
    }

    @Override
    public boolean generate(World world, Random random, int x, int y, int z) {
        int groundHeight = this.findGround(world, x, z);
        if (groundHeight == -1) {
            return false;
        }
        if (!this.canPlaceStructure(world, x, groundHeight + 1, z)) {
            return false;
        }
        super.generate(world, random, x, groundHeight, z);
        return true;
    }
}

