/*
 * Decompiled with CFR 0.152.
 */
package evilcraft;

import evilcraft.CustomRecipe;
import evilcraft.CustomRecipeResult;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class CustomRecipeRegistry {
    private static final Map<CustomRecipe, CustomRecipeResult> recipes = new HashMap<CustomRecipe, CustomRecipeResult>();

    public static void put(CustomRecipe recipe, ItemStack result) {
        recipes.put(recipe, new CustomRecipeResult(recipe, result));
    }

    public static CustomRecipeResult get(CustomRecipe recipe) {
        for (Map.Entry<CustomRecipe, CustomRecipeResult> entry : recipes.entrySet()) {
            if (!entry.getKey().equals(recipe)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Map<CustomRecipe, CustomRecipeResult> getRecipesForFactory(Block factory) {
        HashMap<CustomRecipe, CustomRecipeResult> factoryRecipes = new HashMap<CustomRecipe, CustomRecipeResult>();
        for (Map.Entry<CustomRecipe, CustomRecipeResult> entry : recipes.entrySet()) {
            if (entry.getKey().getFactory() != factory) continue;
            factoryRecipes.put(entry.getKey(), entry.getValue());
        }
        return factoryRecipes;
    }
}

