/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api;

import evilcraft.api.Helpers;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderHelpers {
    private static Map<ForgeDirection, String> METHODS_RENDERFACE = new HashMap<ForgeDirection, String>();
    private static Map<ForgeDirection, String> FIELDS_UVROTATE;
    private static Map<ForgeDirection, String> METHODS_RENDERFACE_OBFUSICATED;
    private static Map<ForgeDirection, String> FIELDS_UVROTATE_OBFUSICATED;
    private static int[] ROTATE_UV_ROTATE;
    public static IIcon EMPTYICON;

    public static void renderFaceDirection(ForgeDirection renderDirection, RenderBlocks renderer, Block block, double x, double y, double z, IIcon blockIconFromSideAndMetadata) {
        try {
            String methodName = Helpers.isObfusicated() ? METHODS_RENDERFACE_OBFUSICATED.get(renderDirection) : METHODS_RENDERFACE.get(renderDirection);
            Method method = renderer.getClass().getMethod(methodName, Block.class, Double.TYPE, Double.TYPE, Double.TYPE, IIcon.class);
            method.invoke((Object)renderer, block, x, y, z, blockIconFromSideAndMetadata);
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        catch (IllegalArgumentException e4) {
            e4.printStackTrace();
        }
        catch (InvocationTargetException e5) {
            e5.printStackTrace();
        }
    }

    public static void setRenderBlocksUVRotation(RenderBlocks renderer, ForgeDirection side, int rotation) {
        try {
            String fieldName = Helpers.isObfusicated() ? FIELDS_UVROTATE_OBFUSICATED.get(side) : FIELDS_UVROTATE.get(side);
            Field field = renderer.getClass().getField(fieldName);
            field.set(renderer, ROTATE_UV_ROTATE[rotation]);
        }
        catch (NoSuchFieldException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        catch (IllegalArgumentException e4) {
            e4.printStackTrace();
        }
    }

    static {
        METHODS_RENDERFACE.put(ForgeDirection.DOWN, "renderFaceYNeg");
        METHODS_RENDERFACE.put(ForgeDirection.UP, "renderFaceYPos");
        METHODS_RENDERFACE.put(ForgeDirection.NORTH, "renderFaceZPos");
        METHODS_RENDERFACE.put(ForgeDirection.EAST, "renderFaceXPos");
        METHODS_RENDERFACE.put(ForgeDirection.SOUTH, "renderFaceZNeg");
        METHODS_RENDERFACE.put(ForgeDirection.WEST, "renderFaceXNeg");
        FIELDS_UVROTATE = new HashMap<ForgeDirection, String>();
        FIELDS_UVROTATE.put(ForgeDirection.DOWN, "uvRotateBottom");
        FIELDS_UVROTATE.put(ForgeDirection.UP, "uvRotateTop");
        FIELDS_UVROTATE.put(ForgeDirection.NORTH, "uvRotateEast");
        FIELDS_UVROTATE.put(ForgeDirection.EAST, "uvRotateSouth");
        FIELDS_UVROTATE.put(ForgeDirection.SOUTH, "uvRotateWest");
        FIELDS_UVROTATE.put(ForgeDirection.WEST, "uvRotateNorth");
        METHODS_RENDERFACE_OBFUSICATED = new HashMap<ForgeDirection, String>();
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.DOWN, "func_147768_a");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.UP, "func_147806_b");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.NORTH, "func_147734_d");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.EAST, "func_147764_f");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.SOUTH, "func_147761_c");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.WEST, "func_147798_e");
        FIELDS_UVROTATE_OBFUSICATED = new HashMap<ForgeDirection, String>();
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.DOWN, "field_147865_v");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.UP, "field_147867_u");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.NORTH, "field_147875_q");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.EAST, "field_147871_s");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.SOUTH, "field_147873_r");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.WEST, "field_147869_t");
        ROTATE_UV_ROTATE = new int[]{0, 1, 3, 2};
    }
}

