/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.config.configurable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.config.ElementType;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.configurable.Configurable;
import evilcraft.api.item.DamageIndicatedItemFluidContainer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class ConfigurableDamageIndicatedItemFluidContainer
extends DamageIndicatedItemFluidContainer
implements Configurable {
    protected ExtendedConfig eConfig = null;
    public static ElementType TYPE = ElementType.ITEM;
    protected boolean canPickUp = true;
    private boolean placeFluids = false;

    protected ConfigurableDamageIndicatedItemFluidContainer(ExtendedConfig eConfig, int capacity, Fluid fluid) {
        super(capacity, fluid);
        this.setConfig(eConfig);
        this.func_77655_b(this.getUniqueName());
    }

    @Override
    public void setConfig(ExtendedConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public String getUniqueName() {
        return "items." + this.eConfig.NAMEDID;
    }

    public String func_111208_A() {
        return "evilcraft:" + this.eConfig.NAMEDID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        FluidStack fluidStack = this.getFluid(itemStack);
        FluidStack drained = this.drain(itemStack, 1000, false);
        Block block = this.getFluid().getBlock();
        boolean hasBucket = drained != null && drained.amount == 1000;
        boolean hasSpace = fluidStack == null || fluidStack.amount + 1000 <= this.getCapacity(itemStack);
        MovingObjectPosition movingobjectpositionDrain = this.func_77621_a(world, player, false);
        MovingObjectPosition movingobjectpositionFill = this.func_77621_a(world, player, true);
        if (movingobjectpositionDrain != null && movingobjectpositionFill != null) {
            int z;
            int y;
            int x;
            if (movingobjectpositionFill.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                x = movingobjectpositionFill.field_72311_b;
                y = movingobjectpositionFill.field_72312_c;
                z = movingobjectpositionFill.field_72309_d;
                if (!world.func_72962_a(player, x, y, z)) {
                    return itemStack;
                }
                if (!player.func_82247_a(x, y, z, movingobjectpositionFill.field_72310_e, itemStack)) {
                    return itemStack;
                }
                if (world.func_147439_a(x, y, z) == block && world.func_72805_g(x, y, z) == 0) {
                    if (hasSpace) {
                        world.func_147468_f(x, y, z);
                        this.fill(itemStack, new FluidStack(this.getFluid(), 1000), true);
                    }
                    return itemStack;
                }
            }
            if (hasBucket && movingobjectpositionDrain.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                x = movingobjectpositionDrain.field_72311_b;
                y = movingobjectpositionDrain.field_72312_c;
                z = movingobjectpositionDrain.field_72309_d;
                if (!world.func_72962_a(player, x, y, z)) {
                    return itemStack;
                }
                ForgeDirection direction = ForgeDirection.getOrientation((int)movingobjectpositionDrain.field_72310_e);
                if (!player.func_82247_a(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ, movingobjectpositionDrain.field_72310_e, itemStack)) {
                    return itemStack;
                }
                if (this.tryPlaceContainedLiquid(world, x, y, z, block, hasBucket)) {
                    this.drain(itemStack, 1000, true);
                    return itemStack;
                }
            }
        }
        return itemStack;
    }

    private boolean tryPlaceContainedLiquid(World world, int x, int y, int z, Block block, boolean hasBucket) {
        if (!hasBucket) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        if (!world.func_147437_c(x, y, z) && material.func_76220_a()) {
            return false;
        }
        if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
            world.func_147480_a(x, y, z, true);
        }
        world.func_147465_d(x, y, z, block, 0, 3);
        return true;
    }

    public boolean func_82788_x() {
        return true;
    }

    public boolean isPlaceFluids() {
        return this.placeFluids;
    }

    public void setPlaceFluids(boolean placeFluids) {
        this.placeFluids = placeFluids;
    }
}

