/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.config.configurable;

import cpw.mods.fml.common.registry.VillagerRegistry;
import evilcraft.api.config.ElementType;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.VillagerConfig;
import evilcraft.api.config.configurable.Configurable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class ConfigurableVillager
implements Configurable,
VillagerRegistry.IVillageTradeHandler {
    protected ExtendedConfig<VillagerConfig> eConfig = null;
    public static ElementType TYPE = ElementType.VILLAGER;
    protected List<WeightedItemStack> allowedTradeInputs = new ArrayList<WeightedItemStack>();
    protected List<WeightedItemStack> allowedTradeOutputs = new ArrayList<WeightedItemStack>();
    protected int maxWeightDifference = 5;
    protected int inputMinStackSize = 1;
    protected int inputMaxStackSize = 64;
    protected int addedRecipes = 0;
    protected int requiredAddedRecipes = 10;
    private int attemptAddRecipeUpperbound = 100;
    private int attemptAddRecipe = 0;

    protected ConfigurableVillager(ExtendedConfig eConfig) {
        this.setConfig(eConfig);
    }

    @Override
    public void setConfig(ExtendedConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public String getUniqueName() {
        return "villager." + this.eConfig.NAMEDID;
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        if (villager.func_70946_n() == this.eConfig.downCast().ID) {
            while (this.addedRecipes < this.requiredAddedRecipes && this.attemptAddRecipe < this.attemptAddRecipeUpperbound) {
                WeightedItemStack outputWeighted = this.getRandomOutput(random);
                WeightedItemStack inputAWeighted = this.getRandomInput(random);
                if (this.tryAddingRecipe(recipeList, random, inputAWeighted, null, outputWeighted)) continue;
                WeightedItemStack inputBWeighted = this.getRandomInput(random);
                this.tryAddingRecipe(recipeList, random, inputAWeighted, inputBWeighted, outputWeighted);
            }
        }
    }

    private boolean tryAddingRecipe(MerchantRecipeList recipeList, Random random, WeightedItemStack inputAWeighted, WeightedItemStack inputBWeighted, WeightedItemStack outputWeighted) {
        ItemStack inputB;
        ++this.attemptAddRecipe;
        int inputWeight = inputAWeighted.getWeight();
        if (inputBWeighted != null) {
            inputWeight += inputBWeighted.getWeight();
        }
        if (outputWeighted.getWeight() - inputWeight >= this.maxWeightDifference) {
            return false;
        }
        int totalInputWeight = 0;
        ItemStack inputA = inputAWeighted.getItemStack().func_77946_l();
        inputA.field_77994_a = Math.min(inputA.field_77994_a, this.getRandomBetween(random, this.inputMinStackSize, this.inputMaxStackSize));
        totalInputWeight += inputA.field_77994_a * inputAWeighted.getItemStack().field_77994_a / inputAWeighted.getWeight();
        if (inputBWeighted != null) {
            inputB = inputAWeighted.getItemStack().func_77946_l();
            inputB.field_77994_a = Math.min(inputB.field_77994_a, this.getRandomBetween(random, this.inputMinStackSize, this.inputMaxStackSize));
            totalInputWeight += inputB.field_77994_a * inputBWeighted.getItemStack().field_77994_a / inputBWeighted.getWeight();
        } else {
            inputB = null;
        }
        ItemStack output = outputWeighted.getItemStack().func_77946_l();
        output.field_77994_a = Math.min(64, Math.max(1, this.safeDivide(totalInputWeight, this.safeDivide(outputWeighted.getItemStack().field_77994_a, outputWeighted.getWeight()))));
        recipeList.func_77205_a(new MerchantRecipe(inputA, inputB, output));
        ++this.addedRecipes;
        return true;
    }

    protected int safeDivide(int i, int j) {
        return i / Math.max(1, j);
    }

    protected WeightedItemStack getRandomWeightedItemStack(List<WeightedItemStack> trades, Random random) {
        return trades.get(random.nextInt(trades.size()));
    }

    protected WeightedItemStack getRandomInput(Random random) {
        return this.getRandomWeightedItemStack(this.allowedTradeInputs, random);
    }

    protected WeightedItemStack getRandomOutput(Random random) {
        return this.getRandomWeightedItemStack(this.allowedTradeOutputs, random);
    }

    protected int getRandomBetween(Random random, int min, int max) {
        return min + random.nextInt(max - min);
    }

    public class WeightedItemStack {
        private ItemStack itemStack;
        private int weight;

        public WeightedItemStack(ItemStack itemStack, int weight) {
            this.itemStack = itemStack;
            this.weight = weight;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

