/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.entities.tileentitites;

import evilcraft.api.Helpers;
import evilcraft.api.entities.tileentitites.EvilCraftTileEntity;
import evilcraft.api.inventory.SimpleInventory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class InventoryTileEntity
extends EvilCraftTileEntity
implements IInventory,
ISidedInventory {
    protected SimpleInventory inventory;
    protected Map<ForgeDirection, int[]> slotSides;
    protected Map<ForgeDirection, Integer> slotSidesSize;

    public InventoryTileEntity(int inventorySize, String inventoryName, int stackSize) {
        this.inventory = new SimpleInventory(inventorySize, inventoryName, stackSize);
        this.slotSides = new HashMap<ForgeDirection, int[]>();
        this.slotSidesSize = new HashMap<ForgeDirection, Integer>();
        for (ForgeDirection side : Helpers.DIRECTIONS) {
            this.slotSides.put(side, new int[inventorySize]);
            this.slotSidesSize.put(side, 0);
        }
    }

    public InventoryTileEntity(int inventorySize, String inventoryName) {
        this(inventorySize, inventoryName, 64);
    }

    protected void addSlotsToSide(ForgeDirection side, Collection<Integer> slots) {
        int[] currentSlots = this.slotSides.get(side);
        int offset = this.slotSidesSize.get(side);
        int i = 0;
        Iterator<Integer> i$ = slots.iterator();
        while (i$.hasNext()) {
            int slot;
            currentSlots[offset + i] = slot = i$.next().intValue();
            ++i;
        }
        this.slotSidesSize.put(side, offset + i);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        if (slotId >= this.func_70302_i_() || slotId < 0) {
            return null;
        }
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inventory.func_70298_a(slotId, count);
    }

    public ItemStack func_70304_b(int slotId) {
        return this.inventory.func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.inventory.func_70299_a(slotId, itemstack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventory.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.inventory.writeToNBT(data);
    }

    public int[] func_94128_d(int side) {
        return this.slotSides.get(ForgeDirection.getOrientation((int)side));
    }

    private boolean canAccess(int slot, int side) {
        boolean canAccess = false;
        for (int slotAccess : this.func_94128_d(side)) {
            if (slotAccess != slot) continue;
            canAccess = true;
        }
        return canAccess;
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return this.canAccess(slot, side) && this.func_94041_b(slot, itemStack);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return this.canAccess(slot, side);
    }
}

