/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.entities.tileentitites;

import evilcraft.api.entities.tileentitites.TankInventoryTileEntity;
import evilcraft.api.entities.tileentitites.tickaction.ITickAction;
import evilcraft.api.entities.tileentitites.tickaction.TickComponent;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;

public abstract class TickingTankInventoryTileEntity<T extends TankInventoryTileEntity>
extends TankInventoryTileEntity {
    private LinkedList<TickComponent<T, ITickAction<T>>> tickers = new LinkedList();
    private int currentState = -1;
    private int previousState = -1;

    public TickingTankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, Fluid acceptedFluid) {
        super(inventorySize, inventoryName, tankSize, tankName, acceptedFluid);
    }

    protected int addTicker(TickComponent<T, ITickAction<T>> ticker) {
        this.tickers.add(ticker);
        return this.tickers.size() - 1;
    }

    public LinkedList<TickComponent<T, ITickAction<T>>> getTickers() {
        return this.tickers;
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.currentState = data.func_74762_e("currentState");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("currentState", this.currentState);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            for (TickComponent tickComponent : this.getTickers()) {
                tickComponent.tick(this.inventory.func_70301_a(tickComponent.getSlot()), tickComponent.getSlot());
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            int newState = this.getNewState();
            if (newState != this.currentState) {
                this.currentState = newState;
                this.onStateChanged();
            }
        } else if (this.previousState != this.currentState) {
            this.previousState = this.currentState;
            this.onStateChanged();
        }
    }

    public abstract int getNewState();

    public abstract void onStateChanged();

    public int getCurrentState() {
        return this.currentState;
    }
}

