/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.gui.container;

import evilcraft.api.entities.tileentitites.EvilCraftTileEntity;
import evilcraft.api.entities.tileentitites.InventoryTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class InventoryContainer<T extends InventoryTileEntity>
extends Container {
    protected static final int ITEMBOX = 18;
    private IInventory playerIInventory;
    protected T tile;

    public InventoryContainer(InventoryPlayer inventory, T tile) {
        this.playerIInventory = inventory;
        this.tile = tile;
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return ((EvilCraftTileEntity)((Object)this.tile)).canInteractWith(entityPlayer);
    }

    protected void addPlayerInventory(InventoryPlayer inventory, int offsetX, int offsetY) {
        int rows = 3;
        int cols = 9;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.func_75146_a(new Slot((IInventory)inventory, x + (y + 1) * cols, offsetX + x * 18, offsetY + y * 18));
            }
        }
        offsetY += 58;
        for (int x = 0; x < cols; ++x) {
            this.func_75146_a(new Slot((IInventory)inventory, x, offsetX + x * 18, offsetY));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotID);
        int slots = ((InventoryTileEntity)((Object)this.tile)).func_70302_i_();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slotID < slots ? !this.func_75135_a(stackInSlot, slots, this.field_75151_b.size(), true) : !this.func_75135_a(stackInSlot, 0, slots, false)) {
                return null;
            }
            if (stackInSlot.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int slotStart, int slotRange, boolean reverse) {
        ItemStack existingStack;
        Slot slot;
        boolean successful = false;
        int slotIndex = slotStart;
        int maxStack = Math.min(stack.func_77976_d(), ((InventoryTileEntity)((Object)this.tile)).func_70302_i_());
        if (reverse) {
            slotIndex = slotRange - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                existingStack = slot.func_75211_c();
                if (slot.func_75214_a(stack) && existingStack != null && existingStack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == existingStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.field_77994_a + stack.field_77994_a;
                    if (existingSize <= maxStack) {
                        stack.field_77994_a = 0;
                        existingStack.field_77994_a = existingSize;
                        slot.func_75218_e();
                        successful = true;
                    } else if (existingStack.field_77994_a < maxStack) {
                        stack.field_77994_a -= maxStack - existingStack.field_77994_a;
                        existingStack.field_77994_a = maxStack;
                        slot.func_75218_e();
                        successful = true;
                    }
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        if (stack.field_77994_a > 0) {
            slotIndex = reverse ? slotRange - 1 : slotStart;
            while (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                existingStack = slot.func_75211_c();
                if (slot.func_75214_a(stack) && existingStack == null) {
                    slot.func_75215_d(stack.func_77946_l());
                    slot.func_75218_e();
                    stack.field_77994_a = 0;
                    successful = true;
                    break;
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return successful;
    }

    public IInventory getPlayerIInventory() {
        return this.playerIInventory;
    }
}

