/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.Helpers;
import evilcraft.api.config.BlockConfig;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.configurable.ConfigurableBlockContainerGuiTankInfo;
import evilcraft.api.entities.tileentitites.TankInventoryTileEntity;
import evilcraft.entities.tileentities.TileBloodInfuser;
import evilcraft.gui.client.GuiBloodInfuser;
import evilcraft.gui.container.ContainerBloodInfuser;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BloodInfuser
extends ConfigurableBlockContainerGuiTankInfo {
    private static BloodInfuser _instance = null;
    private IIcon sideIcon;
    private IIcon topIcon;
    private IIcon frontIconOn;
    private IIcon frontIconOff;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new BloodInfuser(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BloodInfuser getInstance() {
        return _instance;
    }

    private BloodInfuser(ExtendedConfig<BlockConfig> eConfig) {
        super((ExtendedConfig)eConfig, Material.field_151576_e, (Class<? extends TankInventoryTileEntity>)TileBloodInfuser.class);
        this.func_149672_a(field_149769_e);
        this.setRotatable(true);
        if (Helpers.isClientSide()) {
            this.setGUI(GuiBloodInfuser.class);
        }
        this.setContainer(ContainerBloodInfuser.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcon = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.UP.name());
        this.sideIcon = iconRegister.func_94245_a(this.func_149641_N() + "_" + "side");
        this.frontIconOn = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.NORTH.name() + "_on");
        this.frontIconOff = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.NORTH.name() + "_off");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileBloodInfuser tile = (TileBloodInfuser)world.func_147438_o(x, y, z);
        ForgeDirection rotatedDirection = Helpers.TEXTURESIDE_ORIENTATION[tile.getRotation().ordinal()][side];
        return this.func_149691_a(rotatedDirection.ordinal(), tile.isBlockInfusing() ? 1 : 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
            return this.topIcon;
        }
        if (side == ForgeDirection.SOUTH.ordinal()) {
            if (meta == 1) {
                return this.frontIconOn;
            }
            return this.frontIconOff;
        }
        return this.sideIcon;
    }

    public Item func_149650_a(int par1, Random random, int zero) {
        return Item.func_150898_a((Block)this);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileBloodInfuser tile = (TileBloodInfuser)world.func_147438_o(x, y, z);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil(15.0f * output);
    }

    @Override
    public String getTankNBTName() {
        return TileBloodInfuser.TANKNAME;
    }

    @Override
    public int getTankCapacity() {
        return 10000;
    }
}

