/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.entities.tileentities;

import evilcraft.CustomRecipe;
import evilcraft.CustomRecipeRegistry;
import evilcraft.CustomRecipeResult;
import evilcraft.api.entities.tileentitites.TickingTankInventoryTileEntity;
import evilcraft.api.entities.tileentitites.tickaction.ITickAction;
import evilcraft.api.entities.tileentitites.tickaction.TickComponent;
import evilcraft.blocks.BloodInfuser;
import evilcraft.entities.tileentities.tickaction.EmptyFluidContainerInTankTickAction;
import evilcraft.entities.tileentities.tickaction.EmptyItemBucketInTankTickAction;
import evilcraft.entities.tileentities.tickaction.bloodinfuser.FluidContainerItemTickAction;
import evilcraft.entities.tileentities.tickaction.bloodinfuser.InfuseItemTickAction;
import evilcraft.entities.tileentities.tickaction.bloodinfuser.ItemBucketTickAction;
import evilcraft.fluids.Blood;
import evilcraft.gui.slot.SlotFluidContainer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileBloodInfuser
extends TickingTankInventoryTileEntity<TileBloodInfuser> {
    public static final int SLOTS = 3;
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_INFUSE = 1;
    public static final int SLOT_INFUSE_RESULT = 2;
    public static String TANKNAME = "bloodInfuserTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    private int infuseTicker = this.addTicker(new TickComponent<TileBloodInfuser, ITickAction<TileBloodInfuser>>(this, INFUSE_TICK_ACTIONS, 1));
    private static final Map<Class<?>, ITickAction<TileBloodInfuser>> INFUSE_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileBloodInfuser>> EMPTY_IN_TANK_TICK_ACTIONS;

    public TileBloodInfuser() {
        super(3, BloodInfuser.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        this.addTicker(new TickComponent<TileBloodInfuser, ITickAction<TileBloodInfuser>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0));
        LinkedList<Integer> inSlots = new LinkedList<Integer>();
        inSlots.add(1);
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(0);
        LinkedList<Integer> outSlots = new LinkedList<Integer>();
        outSlots.add(2);
        this.addSlotsToSide(ForgeDirection.EAST, inSlotsTank);
        this.addSlotsToSide(ForgeDirection.UP, inSlots);
        this.addSlotsToSide(ForgeDirection.DOWN, outSlots);
        this.addSlotsToSide(ForgeDirection.SOUTH, outSlots);
        this.addSlotsToSide(ForgeDirection.WEST, outSlots);
    }

    public boolean canConsume(ItemStack itemStack) {
        CustomRecipe customRecipeKey;
        CustomRecipeResult result;
        if (itemStack.func_77973_b() == Items.field_151133_ar && this.getTank().getFluidAmount() >= 1000) {
            return true;
        }
        if (itemStack.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)itemStack.func_77973_b();
            FluidStack fluidStack = container.getFluid(itemStack);
            if (fluidStack == null) {
                return true;
            }
            if (fluidStack.getFluid() == this.tank.getAcceptedFluid() && fluidStack.amount < container.getCapacity(itemStack)) {
                return true;
            }
        }
        return (result = CustomRecipeRegistry.get(customRecipeKey = new CustomRecipe(itemStack, this.tank.getFluid(), (Block)BloodInfuser.getInstance()))) != null;
    }

    public int getConsumeSlot() {
        return 1;
    }

    public int getProduceSlot() {
        return 2;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return this.canConsume(itemStack);
        }
        if (slot == 0) {
            return SlotFluidContainer.checkIsItemValid(itemStack, ACCEPTED_FLUID);
        }
        return false;
    }

    public boolean isInfusing() {
        return this.getInfuseTick() > 0;
    }

    public boolean isBlockInfusing() {
        return this.getCurrentState() == 1;
    }

    public int getInfuseTickScaled(int scale) {
        return (int)((float)this.getInfuseTick() / (float)this.getRequiredTicks() * (float)scale);
    }

    private int getInfuseTick() {
        return this.getTickers().get(this.infuseTicker).getTick();
    }

    private int getRequiredTicks() {
        return this.getTickers().get(this.infuseTicker).getRequiredTicks();
    }

    public void resetInfusion() {
        this.getTickers().get(this.infuseTicker).setTick(0);
        this.getTickers().get(this.infuseTicker).setRequiredTicks(0);
    }

    @Override
    public int getNewState() {
        return this.isInfusing() ? 1 : 0;
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
    }

    static {
        INFUSE_TICK_ACTIONS.put(ItemBucket.class, new ItemBucketTickAction());
        INFUSE_TICK_ACTIONS.put(IFluidContainerItem.class, new FluidContainerItemTickAction());
        INFUSE_TICK_ACTIONS.put(Item.class, new InfuseItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(ItemBucket.class, new EmptyItemBucketInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
    }
}

