/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.entities.tileentities.tickaction;

import evilcraft.api.entities.tileentitites.InventoryTileEntity;
import evilcraft.api.entities.tileentitites.TankInventoryTileEntity;
import evilcraft.api.entities.tileentitites.TickingTankInventoryTileEntity;
import evilcraft.entities.tileentities.tickaction.EmptyInTankTickAction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class EmptyFluidContainerInTankTickAction<T extends TickingTankInventoryTileEntity<T>>
extends EmptyInTankTickAction<T> {
    @Override
    public void onTick(T tile, ItemStack itemStack, int slot, int tick) {
        ItemStack containerStack = ((InventoryTileEntity)((Object)tile)).getInventory().func_70301_a(slot);
        IFluidContainerItem container = (IFluidContainerItem)containerStack.func_77973_b();
        if (container.getFluid(containerStack) != null) {
            FluidStack fluidStack = container.getFluid(containerStack).copy();
            fluidStack.amount = Math.min(100, fluidStack.amount);
            int filled = ((TankInventoryTileEntity)((Object)tile)).getTank().fill(fluidStack, true);
            container.drain(containerStack, filled, true);
        }
    }

    @Override
    public int getRequiredTicks(T tile, int slot) {
        return EmptyFluidContainerInTankTickAction.getRequiredTicks(tile, ((InventoryTileEntity)((Object)tile)).getInventory().func_70301_a(slot));
    }

    public static int getRequiredTicks(TankInventoryTileEntity tile, ItemStack itemStack) {
        IFluidContainerItem container = (IFluidContainerItem)itemStack.func_77973_b();
        int amount = 0;
        if (container.getFluid(itemStack) != null) {
            amount = container.getFluid((ItemStack)itemStack).amount;
        }
        int capacity = Math.min(container.getCapacity(itemStack), tile.getTank().getFluidAmount());
        return (capacity - amount) / 100;
    }

    @Override
    public boolean canTick(T tile, ItemStack itemStack, int slot, int tick) {
        boolean emptyContainer = false;
        ItemStack containerStack = ((InventoryTileEntity)((Object)tile)).getInventory().func_70301_a(slot);
        IFluidContainerItem container = (IFluidContainerItem)containerStack.func_77973_b();
        if (container.getFluid(containerStack) != null) {
            FluidStack fluidStack = container.getFluid(containerStack);
            if (fluidStack.amount <= 0) {
                emptyContainer = true;
            }
        } else {
            emptyContainer = true;
        }
        return super.canTick(tile, itemStack, slot, tick) && !emptyContainer;
    }
}

