/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.worldgen.structure;

import evilcraft.blocks.BloodyCobblestone;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;

public class EvilDungeonStructure
extends WorldGenDungeons {
    private static final int RADIUS_X = 3;
    private static final int RADIUS_X_RAND = 4;
    private static final int RADIUS_Z = 3;
    private static final int RADIUS_Z_RAND = 4;
    private static final int CHESTS = 2;
    private static final int CHESTS_RAND = 2;

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int zr;
        int yr;
        int xr;
        int height = 3;
        int radiusX = random.nextInt(4) + 3;
        int radiusZ = random.nextInt(4) + 3;
        int chests = random.nextInt(2) + 2;
        int openingCounter = 0;
        for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
            for (yr = y - 1; yr <= y + height + 1; ++yr) {
                for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                    Material material = world.func_147439_a(xr, yr, zr).func_149688_o();
                    if (yr == y - 1 && !material.func_76220_a()) {
                        return false;
                    }
                    if (yr == y + height + 1 && !material.func_76220_a()) {
                        return false;
                    }
                    if (xr != x - radiusX - 1 && xr != x + radiusX + 1 && zr != z - radiusZ - 1 && zr != z + radiusZ + 1 || yr != y || !world.func_147437_c(xr, yr, zr) || !world.func_147437_c(xr, yr + 1, zr)) continue;
                    ++openingCounter;
                }
            }
        }
        if (openingCounter >= 1 && openingCounter <= 15) {
            for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
                for (yr = y + height; yr >= y - 1; --yr) {
                    for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                        if (xr != x - radiusX - 1 && yr != y - 1 && zr != z - radiusZ - 1 && xr != x + radiusX + 1 && yr != y + height + 1 && zr != z + radiusZ + 1) {
                            world.func_147468_f(xr, yr, zr);
                            continue;
                        }
                        if (yr >= 0 && !world.func_147439_a(xr, yr - 1, zr).func_149688_o().func_76220_a()) {
                            world.func_147468_f(xr, yr, zr);
                            continue;
                        }
                        if (!world.func_147439_a(xr, yr, zr).func_149688_o().func_76220_a()) continue;
                        if (yr == y - 1 && random.nextInt(4) != 0) {
                            world.func_147465_d(xr, yr, zr, (Block)BloodyCobblestone.getInstance(), 0, 2);
                            continue;
                        }
                        world.func_147465_d(xr, yr, zr, Blocks.field_150347_e, 0, 2);
                    }
                }
            }
            int attempts = 100;
            for (int xr2 = 0; xr2 < attempts && chests > 0; ++xr2) {
                int zrr;
                int xrr = x + random.nextInt(radiusX * 2 + 1) - radiusX;
                if (!world.func_147437_c(xrr, y, zrr = z + random.nextInt(radiusZ * 2 + 1) - radiusZ)) continue;
                int wallCounter = 0;
                if (world.func_147439_a(xrr - 1, y, zrr).func_149688_o().func_76220_a()) {
                    ++wallCounter;
                }
                if (world.func_147439_a(xrr + 1, y, zrr).func_149688_o().func_76220_a()) {
                    ++wallCounter;
                }
                if (world.func_147439_a(xrr, y, zrr - 1).func_149688_o().func_76220_a()) {
                    ++wallCounter;
                }
                if (world.func_147439_a(xrr, y, zrr + 1).func_149688_o().func_76220_a()) {
                    ++wallCounter;
                }
                if (wallCounter != 1) continue;
                world.func_147465_d(xrr, y, zrr, (Block)Blocks.field_150486_ae, 0, 2);
                TileEntityChest tileentitychest = (TileEntityChest)world.func_147438_o(xrr, y, zrr);
                if (tileentitychest != null) {
                    ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                    WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])info.getItems(random), (IInventory)tileentitychest, (int)(info.getCount(random) * 2));
                }
                --chests;
            }
            for (int xs = x - 1; xs <= x + 1; xs += 2) {
                for (int zs = z - 1; zs <= z + 1; zs += 2) {
                    world.func_147465_d(xs, y, zs, Blocks.field_150474_ac, 0, 2);
                    TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_147438_o(xs, y, zs);
                    if (tileentitymobspawner != null) {
                        tileentitymobspawner.func_145881_a().func_98272_a(this.pickMobSpawner(random));
                        continue;
                    }
                    System.err.println("Failed to fetch mob spawner entity at (" + xs + ", " + y + ", " + zs + ")");
                }
            }
            return true;
        }
        return false;
    }

    private String pickMobSpawner(Random par1Random) {
        return DungeonHooks.getRandomDungeonMob((Random)par1Random);
    }
}

