/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.taverns.gen;

import de.vernideas.mc.common.ai.GuardAI;
import de.vernideas.mc.common.gen.BiomeSpecificBlock;
import de.vernideas.mc.common.util.TimePeriod;
import de.vernideas.mc.taverns.Settings;
import de.vernideas.mc.taverns.Taverns;
import de.vernideas.mc.taverns.direction.Dir;
import de.vernideas.mc.taverns.gen.ComponentVillageBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ComponentVillageStall
extends ComponentVillageBase {
    public static final String STALL_CHEST = "taverns:stallChest";
    public static final WeightedRandomChestContent[] stallChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 1, 3), new WeightedRandomChestContent(Items.field_151153_ao, 1, 1, 1, 1), new WeightedRandomChestContent(Items.field_151153_ao, 0, 1, 1, 3), new WeightedRandomChestContent(Items.field_151138_bX, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151136_bY, 0, 1, 1, 2), new WeightedRandomChestContent(Items.field_151141_av, 0, 1, 1, 40), new WeightedRandomChestContent(Items.field_151150_bK, 0, 1, 3, 10), new WeightedRandomChestContent(Items.field_151034_e, 0, 1, 8, 50), new WeightedRandomChestContent(new ItemStack(Blocks.field_150423_aK), 1, 3, 25), new WeightedRandomChestContent(new ItemStack(Blocks.field_150407_cf), 1, 5, 30), new WeightedRandomChestContent(Items.field_151172_bF, 0, 1, 5, 30), new WeightedRandomChestContent(Items.field_151116_aA, 0, 1, 9, 30), new WeightedRandomChestContent(Items.field_151057_cb, 0, 1, 1, 10)};
    public static boolean initialized = false;
    public static boolean postInitialized = false;
    private static final int HEIGHT = 7;
    private int averageGroundLevel = -1;
    private boolean horseSpawned = false;
    private boolean villagerSpawned = false;
    private int chestPosX;
    private boolean hasMadeChest = false;

    public static void init(Settings config) {
        if (!initialized) {
            initialized = true;
            ChestGenHooks.getInfo((String)STALL_CHEST).setMin(1);
            ChestGenHooks.getInfo((String)STALL_CHEST).setMax(10);
            for (int i = 0; i < stallChestContents.length; ++i) {
                ChestGenHooks.addItem((String)STALL_CHEST, (WeightedRandomChestContent)stallChestContents[i]);
            }
            MapGenStructureIO.func_143031_a(ComponentVillageStall.class, (String)"taverns:ViS");
        }
    }

    public static void postInit(Settings config) {
        if (!postInitialized) {
            postInitialized = true;
            if (config.grimoireOfGaia2) {
                // empty if block
            }
        }
    }

    public static Object buildComponent(StructureVillagePieces.Start startPiece, List pieces, Random random, int x, int y, int z, int direction, int type) {
        StructureBoundingBox structBB = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)11, (int)7, (int)10, (int)direction);
        if (ComponentVillageStall.func_74895_a((StructureBoundingBox)structBB) && null == StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structBB)) {
            return new ComponentVillageStall(startPiece, type, random, structBB, direction);
        }
        return null;
    }

    public ComponentVillageStall() {
    }

    public ComponentVillageStall(StructureVillagePieces.Start startPiece, int type, Random rnd, StructureBoundingBox structBB, int direction) {
        super(startPiece, type, rnd, structBB, direction);
        this.chestPosX = rnd.nextBoolean() ? 3 : 7;
    }

    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("HorseSpawned", this.horseSpawned);
        par1NBTTagCompound.func_74757_a("VillagerSpawned", this.villagerSpawned);
        par1NBTTagCompound.func_74768_a("ChestPosX", this.chestPosX);
        par1NBTTagCompound.func_74757_a("Chest", this.hasMadeChest);
    }

    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.horseSpawned = par1NBTTagCompound.func_74767_n("HorseSpawned");
        this.villagerSpawned = par1NBTTagCompound.func_74767_n("VillagerSpawned");
        this.chestPosX = par1NBTTagCompound.func_74762_e("ChestPosX");
        this.hasMadeChest = par1NBTTagCompound.func_74767_n("Chest");
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bb) {
        EntityVillager villager;
        int chestZ;
        int chestY;
        int chestX;
        int xx;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, bb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 7 - 2, 0);
        }
        BiomeGenBase biome = this.startPiece == null ? null : this.startPiece.biome;
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Blocks.field_150344_f, 0, biome);
        BiomeSpecificBlock cobble = BiomeSpecificBlock.query(Blocks.field_150347_e, 0, biome);
        BiomeSpecificBlock cobbleWall = BiomeSpecificBlock.query(Blocks.field_150463_bK, 0, biome);
        BiomeSpecificBlock cobbleMossy = this.getMossyCobble(biome);
        BiomeSpecificBlock dirt = BiomeSpecificBlock.query(Blocks.field_150346_d, 0, biome);
        BiomeSpecificBlock gravel = BiomeSpecificBlock.query(Blocks.field_150351_n, 0, biome);
        BiomeSpecificBlock woodUp = BiomeSpecificBlock.query(Blocks.field_150364_r, 0, biome);
        BiomeSpecificBlock woodNorth = this.getSpecificBlock(Blocks.field_150364_r, ForgeDirection.NORTH, biome);
        BiomeSpecificBlock woodWest = this.getSpecificBlock(Blocks.field_150364_r, ForgeDirection.WEST, biome);
        BiomeSpecificBlock fence = BiomeSpecificBlock.query(Blocks.field_150422_aJ, 0, biome);
        BiomeSpecificBlock woodSlab = this.getWoodSlab(0, ForgeDirection.DOWN, biome);
        BiomeSpecificBlock roofNorth = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.NORTH, biome);
        BiomeSpecificBlock roofSouth = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.SOUTH, biome);
        BiomeSpecificBlock roofNorthUpside = BiomeSpecificBlock.query(Blocks.field_150476_ad, Dir.getMeta(Blocks.field_150476_ad, ForgeDirection.NORTH, this.field_74885_f) + 4, biome);
        BiomeSpecificBlock roofSouthUpside = BiomeSpecificBlock.query(Blocks.field_150476_ad, Dir.getMeta(Blocks.field_150476_ad, ForgeDirection.SOUTH, this.field_74885_f) + 4, biome);
        this.fill(world, bb, 0, 0, 0, 10, 6, 9, BiomeSpecificBlock.air, BiomeSpecificBlock.air);
        for (xx = 0; xx < 11; ++xx) {
            for (int zz = 0; zz < 10; ++zz) {
                this.func_74871_b(world, xx, 0, zz, bb);
                this.fillDownwards(world, Blocks.field_150347_e, 0, xx, -1, zz, bb);
            }
        }
        this.fill(world, bb, 0, 0, 0, 10, 0, 9, dirt, dirt);
        this.fill(world, bb, 2, 0, 2, 8, 0, 7, cobble, cobble);
        this.fillRandomly(world, bb, random, 0.2f, 2, 0, 2, 8, 0, 7, cobbleMossy, cobbleMossy);
        this.fill(world, bb, 4, 0, 0, 6, 0, 1, gravel, gravel);
        this.placeTorch(world, bb, 2, 3, 2, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 5, 3, 2, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 8, 3, 2, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 3, 4, 5, ForgeDirection.EAST);
        this.placeTorch(world, bb, 7, 4, 5, ForgeDirection.WEST);
        for (int yy = 1; yy <= 3; ++yy) {
            this.placeBlock(world, woodUp, 2, yy, 3, bb);
            this.placeBlock(world, woodUp, 5, yy, 3, bb);
            this.placeBlock(world, woodUp, 8, yy, 3, bb);
            this.placeBlock(world, woodUp, 2, yy, 7, bb);
            this.placeBlock(world, woodUp, 5, yy, 7, bb);
            this.placeBlock(world, woodUp, 8, yy, 7, bb);
        }
        for (xx = 2; xx <= 8; ++xx) {
            this.placeBlock(world, woodWest, xx, 4, 3, bb);
            this.placeBlock(world, woodWest, xx, 6, 5, bb);
            this.placeBlock(world, woodWest, xx, 4, 7, bb);
        }
        this.placeBlock(world, woodWest, 1, 6, 5, bb);
        this.placeBlock(world, woodWest, 9, 6, 5, bb);
        for (int zz = 4; zz <= 6; ++zz) {
            this.placeBlock(world, woodNorth, 2, 4, zz, bb);
            this.placeBlock(world, woodNorth, 5, 5, zz, bb);
            this.placeBlock(world, woodNorth, 8, 4, zz, bb);
        }
        for (xx = 2; xx <= 8; xx += 6) {
            this.placeBlock(world, cobble, xx, 1, 4, bb);
            this.placeBlock(world, planks, xx, 1, 5, bb);
            this.placeBlock(world, cobble, xx, 1, 6, bb);
            this.placeBlock(world, planks, xx, 2, 4, bb);
            this.placeBlock(world, cobble, xx, 2, 5, bb);
            this.placeBlock(world, planks, xx, 2, 6, bb);
            this.placeBlock(world, cobble, xx, 3, 4, bb);
            this.placeBlock(world, planks, xx, 3, 5, bb);
            this.placeBlock(world, cobble, xx, 3, 6, bb);
            this.placeBlock(world, cobble, xx, 5, 4, bb);
            this.placeBlock(world, (Block)Blocks.field_150333_U, 11, xx, 5, 5, bb);
            this.placeBlock(world, cobble, xx, 5, 6, bb);
        }
        this.placeBlock(world, cobble, 3, 1, 7, bb);
        this.placeBlock(world, cobble, 4, 1, 7, bb);
        this.placeBlock(world, cobble, 6, 1, 7, bb);
        this.placeBlock(world, cobble, 7, 1, 7, bb);
        this.placeBlock(world, cobbleWall, 3, 2, 7, bb);
        this.placeBlock(world, cobbleWall, 4, 2, 7, bb);
        this.placeBlock(world, cobbleWall, 6, 2, 7, bb);
        this.placeBlock(world, cobbleWall, 7, 2, 7, bb);
        this.placeBlock(world, fence, 5, 1, 4, bb);
        this.placeBlock(world, fence, 5, 1, 5, bb);
        this.placeBlock(world, fence, 5, 1, 6, bb);
        this.placeBlock(world, fence, 5, 3, 4, bb);
        this.placeBlock(world, fence, 5, 3, 6, bb);
        this.placeBlock(world, Blocks.field_150396_be, ForgeDirection.NORTH, 3, 1, 3, bb);
        this.placeBlock(world, Blocks.field_150396_be, ForgeDirection.NORTH, 4, 1, 3, bb);
        this.placeBlock(world, Blocks.field_150396_be, ForgeDirection.NORTH, 6, 1, 3, bb);
        this.placeBlock(world, Blocks.field_150396_be, ForgeDirection.NORTH, 7, 1, 3, bb);
        for (xx = 1; xx <= 9; ++xx) {
            this.placeBlock(world, roofNorth, xx, 4, 2, bb);
            this.placeBlock(world, roofNorth, xx, 5, 3, bb);
            this.placeBlock(world, woodSlab, xx, 6, 4, bb);
            this.placeBlock(world, woodSlab, xx, 6, 6, bb);
            this.placeBlock(world, roofSouth, xx, 5, 7, bb);
            this.placeBlock(world, roofSouth, xx, 4, 8, bb);
        }
        this.placeBlock(world, roofSouthUpside, 1, 4, 3, bb);
        this.placeBlock(world, roofSouthUpside, 9, 4, 3, bb);
        this.placeBlock(world, roofSouthUpside, 1, 5, 4, bb);
        this.placeBlock(world, roofSouthUpside, 9, 5, 4, bb);
        this.placeBlock(world, roofNorthUpside, 1, 5, 6, bb);
        this.placeBlock(world, roofNorthUpside, 9, 5, 6, bb);
        this.placeBlock(world, roofNorthUpside, 1, 4, 7, bb);
        this.placeBlock(world, roofNorthUpside, 9, 4, 7, bb);
        this.placeBlock(world, Blocks.field_150407_cf, random.nextInt(3) * 4, 3, 1, 6, bb);
        this.placeBlock(world, Blocks.field_150407_cf, random.nextInt(3) * 4, 7, 1, 6, bb);
        if (!this.hasMadeChest && bb.func_78890_b(chestX = this.func_74865_a(this.chestPosX, 6), chestY = this.func_74862_a(0), chestZ = this.func_74873_b(this.chestPosX, 6))) {
            this.hasMadeChest = true;
            this.func_74879_a(world, bb, random, this.chestPosX, 0, 6, ChestGenHooks.getItems((String)STALL_CHEST, (Random)random), ChestGenHooks.getCount((String)STALL_CHEST, (Random)random));
        }
        if (!this.horseSpawned) {
            boolean bl = this.horseSpawned = this.spawnEntity(world, bb, random.nextBoolean() ? 4 : 6, 1, 5, 1) == 1;
        }
        if (!this.villagerSpawned && null != (villager = this.spawnVillager(world, bb, 5, 1, 1))) {
            this.villagerSpawned = true;
            int globalX = this.func_74865_a(5, 1);
            int globalY = this.func_74862_a(1);
            int globalZ = this.func_74873_b(5, 1);
            villager.field_70714_bg.func_75776_a(4, (EntityAIBase)new GuardAI((EntityLiving)villager, new ChunkCoordinates(globalX, globalY, globalZ), 3.0f, 64.0f, new TimePeriod(0.02, 0.45), false));
        }
        return true;
    }

    protected int func_74888_b(int alreadySpawned) {
        return Taverns.config.hostlerID > 0 ? Taverns.config.hostlerID : super.func_74888_b(alreadySpawned);
    }

    @Override
    protected EntityLivingBase getEntity(World world, int index) {
        return new EntityHorse(world);
    }
}

