/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.common.gen;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeSpecificBlock {
    public final int metadata;
    public final Block block;
    public static final BiomeSpecificBlock air = new BiomeSpecificBlock(Blocks.field_150350_a, 0);
    private static final Map<Pair<Block, Integer>, Pair<Block, Integer>> desertReplaceMap = new HashMap<Pair<Block, Integer>, Pair<Block, Integer>>();

    private static BiomeSpecificBlock getDesertReplacement(Block original, Integer originalMeta) {
        Pair<Block, Integer> replacement = desertReplaceMap.get(ImmutablePair.of((Object)original, (Object)originalMeta));
        if (null == replacement) {
            replacement = desertReplaceMap.get(ImmutablePair.of((Object)original, (Object)-1));
        }
        if (null != replacement) {
            return new BiomeSpecificBlock((Block)replacement.getLeft(), (Integer)replacement.getRight() >= 0 ? (Integer)replacement.getRight() : originalMeta);
        }
        return new BiomeSpecificBlock(original, originalMeta);
    }

    public static BiomeSpecificBlock queryVanilla(Block block, int meta, BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s) {
            return BiomeSpecificBlock.getDesertReplacement(block, meta);
        }
        return new BiomeSpecificBlock(block, meta);
    }

    public static BiomeSpecificBlock query(Block block, int meta, BiomeGenBase biome) {
        Block newBlock = null;
        int newMeta = -1;
        BiomeEvent.GetVillageBlockID eventBlock = new BiomeEvent.GetVillageBlockID(biome, block, meta);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)eventBlock);
        if (eventBlock.getResult() == Event.Result.DENY) {
            newBlock = eventBlock.replacement;
        }
        BiomeEvent.GetVillageBlockMeta eventMeta = new BiomeEvent.GetVillageBlockMeta(biome, block, meta);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)eventMeta);
        if (eventMeta.getResult() == Event.Result.DENY) {
            newMeta = eventMeta.replacement;
        }
        if (null != newBlock && newMeta >= 0) {
            return new BiomeSpecificBlock(newBlock, newMeta);
        }
        if (null == newBlock && newMeta < 0) {
            if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s) {
                return BiomeSpecificBlock.getDesertReplacement(block, meta);
            }
            return new BiomeSpecificBlock(block, meta);
        }
        if (null != newBlock) {
            if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s) {
                BiomeSpecificBlock desertReplacement = BiomeSpecificBlock.getDesertReplacement(block, meta);
                return new BiomeSpecificBlock(newBlock, desertReplacement.metadata);
            }
            return new BiomeSpecificBlock(newBlock, meta);
        }
        if (biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76786_s) {
            BiomeSpecificBlock desertReplacement = BiomeSpecificBlock.getDesertReplacement(block, meta);
            return new BiomeSpecificBlock(desertReplacement.block, newMeta);
        }
        return new BiomeSpecificBlock(block, newMeta);
    }

    protected BiomeSpecificBlock(Block blockInstance, int meta) {
        this.metadata = meta;
        this.block = blockInstance;
    }

    private static void addDesertReplacement(Block from, Integer fromMeta, Block to, Integer toMeta) {
        desertReplaceMap.put((Pair<Block, Integer>)ImmutablePair.of((Object)from, (Object)fromMeta), (Pair<Block, Integer>)ImmutablePair.of((Object)to, (Object)toMeta));
    }

    static {
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150364_r, -1, Blocks.field_150322_A, 0);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150344_f, -1, Blocks.field_150322_A, 0);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150347_e, -1, Blocks.field_150322_A, 0);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150341_Y, -1, Blocks.field_150322_A, 1);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150351_n, -1, Blocks.field_150322_A, 0);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150476_ad, -1, Blocks.field_150372_bz, -1);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150481_bH, -1, Blocks.field_150372_bz, -1);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150446_ar, -1, Blocks.field_150372_bz, -1);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150487_bG, -1, Blocks.field_150370_cb, -1);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150485_bF, -1, Blocks.field_150390_bg, -1);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150400_ck, -1, Blocks.field_150372_bz, -1);
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150401_cl, -1, Blocks.field_150390_bg, -1);
        BiomeSpecificBlock.addDesertReplacement((Block)Blocks.field_150333_U, 0, (Block)Blocks.field_150333_U, 1);
        BiomeSpecificBlock.addDesertReplacement((Block)Blocks.field_150333_U, 3, (Block)Blocks.field_150333_U, 1);
        BiomeSpecificBlock.addDesertReplacement((Block)Blocks.field_150333_U, 8, (Block)Blocks.field_150333_U, 9);
        BiomeSpecificBlock.addDesertReplacement((Block)Blocks.field_150333_U, 11, (Block)Blocks.field_150333_U, 9);
        BiomeSpecificBlock.addDesertReplacement((Block)Blocks.field_150334_T, 0, (Block)Blocks.field_150334_T, 1);
        BiomeSpecificBlock.addDesertReplacement((Block)Blocks.field_150334_T, 3, (Block)Blocks.field_150334_T, 1);
        for (int meta = 0; meta <= 5; ++meta) {
            BiomeSpecificBlock.addDesertReplacement((Block)Blocks.field_150376_bx, meta, (Block)Blocks.field_150333_U, 1);
            BiomeSpecificBlock.addDesertReplacement((Block)Blocks.field_150376_bx, meta + 8, (Block)Blocks.field_150333_U, 9);
            BiomeSpecificBlock.addDesertReplacement((Block)Blocks.field_150373_bw, meta, (Block)Blocks.field_150334_T, 1);
        }
        BiomeSpecificBlock.addDesertReplacement(Blocks.field_150346_d, -1, Blocks.field_150354_m, 9);
    }
}

