/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.taverns.gen;

import de.vernideas.mc.common.ai.GuardAI;
import de.vernideas.mc.common.gen.BiomeSpecificBlock;
import de.vernideas.mc.common.util.TimePeriod;
import de.vernideas.mc.taverns.Settings;
import de.vernideas.mc.taverns.Taverns;
import de.vernideas.mc.taverns.direction.Dir;
import de.vernideas.mc.taverns.gen.ComponentVillageBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ComponentVillageBakery
extends ComponentVillageBase {
    public static final String BAKERY_CHEST = "taverns:bakeryChest";
    public static final WeightedRandomChestContent[] bakeryChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151015_O, 0, 1, 10, 12), new WeightedRandomChestContent(Items.field_151120_aE, 0, 1, 8, 15), new WeightedRandomChestContent(Items.field_151102_aT, 0, 1, 10, 12), new WeightedRandomChestContent(Items.field_151110_aK, 0, 1, 12, 8), new WeightedRandomChestContent(Items.field_151117_aB, 0, 1, 2, 3), new WeightedRandomChestContent(Items.field_151133_ar, 0, 1, 3, 6), new WeightedRandomChestContent(Items.field_151080_bb, 0, 1, 15, 5), new WeightedRandomChestContent(new ItemStack(Blocks.field_150423_aK), 1, 2, 3), new WeightedRandomChestContent(Items.field_151081_bc, 0, 1, 3, 2), new WeightedRandomChestContent(new ItemStack(Blocks.field_150440_ba), 1, 2, 1), new WeightedRandomChestContent(Items.field_151025_P, 0, 1, 3, 1), new WeightedRandomChestContent(Items.field_151034_e, 0, 1, 3, 3), new WeightedRandomChestContent(Items.field_151172_bF, 0, 1, 3, 3)};
    public static boolean initialized = false;
    public static boolean postInitialized = false;
    private static final int HEIGHT = 14;
    private int averageGroundLevel = -1;
    private boolean hasMadeChest;
    private int carpetColor;
    private boolean villagerSpawned = false;

    public static void init(Settings config) {
        if (!initialized) {
            initialized = true;
            ChestGenHooks.getInfo((String)BAKERY_CHEST).setMin(1);
            ChestGenHooks.getInfo((String)BAKERY_CHEST).setMax(8);
            for (int i = 0; i < bakeryChestContents.length; ++i) {
                ChestGenHooks.addItem((String)BAKERY_CHEST, (WeightedRandomChestContent)bakeryChestContents[i]);
            }
            MapGenStructureIO.func_143031_a(ComponentVillageBakery.class, (String)"taverns:ViBak");
        }
    }

    public static void postInit(Settings config) {
        if (!postInitialized) {
            postInitialized = true;
            if (config.grimoireOfGaia2) {
                // empty if block
            }
        }
    }

    public static Object buildComponent(StructureVillagePieces.Start startPiece, List pieces, Random random, int x, int y, int z, int direction, int type) {
        StructureBoundingBox structBB = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)12, (int)14, (int)9, (int)direction);
        if (ComponentVillageBakery.func_74895_a((StructureBoundingBox)structBB) && null == StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structBB)) {
            return new ComponentVillageBakery(startPiece, type, random, structBB, direction);
        }
        return null;
    }

    public ComponentVillageBakery() {
    }

    public ComponentVillageBakery(StructureVillagePieces.Start startPiece, int type, Random rnd, StructureBoundingBox structBB, int direction) {
        super(startPiece, type, rnd, structBB, direction);
        this.carpetColor = rnd.nextInt(16);
    }

    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("Chest", this.hasMadeChest);
        par1NBTTagCompound.func_74768_a("CarpetC", this.carpetColor);
        par1NBTTagCompound.func_74757_a("VillagerSpawned", this.villagerSpawned);
    }

    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.hasMadeChest = par1NBTTagCompound.func_74767_n("Chest");
        this.carpetColor = par1NBTTagCompound.func_74762_e("CarpetC");
        this.villagerSpawned = par1NBTTagCompound.func_74767_n("VillagerSpawned");
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bb) {
        EntityVillager villager;
        int chestZ;
        int chestY;
        int chestX;
        int zz;
        int xx;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, bb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 14 - 2, 0);
        }
        BiomeGenBase biome = this.startPiece == null ? null : this.startPiece.biome;
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Blocks.field_150344_f, 0, biome);
        BiomeSpecificBlock cobble = BiomeSpecificBlock.query(Blocks.field_150347_e, 0, biome);
        BiomeSpecificBlock dirt = BiomeSpecificBlock.query(Blocks.field_150346_d, 0, biome);
        BiomeSpecificBlock grass = BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150349_c, 0, null);
        BiomeSpecificBlock gravel = BiomeSpecificBlock.query(Blocks.field_150351_n, 0, biome);
        BiomeSpecificBlock woodUp = BiomeSpecificBlock.query(Blocks.field_150364_r, 0, biome);
        BiomeSpecificBlock woodWest = this.getSpecificBlock(Blocks.field_150364_r, ForgeDirection.WEST, biome);
        BiomeSpecificBlock woodNorth = this.getSpecificBlock(Blocks.field_150364_r, ForgeDirection.NORTH, biome);
        BiomeSpecificBlock fence = BiomeSpecificBlock.query(Blocks.field_150422_aJ, 0, biome);
        BiomeSpecificBlock woodSlabDown = this.getWoodSlab(0, ForgeDirection.DOWN, biome);
        BiomeSpecificBlock woodSlabUp = this.getWoodSlab(0, ForgeDirection.UP, biome);
        BiomeSpecificBlock glassPane = BiomeSpecificBlock.query(Blocks.field_150410_aZ, 0, biome);
        BiomeSpecificBlock stoneSlabDouble = BiomeSpecificBlock.query((Block)Blocks.field_150334_T, 0, biome);
        BiomeSpecificBlock roofNorth = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.NORTH, biome);
        BiomeSpecificBlock roofSouth = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.SOUTH, biome);
        BiomeSpecificBlock cobbleChimney = BiomeSpecificBlock.queryVanilla(Blocks.field_150347_e, 0, null);
        BiomeSpecificBlock cobbleSlopeEast = BiomeSpecificBlock.queryVanilla(Blocks.field_150446_ar, Dir.getMeta(Blocks.field_150446_ar, ForgeDirection.EAST, this.field_74885_f), null);
        BiomeSpecificBlock cobbleSlopeNorth = BiomeSpecificBlock.queryVanilla(Blocks.field_150446_ar, Dir.getMeta(Blocks.field_150446_ar, ForgeDirection.NORTH, this.field_74885_f), null);
        BiomeSpecificBlock cobbleSlopeSouth = BiomeSpecificBlock.queryVanilla(Blocks.field_150446_ar, Dir.getMeta(Blocks.field_150446_ar, ForgeDirection.SOUTH, this.field_74885_f), null);
        BiomeSpecificBlock carpet = BiomeSpecificBlock.query(Blocks.field_150404_cg, this.carpetColor, biome);
        BiomeSpecificBlock smoke = BiomeSpecificBlock.queryVanilla(Blocks.field_150321_G, 0, null);
        this.fill(world, bb, 0, 0, 0, 11, 5, 6, BiomeSpecificBlock.air, BiomeSpecificBlock.air, false);
        for (xx = 0; xx < 12; ++xx) {
            for (zz = 0; zz < 7; ++zz) {
                this.func_74871_b(world, xx, 0, zz, bb);
                this.fillDownwards(world, Blocks.field_150347_e, 0, xx, -1, zz, bb);
            }
        }
        this.fill(world, bb, 0, 0, 0, 11, 0, 6, dirt, dirt);
        this.fill(world, bb, 1, 0, 0, 10, 0, 6, cobble, cobble);
        this.fill(world, bb, 2, 0, 1, 4, 0, 5, planks, planks);
        this.fill(world, bb, 5, 0, 1, 9, 0, 5, stoneSlabDouble, stoneSlabDouble);
        this.placeTorch(world, bb, 0, 3, 1, ForgeDirection.WEST);
        this.placeTorch(world, bb, 0, 3, 5, ForgeDirection.WEST);
        this.placeTorch(world, bb, 2, 3, 1, ForgeDirection.EAST);
        this.placeTorch(world, bb, 2, 3, 5, ForgeDirection.EAST);
        this.placeTorch(world, bb, 5, 3, 5, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 9, 3, 2, ForgeDirection.WEST);
        this.placeTorch(world, bb, 9, 3, 4, ForgeDirection.WEST);
        this.placeTorch(world, bb, 11, 3, 0, ForgeDirection.EAST);
        this.placeTorch(world, bb, 11, 3, 6, ForgeDirection.EAST);
        this.placeTorch(world, bb, 1, 3, -1, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 4, 3, -1, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 9, 3, -1, ForgeDirection.SOUTH);
        this.placeTorch(world, bb, 1, 3, 7, ForgeDirection.NORTH);
        this.placeTorch(world, bb, 6, 3, 7, ForgeDirection.NORTH);
        this.placeTorch(world, bb, 10, 3, 7, ForgeDirection.NORTH);
        this.placeTorch(world, bb, 9, 8, 3, ForgeDirection.WEST);
        this.fill(world, bb, 1, 1, 0, 1, 5, 6, cobble, cobble);
        this.fill(world, bb, 1, 2, 1, 1, 4, 5, planks, planks);
        this.fill(world, bb, 1, 6, 2, 1, 6, 4, cobble, cobble);
        this.fill(world, bb, 10, 1, 0, 10, 5, 6, cobble, cobble);
        this.fill(world, bb, 10, 6, 2, 10, 6, 4, cobble, cobble);
        this.fill(world, bb, 4, 1, 0, 9, 1, 0, cobble, cobble);
        this.placeBlock(world, cobble, 2, 1, 0, bb);
        this.fill(world, bb, 2, 2, 0, 9, 4, 0, planks, planks);
        this.placeAir(world, 3, 2, 0, bb);
        this.fill(world, bb, 2, 1, 6, 9, 1, 6, cobble, cobble);
        this.fill(world, bb, 2, 2, 6, 9, 4, 6, planks, planks);
        this.fill(world, bb, 1, 2, 2, 1, 2, 4, glassPane, glassPane);
        this.fill(world, bb, 5, 2, 0, 8, 2, 0, glassPane, glassPane);
        this.placeBlock(world, glassPane, 3, 2, 6, bb);
        this.placeBlock(world, glassPane, 4, 2, 6, bb);
        this.placeBlock(world, glassPane, 8, 2, 6, bb);
        for (xx = 1; xx <= 10; ++xx) {
            this.placeBlock(world, roofNorth, xx, 4, -1, bb);
            this.placeBlock(world, roofNorth, xx, 5, 0, bb);
            this.placeBlock(world, roofNorth, xx, 6, 1, bb);
            this.placeBlock(world, roofNorth, xx, 7, 2, bb);
            this.placeBlock(world, woodWest, xx, 7, 3, bb);
            this.placeBlock(world, roofSouth, xx, 7, 4, bb);
            this.placeBlock(world, roofSouth, xx, 6, 5, bb);
            this.placeBlock(world, roofSouth, xx, 5, 6, bb);
            this.placeBlock(world, roofSouth, xx, 4, 7, bb);
        }
        this.fill(world, bb, 2, 6, 2, 2, 6, 4, woodNorth, woodNorth);
        this.fill(world, bb, 9, 6, 2, 9, 6, 4, woodNorth, woodNorth);
        for (int yy = 2; yy <= 3; ++yy) {
            for (zz = 1; zz <= 5; zz += 2) {
                this.placeBlock(world, Blocks.field_150460_al, 0, 9, yy, zz, bb);
                this.setMetadata(world, Dir.getMeta(Blocks.field_150460_al, ForgeDirection.WEST, this.field_74885_f), 9, yy, zz, bb);
            }
        }
        for (int zz2 = 1; zz2 <= 5; ++zz2) {
            this.placeBlock(world, stoneSlabDouble, 9, 4, zz2, bb);
            this.placeBlock(world, cobbleSlopeEast, 9, 5, zz2, bb);
        }
        this.fill(world, bb, 10, 1, 1, 10, 5, 5, cobbleChimney, cobbleChimney);
        this.fill(world, bb, 10, 6, 2, 10, 7, 4, cobbleChimney, cobbleChimney);
        this.placeBlock(world, cobbleSlopeNorth, 10, 8, 2, bb);
        this.placeBlock(world, cobbleChimney, 10, 8, 3, bb);
        this.placeBlock(world, cobbleSlopeSouth, 10, 8, 4, bb);
        this.placeBlock(world, cobbleChimney, 10, 9, 3, bb);
        this.fill(world, bb, 3, 1, 1, 3, 1, 3, carpet, carpet);
        this.placeBlock(world, smoke, 10, 10, 3, bb);
        this.fillRandomly(world, bb, random, 0.1f, 9, 11, 2, 11, 13, 4, smoke, smoke);
        this.placeBlock(world, stoneSlabDouble, 5, 1, 3, bb);
        this.placeBlock(world, stoneSlabDouble, 5, 1, 5, bb);
        this.placeBlock(world, stoneSlabDouble, 9, 1, 1, bb);
        this.placeBlock(world, stoneSlabDouble, 9, 1, 3, bb);
        this.placeBlock(world, stoneSlabDouble, 9, 1, 5, bb);
        this.placeBlock(world, Blocks.field_150415_aT, Dir.getMeta(Blocks.field_150415_aT, ForgeDirection.NORTH, this.field_74885_f) + 8, 5, 1, 4, bb);
        this.placeBlock(world, (Block)Blocks.field_150333_U, 8, 5, 1, 1, bb);
        this.placeBlock(world, (Block)Blocks.field_150333_U, 8, 5, 1, 2, bb);
        this.placeBlock(world, Blocks.field_150462_ai, 0, 7, 1, 2, bb);
        this.placeBlock(world, Blocks.field_150462_ai, 0, 7, 1, 3, bb);
        this.placeDoor(world, bb, random, 3, 1, 0, ForgeDirection.SOUTH);
        if (!this.hasMadeChest && bb.func_78890_b(chestX = this.func_74865_a(2, 5), chestY = this.func_74862_a(1), chestZ = this.func_74873_b(2, 5))) {
            this.hasMadeChest = true;
            this.func_74879_a(world, bb, random, 2, 1, 5, ChestGenHooks.getItems((String)BAKERY_CHEST, (Random)random), ChestGenHooks.getCount((String)BAKERY_CHEST, (Random)random) + 1);
        }
        if (!this.villagerSpawned && null != (villager = this.spawnVillager(world, bb, 6, 1, 3))) {
            this.villagerSpawned = true;
            int globalX = this.func_74865_a(6, 3);
            int globalY = this.func_74862_a(1);
            int globalZ = this.func_74873_b(6, 3);
            villager.field_70714_bg.func_75776_a(4, (EntityAIBase)new GuardAI((EntityLiving)villager, new ChunkCoordinates(globalX, globalY, globalZ), 4.0f, 48.0f, new TimePeriod(0.01, 0.47), false));
        }
        return true;
    }

    protected int func_74888_b(int alreadySpawned) {
        return Taverns.config.bakerID > 0 ? Taverns.config.bakerID : super.func_74888_b(alreadySpawned);
    }
}

