/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.taverns.gen;

import de.vernideas.mc.common.ai.GuardAI;
import de.vernideas.mc.common.gen.BiomeSpecificBlock;
import de.vernideas.mc.common.util.TimePeriod;
import de.vernideas.mc.taverns.Settings;
import de.vernideas.mc.taverns.Taverns;
import de.vernideas.mc.taverns.gen.ComponentVillageBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.util.ForgeDirection;

public class ComponentVillageBarn
extends ComponentVillageBase {
    public static boolean initialized = false;
    private static final int HEIGHT = 6;
    private int averageGroundLevel = -1;
    private boolean hasExtension = false;
    private int woolColor = 0;
    private int sheepSpawned = 0;
    private boolean villagerSpawned = false;

    public static void init(Settings config) {
        if (!initialized) {
            initialized = true;
            MapGenStructureIO.func_143031_a(ComponentVillageBarn.class, (String)"taverns:ViB");
        }
    }

    public static Object buildComponent(StructureVillagePieces.Start startPiece, List pieces, Random random, int x, int y, int z, int direction, int type) {
        boolean extendedBuilding = random.nextInt(3) == 0;
        StructureBoundingBox structBB = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)(extendedBuilding ? 13 : 9), (int)6, (int)7, (int)direction);
        if (ComponentVillageBarn.func_74895_a((StructureBoundingBox)structBB) && null == StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structBB)) {
            return new ComponentVillageBarn(startPiece, type, random, structBB, direction, extendedBuilding);
        }
        return null;
    }

    public ComponentVillageBarn() {
    }

    public ComponentVillageBarn(StructureVillagePieces.Start startPiece, int type, Random rnd, StructureBoundingBox structBB, int direction, boolean extension) {
        super(startPiece, type, rnd, structBB, direction);
        this.hasExtension = extension;
        this.woolColor = rnd.nextInt(16);
        this.sheepSpawned = rnd.nextInt(2);
    }

    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("HasExtension", this.hasExtension);
        par1NBTTagCompound.func_74768_a("WoolC", this.woolColor);
        par1NBTTagCompound.func_74768_a("VSheep", this.sheepSpawned);
        par1NBTTagCompound.func_74757_a("VillagerSpawned", this.villagerSpawned);
    }

    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.hasExtension = par1NBTTagCompound.func_74767_n("HasExtension");
        this.woolColor = par1NBTTagCompound.func_74762_e("WoolC");
        this.sheepSpawned = par1NBTTagCompound.func_74762_e("VSheep");
        this.villagerSpawned = par1NBTTagCompound.func_74767_n("VillagerSpawned");
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bb) {
        int xx;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, bb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 6 - 2, 0);
        }
        int width = this.hasExtension ? 13 : 9;
        BiomeGenBase biome = this.startPiece == null ? null : this.startPiece.biome;
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Blocks.field_150344_f, 0, biome);
        BiomeSpecificBlock cobble = BiomeSpecificBlock.query(Blocks.field_150347_e, 0, biome);
        BiomeSpecificBlock dirt = BiomeSpecificBlock.query(Blocks.field_150346_d, 0, biome);
        BiomeSpecificBlock grass = BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150349_c, 0, null);
        BiomeSpecificBlock gravel = BiomeSpecificBlock.query(Blocks.field_150351_n, 0, biome);
        BiomeSpecificBlock woodUp = BiomeSpecificBlock.query(Blocks.field_150364_r, 0, biome);
        BiomeSpecificBlock fence = BiomeSpecificBlock.query(Blocks.field_150422_aJ, 0, biome);
        BiomeSpecificBlock woodSlabDown = this.getWoodSlab(0, ForgeDirection.DOWN, biome);
        BiomeSpecificBlock woodSlabUp = this.getWoodSlab(0, ForgeDirection.UP, biome);
        BiomeSpecificBlock glassPane = BiomeSpecificBlock.query(Blocks.field_150410_aZ, 0, biome);
        BiomeSpecificBlock roofEast = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.EAST, biome);
        BiomeSpecificBlock roofWest = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.WEST, biome);
        this.fill(world, bb, 0, 0, 0, width - 1, 5, 6, BiomeSpecificBlock.air, BiomeSpecificBlock.air, false);
        for (xx = 0; xx < width; ++xx) {
            for (int zz = 0; zz < 7; ++zz) {
                this.func_74871_b(world, xx, 0, zz, bb);
                this.fillDownwards(world, Blocks.field_150347_e, 0, xx, -1, zz, bb);
            }
        }
        this.fill(world, bb, 0, 0, 0, width - 1, 0, 6, dirt, dirt);
        this.fill(world, bb, 2, 0, 2, 6, 0, 4, grass, grass);
        this.fill(world, bb, 3, 0, 0, 5, 0, 0, gravel, gravel);
        this.placeTorch(world, bb, 3, 2, 1, ForgeDirection.DOWN);
        this.placeTorch(world, bb, 5, 2, 1, ForgeDirection.DOWN);
        this.placeTorch(world, bb, 0, 2, 5, ForgeDirection.WEST);
        this.placeTorch(world, bb, 8, 2, 5, ForgeDirection.EAST);
        this.placeTorch(world, bb, 1, 2, 6, ForgeDirection.NORTH);
        this.placeTorch(world, bb, 7, 2, 6, ForgeDirection.NORTH);
        this.fill(world, bb, 1, 1, 1, 7, 1, 1, fence, fence);
        this.fill(world, bb, 2, 1, 5, 6, 1, 5, fence, fence);
        this.fill(world, bb, 1, 1, 2, 1, 1, 4, fence, fence);
        this.fill(world, bb, 7, 1, 2, 7, 1, 4, fence, fence);
        this.placeBlock(world, Blocks.field_150396_be, ForgeDirection.SOUTH, 4, 1, 1, bb);
        this.placeBlock(world, woodUp, 1, 1, 5, bb);
        this.placeBlock(world, woodUp, 7, 1, 5, bb);
        this.placeBlock(world, fence, 1, 2, 1, bb);
        this.placeBlock(world, fence, 1, 3, 1, bb);
        this.placeBlock(world, fence, 7, 2, 1, bb);
        this.placeBlock(world, fence, 7, 3, 1, bb);
        this.placeBlock(world, planks, 1, 2, 5, bb);
        this.placeBlock(world, planks, 7, 2, 5, bb);
        this.placeBlock(world, woodSlabDown, 1, 4, 1, bb);
        this.placeBlock(world, Blocks.field_150325_L, 0, 2, 4, 1, bb);
        this.placeBlock(world, Blocks.field_150325_L, this.woolColor, 3, 4, 1, bb);
        this.placeBlock(world, Blocks.field_150325_L, 0, 4, 4, 1, bb);
        this.placeBlock(world, Blocks.field_150325_L, this.woolColor, 5, 4, 1, bb);
        this.placeBlock(world, Blocks.field_150325_L, 0, 6, 4, 1, bb);
        this.placeBlock(world, woodSlabDown, 7, 4, 1, bb);
        for (xx = 1; xx <= 7; ++xx) {
            this.placeBlock(world, woodSlabDown, xx, 4, 2, bb);
            this.placeBlock(world, woodSlabUp, xx, 3, 3, bb);
            this.placeBlock(world, woodSlabDown, xx, 3, 4, bb);
        }
        for (xx = 2; xx <= 6; ++xx) {
            this.placeBlock(world, woodSlabUp, xx, 2, 5, bb);
        }
        this.sheepSpawned += this.spawnEntity(world, bb, 3, 1, 3, 1 - this.sheepSpawned);
        this.sheepSpawned += this.spawnEntity(world, bb, 5, 1, 3, 2 - this.sheepSpawned);
        if (this.hasExtension) {
            EntityVillager villager;
            this.placeTorch(world, bb, 9, 4, 0, ForgeDirection.SOUTH);
            this.placeTorch(world, bb, 8, 4, 3, ForgeDirection.EAST);
            this.fill(world, bb, 7, 1, 1, 11, 1, 5, cobble, cobble);
            this.placeBlock(world, (Block)Blocks.field_150333_U, 3, 7, 1, 3, bb);
            this.placeBlock(world, Blocks.field_150446_ar, ForgeDirection.NORTH, 9, 1, 0, bb);
            this.placeBlock(world, Blocks.field_150446_ar, ForgeDirection.EAST, 8, 1, 0, bb);
            this.placeBlock(world, Blocks.field_150446_ar, ForgeDirection.WEST, 10, 1, 0, bb);
            for (int yy = 2; yy <= 4; ++yy) {
                this.placeBlock(world, woodUp, 7, yy, 1, bb);
                this.placeBlock(world, planks, 8, yy, 1, bb);
                this.placeBlock(world, planks, 10, yy, 1, bb);
                this.placeBlock(world, woodUp, 11, yy, 1, bb);
                this.placeBlock(world, woodUp, 7, yy, 5, bb);
                this.placeBlock(world, woodUp, 11, yy, 5, bb);
                this.placeBlock(world, planks, 7, yy, 2, bb);
                this.placeBlock(world, planks, 7, yy, 4, bb);
            }
            this.fill(world, bb, 8, 2, 5, 10, 4, 5, planks, planks);
            this.fill(world, bb, 11, 2, 2, 11, 4, 4, planks, planks);
            this.placeBlock(world, planks, 9, 4, 1, bb);
            this.placeBlock(world, planks, 7, 4, 3, bb);
            this.placeAir(world, 7, 3, 3, bb);
            for (xx = 8; xx <= 10; ++xx) {
                this.placeBlock(world, woodUp, xx, 5, 1, bb);
                this.placeBlock(world, woodUp, xx, 5, 5, bb);
            }
            this.placeBlock(world, glassPane, 9, 3, 5, bb);
            this.placeBlock(world, glassPane, 11, 3, 3, bb);
            this.placeDoor(world, bb, random, 9, 2, 1, ForgeDirection.SOUTH);
            for (int zz = 1; zz <= 5; ++zz) {
                this.placeBlock(world, roofEast, 7, 5, zz, bb);
                this.placeBlock(world, roofWest, 11, 5, zz, bb);
                this.placeBlock(world, woodSlabDown, 8, 6, zz, bb);
                this.placeBlock(world, planks, 9, 6, zz, bb);
                this.placeBlock(world, woodSlabDown, 10, 6, zz, bb);
            }
            if (!this.villagerSpawned && null != (villager = this.spawnVillager(world, bb, 9, 2, 3))) {
                this.villagerSpawned = true;
                int globalX = this.func_74865_a(9, 3);
                int globalY = this.func_74862_a(2);
                int globalZ = this.func_74873_b(9, 3);
                villager.field_70714_bg.func_75776_a(4, (EntityAIBase)new GuardAI((EntityLiving)villager, new ChunkCoordinates(globalX, globalY, globalZ), 5.0f, 48.0f, new TimePeriod(0.02, 0.45), false));
            }
        }
        return true;
    }

    protected int func_74888_b(int alreadySpawned) {
        return Taverns.config.shepherdessID > 0 ? Taverns.config.shepherdessID : super.func_74888_b(alreadySpawned);
    }

    @Override
    protected EntityLivingBase getEntity(World world, int index) {
        return new EntitySheep(world);
    }
}

