/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.taverns.gen;

import biomesoplenty.api.BOPBlockHelper;
import com.google.common.collect.Sets;
import de.vernideas.mc.common.gen.BiomeSpecificBlock;
import de.vernideas.mc.taverns.Taverns;
import de.vernideas.mc.taverns.direction.Dir;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ComponentVillageBase
extends StructureVillagePieces.House1 {
    protected StructureVillagePieces.Start startPiece;
    private Map<Integer, Block> biomesOPlentyStairMapping = null;
    private Map<Integer, Pair<Block, Integer>> biomesOPlentyWoodslabMapping = null;
    private Set<Block> stairBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150389_bf, Blocks.field_150446_ar, Blocks.field_150387_bl, Blocks.field_150370_cb, Blocks.field_150372_bz, Blocks.field_150390_bg, Blocks.field_150487_bG, Blocks.field_150481_bH, Blocks.field_150476_ad, Blocks.field_150485_bF, Blocks.field_150400_ck, Blocks.field_150401_cl});

    public ComponentVillageBase() {
    }

    protected ComponentVillageBase(StructureVillagePieces.Start startPiece, int type, Random rnd, StructureBoundingBox structBB, int direction) {
        super(startPiece, type, rnd, structBB, direction);
        this.field_74885_f = direction;
        this.field_74887_e = structBB;
        this.startPiece = startPiece;
    }

    protected void fill(World worldObj, StructureBoundingBox structBB, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block placeBlock, Block replaceBlock, boolean alwaysreplace) {
        this.func_151549_a(worldObj, structBB, minX, minY, minZ, maxX, maxY, maxZ, placeBlock, replaceBlock, alwaysreplace);
    }

    protected void fill(World worldObj, StructureBoundingBox structBB, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BiomeSpecificBlock placeBlock, BiomeSpecificBlock replaceBlock, boolean alwaysreplace) {
        this.func_151556_a(worldObj, structBB, minX, minY, minZ, maxX, maxY, maxZ, placeBlock.block, placeBlock.metadata, replaceBlock.block, replaceBlock.metadata, alwaysreplace);
    }

    protected void fill(World worldObj, StructureBoundingBox structBB, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block placeBlock, Block replaceBlock) {
        this.func_151549_a(worldObj, structBB, minX, minY, minZ, maxX, maxY, maxZ, placeBlock, replaceBlock, false);
    }

    protected void fill(World worldObj, StructureBoundingBox structBB, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BiomeSpecificBlock placeBlock, BiomeSpecificBlock replaceBlock) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) {
                        this.placeBlock(worldObj, replaceBlock, x, y, z, structBB);
                        continue;
                    }
                    this.placeBlock(worldObj, placeBlock, x, y, z, structBB);
                }
            }
        }
    }

    protected void fillRandomly(World world, StructureBoundingBox structBB, Random rnd, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block placeBlock, Block replaceBlock) {
        this.func_151551_a(world, structBB, rnd, chance, minX, minY, minZ, maxX, maxY, maxZ, placeBlock, replaceBlock, false);
    }

    protected void fillRandomly(World worldObj, StructureBoundingBox structBB, Random rnd, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BiomeSpecificBlock placeBlock, BiomeSpecificBlock replaceBlock) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(rnd.nextFloat() <= chance)) continue;
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) {
                        this.placeBlock(worldObj, replaceBlock, x, y, z, structBB);
                        continue;
                    }
                    this.placeBlock(worldObj, placeBlock, x, y, z, structBB);
                }
            }
        }
    }

    protected void fillDownwards(World world, Block block, int par3, int xx, int par5, int zz, StructureBoundingBox structBB) {
        this.func_151554_b(world, block, par3, xx, par5, zz, structBB);
    }

    protected void placeBlock(World world, Block block, int metadata, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        this.func_151550_a(world, block, metadata, posX, posY, posZ, structBB);
    }

    protected void placeBlock(World world, Block block, ForgeDirection dir, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        this.func_151550_a(world, block, Dir.getMeta(block, dir, this.field_74885_f), posX, posY, posZ, structBB);
    }

    protected void placeBlock(World world, BiomeSpecificBlock block, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        int globalZ;
        int globalY;
        int globalX = this.func_74865_a(posX, posZ);
        if (structBB.func_78890_b(globalX, globalY = this.func_74862_a(posY), globalZ = this.func_74873_b(posX, posZ))) {
            world.func_147465_d(globalX, globalY, globalZ, block.block, block.metadata, 2);
        }
    }

    protected void placeAir(World world, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        this.func_151550_a(world, Blocks.field_150350_a, 0, posX, posY, posZ, structBB);
    }

    protected void placeDoor(World world, StructureBoundingBox structBB, Random rnd, int posX, int posY, int posZ, ForgeDirection dir) {
        this.func_74881_a(world, structBB, rnd, posX, posY, posZ, Dir.getMeta(Blocks.field_150466_ao, dir, this.field_74885_f));
    }

    protected void placeTorch(World world, StructureBoundingBox structBB, int posX, int posY, int posZ, ForgeDirection dir) {
        this.placeBlock(world, Blocks.field_150348_b, 0, posX, posY - 1, posZ, structBB);
        this.placeBlock(world, Blocks.field_150478_aa, dir, posX, posY, posZ, structBB);
        this.placeAir(world, posX, posY - 1, posZ, structBB);
    }

    protected void setMetadata(World world, int metadata, int posX, int posY, int posZ, StructureBoundingBox structBB) {
        int globalZ;
        int globalY;
        int globalX = this.func_74865_a(posX, posZ);
        if (structBB.func_78890_b(globalX, globalY = this.func_74862_a(posY), globalZ = this.func_74873_b(posX, posZ))) {
            world.func_72921_c(globalX, globalY, globalZ, metadata, 2);
        }
    }

    protected int spawnEntity(World world, StructureBoundingBox structBB, int posX, int posY, int posZ, int amount) {
        int spawned = 0;
        for (int idx = 0; idx < amount; ++idx) {
            EntityLivingBase entity;
            int globalZ;
            int globalY;
            int globalX = this.func_74865_a(posX, posZ);
            if (!structBB.func_78890_b(globalX, globalY = this.func_74862_a(posY), globalZ = this.func_74873_b(posX, posZ)) || null == (entity = this.getEntity(world, idx))) continue;
            ++spawned;
            entity.func_70012_b((double)globalX + 0.5, (double)globalY, (double)globalZ + 0.5, 0.5f, 0.0f);
            world.func_72838_d((Entity)entity);
        }
        return spawned;
    }

    protected EntityVillager spawnVillager(World world, StructureBoundingBox structBB, int posX, int posY, int posZ) {
        return this.spawnVillager(world, structBB, posX, posY, posZ, 0);
    }

    protected EntityVillager spawnVillager(World world, StructureBoundingBox structBB, int posX, int posY, int posZ, int index) {
        int globalX = this.func_74865_a(posX, posZ);
        int globalY = this.func_74862_a(posY);
        int globalZ = this.func_74873_b(posX, posZ);
        EntityVillager entityvillager = null;
        if (structBB.func_78890_b(globalX, globalY, globalZ)) {
            entityvillager = new EntityVillager(world, this.func_74888_b(index));
            entityvillager.func_70012_b((double)globalX + 0.5, (double)globalY, (double)globalZ + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)entityvillager);
        }
        return entityvillager;
    }

    protected EntityLivingBase getEntity(World world, int index) {
        return null;
    }

    private void initBOPStairMapping() {
        if (null == this.biomesOPlentyStairMapping) {
            this.biomesOPlentyStairMapping = new HashMap<Integer, Block>(14);
            this.biomesOPlentyStairMapping.put(0, BOPBlockHelper.get((String)"sacredoakStairs"));
            this.biomesOPlentyStairMapping.put(2, BOPBlockHelper.get((String)"cherryStairs"));
            this.biomesOPlentyStairMapping.put(2, BOPBlockHelper.get((String)"darkStairs"));
            this.biomesOPlentyStairMapping.put(3, BOPBlockHelper.get((String)"firStairs"));
            this.biomesOPlentyStairMapping.put(4, BOPBlockHelper.get((String)"holyStairs"));
            this.biomesOPlentyStairMapping.put(5, BOPBlockHelper.get((String)"magicStairs"));
            this.biomesOPlentyStairMapping.put(6, BOPBlockHelper.get((String)"mangroveStairs"));
            this.biomesOPlentyStairMapping.put(7, BOPBlockHelper.get((String)"palmStairs"));
            this.biomesOPlentyStairMapping.put(8, BOPBlockHelper.get((String)"redwoodStairs"));
            this.biomesOPlentyStairMapping.put(9, BOPBlockHelper.get((String)"willowStairs"));
            this.biomesOPlentyStairMapping.put(11, BOPBlockHelper.get((String)"pineStairs"));
            this.biomesOPlentyStairMapping.put(12, BOPBlockHelper.get((String)"hellBarkStairs"));
            this.biomesOPlentyStairMapping.put(13, BOPBlockHelper.get((String)"jacarandaStairs"));
        }
    }

    private void initBOPWoodslabMapping() {
        if (null == this.biomesOPlentyWoodslabMapping) {
            this.biomesOPlentyWoodslabMapping = new HashMap<Integer, Pair<Block, Integer>>(14);
            this.biomesOPlentyWoodslabMapping.put(0, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab1"), (Object)0));
            this.biomesOPlentyWoodslabMapping.put(1, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab1"), (Object)1));
            this.biomesOPlentyWoodslabMapping.put(2, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab1"), (Object)2));
            this.biomesOPlentyWoodslabMapping.put(3, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab1"), (Object)3));
            this.biomesOPlentyWoodslabMapping.put(4, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab1"), (Object)4));
            this.biomesOPlentyWoodslabMapping.put(5, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab1"), (Object)5));
            this.biomesOPlentyWoodslabMapping.put(6, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab1"), (Object)6));
            this.biomesOPlentyWoodslabMapping.put(7, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab1"), (Object)7));
            this.biomesOPlentyWoodslabMapping.put(8, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab2"), (Object)0));
            this.biomesOPlentyWoodslabMapping.put(9, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab2"), (Object)1));
            this.biomesOPlentyWoodslabMapping.put(11, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab2"), (Object)2));
            this.biomesOPlentyWoodslabMapping.put(12, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab2"), (Object)3));
            this.biomesOPlentyWoodslabMapping.put(13, (Pair<Block, Integer>)ImmutablePair.of((Object)BOPBlockHelper.get((String)"woodenSingleSlab2"), (Object)4));
        }
    }

    public BiomeSpecificBlock getSpecificBlock(Block block, ForgeDirection dir, BiomeGenBase biome) {
        return BiomeSpecificBlock.query(block, Dir.getMeta(block, dir, this.field_74885_f), biome);
    }

    public BiomeSpecificBlock getStairs(Block wood, ForgeDirection dir, BiomeGenBase biome) {
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Blocks.field_150344_f, 0, biome);
        if (Taverns.config.biomesOPlenty && Taverns.config.useBOPBlocks) {
            Block bopStairBlock;
            this.initBOPStairMapping();
            if (planks.block == BOPBlockHelper.get((String)"planks") && null != (bopStairBlock = this.biomesOPlentyStairMapping.get(planks.metadata))) {
                return BiomeSpecificBlock.queryVanilla(bopStairBlock, Dir.getMeta(Blocks.field_150476_ad, dir, this.field_74885_f), null);
            }
        }
        BiomeSpecificBlock stairs = BiomeSpecificBlock.query(wood, Dir.getMeta(Blocks.field_150476_ad, dir, this.field_74885_f), biome);
        if (!this.stairBlocks.contains(stairs.block)) {
            Block replacementStairBlock = null;
            if (planks.block == Blocks.field_150344_f) {
                switch (planks.metadata) {
                    case 0: {
                        replacementStairBlock = Blocks.field_150476_ad;
                        break;
                    }
                    case 1: {
                        replacementStairBlock = Blocks.field_150485_bF;
                        break;
                    }
                    case 2: {
                        replacementStairBlock = Blocks.field_150487_bG;
                        break;
                    }
                    case 3: {
                        replacementStairBlock = Blocks.field_150481_bH;
                        break;
                    }
                    case 4: {
                        replacementStairBlock = Blocks.field_150400_ck;
                        break;
                    }
                    case 5: {
                        replacementStairBlock = Blocks.field_150401_cl;
                    }
                }
            }
            if (planks.block == Blocks.field_150336_V) {
                replacementStairBlock = Blocks.field_150389_bf;
            }
            if (planks.block == Blocks.field_150347_e || planks.block == Blocks.field_150341_Y) {
                replacementStairBlock = Blocks.field_150446_ar;
            }
            if (planks.block == Blocks.field_150385_bj || planks.block == Blocks.field_150424_aL) {
                replacementStairBlock = Blocks.field_150387_bl;
            }
            if (planks.block == Blocks.field_150371_ca) {
                replacementStairBlock = Blocks.field_150370_cb;
            }
            if (planks.block == Blocks.field_150322_A) {
                replacementStairBlock = Blocks.field_150372_bz;
            }
            if (planks.block == Blocks.field_150417_aV || planks.block == Blocks.field_150348_b) {
                replacementStairBlock = Blocks.field_150390_bg;
            }
            if (null != replacementStairBlock) {
                return BiomeSpecificBlock.queryVanilla(replacementStairBlock, Dir.getMeta(Blocks.field_150476_ad, dir, this.field_74885_f), null);
            }
        }
        return stairs;
    }

    public BiomeSpecificBlock getBench(Block wood, ForgeDirection dir, BiomeGenBase biome) {
        return this.getStairs(wood, dir, biome);
    }

    public BiomeSpecificBlock getWoodSlab(int plankMeta, ForgeDirection dir, BiomeGenBase biome) {
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Blocks.field_150344_f, plankMeta, biome);
        if (Taverns.config.biomesOPlenty && Taverns.config.useBOPBlocks) {
            Pair<Block, Integer> bopPlankBlock;
            this.initBOPWoodslabMapping();
            if (planks.block == BOPBlockHelper.get((String)"planks") && null != (bopPlankBlock = this.biomesOPlentyWoodslabMapping.get(planks.metadata)) && null != bopPlankBlock.getLeft()) {
                return BiomeSpecificBlock.queryVanilla((Block)bopPlankBlock.getLeft(), (Integer)bopPlankBlock.getRight() + (dir == ForgeDirection.UP ? 8 : 0), null);
            }
        }
        BiomeSpecificBlock slab = BiomeSpecificBlock.query((Block)Blocks.field_150376_bx, plankMeta + (dir == ForgeDirection.UP ? 8 : 0), biome);
        if (slab.block == Blocks.field_150333_U) {
            if (planks.block == Blocks.field_150344_f) {
                return BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150376_bx, planks.metadata + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Blocks.field_150348_b) {
                return BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150333_U, 0 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Blocks.field_150322_A) {
                return BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150333_U, 1 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Blocks.field_150347_e || planks.block == Blocks.field_150341_Y) {
                return BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150333_U, 3 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Blocks.field_150336_V) {
                return BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150333_U, 4 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Blocks.field_150417_aV) {
                return BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150333_U, 5 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Blocks.field_150385_bj || planks.block == Blocks.field_150424_aL) {
                return BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150333_U, 6 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
            if (planks.block == Blocks.field_150371_ca) {
                return BiomeSpecificBlock.queryVanilla((Block)Blocks.field_150333_U, 7 + (dir == ForgeDirection.UP ? 8 : 0), biome);
            }
        }
        return slab;
    }

    public BiomeSpecificBlock getMossyCobble(BiomeGenBase biome) {
        if (Taverns.config.biomesOPlenty && Taverns.config.useBOPBlocks) {
            BiomeSpecificBlock cobble = BiomeSpecificBlock.query(Blocks.field_150347_e, 0, biome);
            if (cobble.block == BOPBlockHelper.get((String)"logs1") || cobble.block == BOPBlockHelper.get((String)"logs2") || cobble.block == BOPBlockHelper.get((String)"logs3") || cobble.block == BOPBlockHelper.get((String)"logs4")) {
                return BiomeSpecificBlock.queryVanilla(BOPBlockHelper.get((String)"logs3"), 2, null);
            }
        }
        return BiomeSpecificBlock.query(Blocks.field_150341_Y, 0, biome);
    }
}

