/*
 * Decompiled with CFR 0.152.
 */
package de.vernideas.mc.taverns.gen;

import de.vernideas.mc.common.ai.GuardAI;
import de.vernideas.mc.common.gen.BiomeSpecificBlock;
import de.vernideas.mc.common.util.TimePeriod;
import de.vernideas.mc.taverns.Settings;
import de.vernideas.mc.taverns.Taverns;
import de.vernideas.mc.taverns.direction.Dir;
import de.vernideas.mc.taverns.gen.ComponentVillageBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ComponentVillageTavern
extends ComponentVillageBase {
    public static final String TAVERN_CHEST = "taverns:tavernChest";
    public static final WeightedRandomChestContent[] tavernChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 3, 1), new WeightedRandomChestContent(Items.field_151042_j, 0, 1, 5, 10), new WeightedRandomChestContent(Items.field_151104_aV, 0, 1, 3, 30), new WeightedRandomChestContent(Items.field_151025_P, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151034_e, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151035_b, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151040_l, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151030_Z, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151028_Y, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151165_aa, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151167_ab, 0, 1, 1, 5), new WeightedRandomChestContent(new ItemStack(Blocks.field_150343_Z), 1, 7, 5), new WeightedRandomChestContent(new ItemStack(Blocks.field_150345_g), 3, 7, 5)};
    public static boolean initialized = false;
    public static boolean postInitialized = false;
    private static final int HEIGHT = 10;
    private int averageGroundLevel = -1;
    private boolean hasMadeChest;
    private int carpetColor;
    private int flower;
    private boolean villagerSpawned = false;

    public static void init(Settings config) {
        if (!initialized) {
            initialized = true;
            ChestGenHooks.getInfo((String)TAVERN_CHEST).setMin(1);
            ChestGenHooks.getInfo((String)TAVERN_CHEST).setMax(10);
            for (int i = 0; i < tavernChestContents.length; ++i) {
                ChestGenHooks.addItem((String)TAVERN_CHEST, (WeightedRandomChestContent)tavernChestContents[i]);
            }
            MapGenStructureIO.func_143031_a(ComponentVillageTavern.class, (String)"taverns:ViT");
        }
    }

    public static void postInit(Settings config) {
        if (!postInitialized) {
            postInitialized = true;
            if (config.grimoireOfGaia2) {
                // empty if block
            }
        }
    }

    public static Object buildComponent(StructureVillagePieces.Start startPiece, List pieces, Random random, int x, int y, int z, int direction, int type) {
        StructureBoundingBox structBB = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)14, (int)10, (int)8, (int)direction);
        if (ComponentVillageTavern.func_74895_a((StructureBoundingBox)structBB) && null == StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structBB)) {
            return new ComponentVillageTavern(startPiece, type, random, structBB, direction);
        }
        return null;
    }

    public ComponentVillageTavern() {
    }

    public ComponentVillageTavern(StructureVillagePieces.Start startPiece, int type, Random rnd, StructureBoundingBox structBB, int direction) {
        super(startPiece, type, rnd, structBB, direction);
        this.carpetColor = rnd.nextInt(16);
        this.flower = rnd.nextInt(16) - 4;
    }

    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("Chest", this.hasMadeChest);
        par1NBTTagCompound.func_74768_a("CarpetC", this.carpetColor);
        par1NBTTagCompound.func_74768_a("Flower", this.flower);
        par1NBTTagCompound.func_74757_a("VillagerSpawned", this.villagerSpawned);
    }

    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.hasMadeChest = par1NBTTagCompound.func_74767_n("Chest");
        this.carpetColor = par1NBTTagCompound.func_74762_e("CarpetC");
        this.flower = par1NBTTagCompound.func_74762_e("Flower");
        this.villagerSpawned = par1NBTTagCompound.func_74767_n("VillagerSpawned");
    }

    public boolean func_74875_a(World world, Random rnd, StructureBoundingBox bb) {
        EntityVillager villager;
        int chestZ;
        int chestY;
        int chestX;
        int zz;
        int xx;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, bb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 10 - 2, 0);
        }
        BiomeGenBase biome = this.startPiece == null ? null : this.startPiece.biome;
        BiomeSpecificBlock planks = BiomeSpecificBlock.query(Blocks.field_150344_f, 0, biome);
        BiomeSpecificBlock cobble = BiomeSpecificBlock.query(Blocks.field_150347_e, 0, biome);
        BiomeSpecificBlock dirt = BiomeSpecificBlock.query(Blocks.field_150346_d, 0, biome);
        BiomeSpecificBlock gravel = BiomeSpecificBlock.query(Blocks.field_150351_n, 0, biome);
        BiomeSpecificBlock woodUp = BiomeSpecificBlock.query(Blocks.field_150364_r, 0, biome);
        BiomeSpecificBlock woodWest = this.getSpecificBlock(Blocks.field_150364_r, ForgeDirection.WEST, biome);
        BiomeSpecificBlock glassPane = BiomeSpecificBlock.query(Blocks.field_150410_aZ, 0, biome);
        BiomeSpecificBlock fence = BiomeSpecificBlock.query(Blocks.field_150422_aJ, 0, biome);
        BiomeSpecificBlock carpet = BiomeSpecificBlock.query(Blocks.field_150404_cg, this.carpetColor, biome);
        BiomeSpecificBlock roofNorth = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.NORTH, biome);
        BiomeSpecificBlock roofSouth = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.SOUTH, biome);
        BiomeSpecificBlock roofWest = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.WEST, biome);
        BiomeSpecificBlock roofEast = this.getSpecificBlock(Blocks.field_150476_ad, ForgeDirection.EAST, biome);
        BiomeSpecificBlock stairsEast = this.getStairs(Blocks.field_150476_ad, ForgeDirection.EAST, biome);
        BiomeSpecificBlock benchWest = this.getBench(Blocks.field_150476_ad, ForgeDirection.WEST, biome);
        BiomeSpecificBlock benchEast = this.getBench(Blocks.field_150476_ad, ForgeDirection.EAST, biome);
        BiomeSpecificBlock darkBenchNorth = this.getBench(Blocks.field_150485_bF, ForgeDirection.NORTH, biome);
        BiomeSpecificBlock darkBenchEast = this.getBench(Blocks.field_150485_bF, ForgeDirection.EAST, biome);
        this.fill(world, bb, 0, 0, 0, 14, 9, 7, BiomeSpecificBlock.air, BiomeSpecificBlock.air);
        for (xx = 0; xx < 14; ++xx) {
            for (int zz2 = 0; zz2 < 8; ++zz2) {
                this.func_74871_b(world, xx, 0, zz2, bb);
                this.fillDownwards(world, Blocks.field_150347_e, 0, xx, -1, zz2, bb);
            }
        }
        this.fill(world, bb, 0, 0, 1, 14, 0, 7, dirt, dirt);
        this.fill(world, bb, 0, 0, 0, 14, 0, 0, gravel, gravel);
        this.fill(world, bb, 1, 0, 1, 4, 0, 6, cobble, cobble);
        this.fill(world, bb, 5, 0, 1, 12, 0, 6, planks, planks);
        this.fill(world, bb, 1, 4, 1, 12, 4, 6, planks, planks);
        this.fill(world, bb, 7, 8, 1, 12, 8, 6, planks, planks);
        this.fill(world, bb, 1, 1, 1, 1, 4, 1, woodUp, woodUp);
        this.fill(world, bb, 1, 1, 2, 1, 3, 5, cobble, cobble);
        this.fill(world, bb, 1, 1, 6, 1, 4, 6, woodUp, woodUp);
        this.fill(world, bb, 2, 3, 1, 3, 3, 1, planks, planks);
        this.fill(world, bb, 2, 1, 1, 3, 1, 1, cobble, cobble);
        this.fill(world, bb, 2, 2, 1, 3, 2, 1, glassPane, glassPane);
        this.fill(world, bb, 4, 1, 1, 4, 3, 1, woodUp, woodUp);
        this.fill(world, bb, 5, 3, 1, 6, 3, 1, woodUp, woodUp);
        this.fill(world, bb, 7, 1, 1, 7, 7, 1, woodUp, woodUp);
        this.placeBlock(world, woodWest, 4, 3, 1, bb);
        this.placeBlock(world, woodWest, 7, 3, 1, bb);
        this.fill(world, bb, 8, 1, 1, 11, 1, 1, cobble, cobble);
        this.fill(world, bb, 8, 2, 1, 11, 7, 1, planks, planks);
        this.fill(world, bb, 8, 2, 1, 11, 2, 1, glassPane, glassPane);
        this.fill(world, bb, 12, 1, 1, 12, 7, 1, woodUp, woodUp);
        this.fill(world, bb, 12, 1, 2, 12, 1, 5, cobble, cobble);
        this.fill(world, bb, 12, 2, 2, 12, 7, 5, planks, planks);
        this.fill(world, bb, 12, 2, 3, 12, 2, 4, glassPane, glassPane);
        this.fill(world, bb, 12, 6, 3, 12, 6, 4, glassPane, glassPane);
        this.fill(world, bb, 12, 1, 6, 12, 7, 6, woodUp, woodUp);
        this.fill(world, bb, 7, 1, 6, 11, 1, 6, cobble, cobble);
        this.fill(world, bb, 7, 2, 6, 11, 7, 6, planks, planks);
        this.placeBlock(world, glassPane, 10, 6, 6, bb);
        this.fill(world, bb, 6, 1, 6, 6, 8, 6, woodUp, woodUp);
        this.placeBlock(world, woodUp, 5, 3, 6, bb);
        this.fill(world, bb, 4, 1, 6, 4, 3, 6, woodUp, woodUp);
        this.fill(world, bb, 2, 1, 6, 3, 3, 6, cobble, cobble);
        this.fill(world, bb, 7, 5, 2, 7, 7, 5, planks, planks);
        this.fill(world, bb, 6, 5, 5, 6, 8, 5, planks, planks);
        for (xx = 0; xx <= 13; ++xx) {
            this.placeBlock(world, roofNorth, xx, 4, 0, bb);
            this.placeBlock(world, roofSouth, xx, 4, 7, bb);
        }
        for (zz = 0; zz <= 7; ++zz) {
            this.placeBlock(world, roofEast, 0, 4, zz, bb);
            this.placeBlock(world, roofWest, 13, 4, zz, bb);
        }
        for (xx = 6; xx <= 13; ++xx) {
            this.placeBlock(world, roofNorth, xx, 7, 0, bb);
            this.placeBlock(world, roofSouth, xx, 7, 7, bb);
            this.placeBlock(world, roofNorth, xx, 8, 1, bb);
            this.placeBlock(world, roofSouth, xx, 8, 6, bb);
        }
        for (xx = 7; xx <= 13; ++xx) {
            this.placeBlock(world, roofNorth, xx, 9, 2, bb);
            this.placeBlock(world, roofSouth, xx, 9, 5, bb);
        }
        for (zz = 2; zz <= 5; ++zz) {
            this.placeBlock(world, roofEast, 6, 8, zz, bb);
        }
        for (zz = 3; zz <= 4; ++zz) {
            this.placeBlock(world, roofWest, 13, 9, zz, bb);
            this.placeBlock(world, roofEast, 12, 9, zz, bb);
            this.placeBlock(world, roofEast, 7, 9, zz, bb);
            this.placeBlock(world, roofWest, 8, 9, zz, bb);
        }
        for (zz = 5; zz <= 7; ++zz) {
            this.placeBlock(world, roofEast, 5, 7, zz, bb);
        }
        this.func_74878_a(world, bb, 6, 8, 4, 6, 8, 4);
        this.fill(world, bb, 1, 5, 6, 5, 5, 6, fence, fence);
        this.fill(world, bb, 1, 5, 1, 1, 5, 5, fence, fence);
        this.fill(world, bb, 2, 5, 1, 6, 5, 1, fence, fence);
        for (int yy = 5; yy <= 8; ++yy) {
            this.placeBlock(world, Blocks.field_150468_ap, ForgeDirection.WEST, 6, yy, 4, bb);
        }
        this.placeBlock(world, Blocks.field_150342_X, 0, 11, 5, 2, bb);
        this.placeBlock(world, Blocks.field_150478_aa, 0, 11, 6, 2, bb);
        this.placeBlock(world, Blocks.field_150324_C, ForgeDirection.SOUTH, 10, 5, 3, bb);
        this.placeBlock(world, Blocks.field_150324_C, Dir.getMeta(Blocks.field_150324_C, ForgeDirection.SOUTH, this.field_74885_f) + 8, 10, 5, 2, bb);
        if (!this.hasMadeChest && bb.func_78890_b(chestX = this.func_74865_a(9, 2), chestY = this.func_74862_a(5), chestZ = this.func_74873_b(9, 2))) {
            this.hasMadeChest = true;
            this.func_74879_a(world, bb, rnd, 9, 5, 2, ChestGenHooks.getItems((String)TAVERN_CHEST, (Random)rnd), ChestGenHooks.getCount((String)TAVERN_CHEST, (Random)rnd));
        }
        this.placeDoor(world, bb, rnd, 7, 5, 2, ForgeDirection.WEST);
        this.placeDoor(world, bb, rnd, 6, 1, 1, ForgeDirection.SOUTH);
        this.placeDoor(world, bb, rnd, 5, 1, 1, ForgeDirection.SOUTH);
        this.placeDoor(world, bb, rnd, 5, 1, 6, ForgeDirection.NORTH);
        this.fill(world, bb, 4, 1, 5, 4, 3, 5, woodUp, woodUp);
        this.fill(world, bb, 7, 1, 2, 7, 3, 2, woodUp, woodUp);
        this.placeBlock(world, stairsEast, 7, 1, 5, bb);
        this.placeBlock(world, stairsEast, 8, 2, 5, bb);
        this.placeBlock(world, stairsEast, 9, 3, 5, bb);
        this.placeBlock(world, stairsEast, 10, 4, 5, bb);
        this.func_74878_a(world, bb, 7, 4, 5, 9, 4, 5);
        this.placeBlock(world, planks, 8, 1, 5, bb);
        this.placeBlock(world, darkBenchNorth, 9, 1, 5, bb);
        this.placeBlock(world, darkBenchNorth, 10, 1, 5, bb);
        this.placeBlock(world, darkBenchNorth, 11, 1, 5, bb);
        this.placeBlock(world, darkBenchEast, 11, 1, 4, bb);
        this.placeBlock(world, darkBenchEast, 11, 1, 3, bb);
        this.placeBlock(world, planks, 11, 1, 2, bb);
        this.placeBlock(world, benchEast, 10, 1, 2, bb);
        this.placeBlock(world, fence, 9, 1, 2, bb);
        this.placeBlock(world, Blocks.field_150452_aw, 0, 9, 2, 2, bb);
        this.placeBlock(world, benchWest, 8, 1, 2, bb);
        this.fill(world, bb, 4, 1, 2, 4, 1, 3, planks, planks);
        this.fill(world, bb, 2, 1, 2, 2, 1, 3, planks, planks);
        this.placeBlock(world, Blocks.field_150382_bo, 0, 2, 2, 3, bb);
        this.placeBlock(world, (Block)Blocks.field_150383_bp, rnd.nextInt(3) + 1, 3, 1, 5, bb);
        this.placeBlock(world, Blocks.field_150415_aT, ForgeDirection.NORTH, 4, 2, 4, bb);
        this.placeBlock(world, Blocks.field_150460_al, 0, 2, 1, 5, bb);
        this.setMetadata(world, Dir.getMeta(Blocks.field_150460_al, ForgeDirection.SOUTH, this.field_74885_f), 2, 1, 5, bb);
        this.fill(world, bb, 8, 1, 3, 10, 1, 4, carpet, carpet);
        if (this.flower >= 0) {
            this.placeBlock(world, Blocks.field_150457_bL, this.flower, 6, 6, 1, bb);
        }
        this.placeBlock(world, Blocks.field_150478_aa, 0, 1, 6, 6, bb);
        this.placeBlock(world, Blocks.field_150478_aa, 0, 1, 6, 1, bb);
        this.placeBlock(world, Blocks.field_150478_aa, 0, 9, 9, 4, bb);
        this.placeBlock(world, Blocks.field_150478_aa, 0, 4, 3, 0, bb);
        this.placeBlock(world, Blocks.field_150478_aa, 0, 7, 3, 0, bb);
        this.placeBlock(world, Blocks.field_150478_aa, 0, 5, 3, 7, bb);
        this.placeBlock(world, Blocks.field_150478_aa, 0, 2, 3, 5, bb);
        this.placeBlock(world, Blocks.field_150348_b, 0, 4, 2, 2, bb);
        this.placeBlock(world, Blocks.field_150478_aa, ForgeDirection.NORTH, 4, 3, 2, bb);
        this.placeAir(world, 4, 2, 2, bb);
        this.placeBlock(world, Blocks.field_150348_b, 0, 9, 2, 2, bb);
        this.placeBlock(world, Blocks.field_150478_aa, ForgeDirection.NORTH, 9, 3, 2, bb);
        this.placeBlock(world, Blocks.field_150452_aw, 0, 9, 2, 2, bb);
        if (!this.villagerSpawned && null != (villager = this.spawnVillager(world, bb, 2, 1, 2))) {
            this.villagerSpawned = true;
            int globalX = this.func_74865_a(2, 2);
            int globalY = this.func_74862_a(1);
            int globalZ = this.func_74873_b(2, 2);
            villager.field_70714_bg.func_75776_a(4, (EntityAIBase)new GuardAI((EntityLiving)villager, new ChunkCoordinates(globalX, globalY, globalZ), 1.0f, 48.0f, new TimePeriod(0.15, 0.75), false));
        }
        return true;
    }

    protected int func_74888_b(int alreadySpawned) {
        return Taverns.config.barWenchID > 0 ? Taverns.config.barWenchID : super.func_74888_b(alreadySpawned);
    }
}

