/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.wallpaper;

import cpw.mods.fml.client.FMLClientHandler;
import grim3212.mc.wallpaper.EntityWallpaper;
import grim3212.mc.wallpaper.Wallpaper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderWallpaper
extends Render {
    private static final ResourceLocation wallpaperTexture = new ResourceLocation("wallpaper", "textures/wallpaper/wallpapers.png");
    public float colorRedTopLeft;
    public float colorRedBottomLeft;
    public float colorRedBottomRight;
    public float colorRedTopRight;
    public float colorGreenTopLeft;
    public float colorGreenBottomLeft;
    public float colorGreenBottomRight;
    public float colorGreenTopRight;
    public float colorBlueTopLeft;
    public float colorBlueBottomLeft;
    public float colorBlueBottomRight;
    public float colorBlueTopRight;
    public int brightnessTopLeft;
    public int brightnessTopRight;
    public int brightnessBottomLeft;
    public int brightnessBottomRight;

    public void initWallpaper(EntityWallpaper entitywallpaper, double x, double y, double z, float angle) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)2896);
        this.func_110777_b(entitywallpaper);
        this.renderWallpaper(entitywallpaper);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void renderWallpaper(EntityWallpaper entitywallpaper) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glScalef((float)0.03125f, (float)0.03125f, (float)0.03125f);
        int x = MathHelper.func_76128_c((double)entitywallpaper.field_70165_t);
        int y = MathHelper.func_76128_c((double)entitywallpaper.field_70163_u);
        int z = MathHelper.func_76128_c((double)entitywallpaper.field_70161_v);
        float minX = -16.0f;
        float minY = -16.0f;
        float minZ = 0.0f;
        float maxX = 16.0f;
        float maxY = 16.0f;
        float maxZ = Wallpaper.widthWallpaper;
        float minU = (float)(entitywallpaper.wallpaper / 16) / 16.0f;
        float minV = (float)(entitywallpaper.wallpaper % 16) / 16.0f;
        float maxUV = 0.0625f;
        float sideUV = 0.00195313f;
        float red = (float)entitywallpaper.red / 256.0f;
        float green = (float)entitywallpaper.green / 256.0f;
        float blue = (float)entitywallpaper.blue / 256.0f;
        tessellator.func_78382_b();
        if (Minecraft.func_71379_u()) {
            this.renderWithAmbientOcclusion(x, y, z, red, green, blue, entitywallpaper.direction);
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            if (entitywallpaper.direction == 0) {
                tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                tessellator.func_78380_c(this.brightnessTopRight);
                tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
                tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                tessellator.func_78380_c(this.brightnessTopLeft);
                tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                tessellator.func_78380_c(this.brightnessBottomLeft);
                tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                tessellator.func_78380_c(this.brightnessBottomRight);
                tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
            } else if (entitywallpaper.direction == 2) {
                tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                tessellator.func_78380_c(this.brightnessBottomRight);
                tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
                tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                tessellator.func_78380_c(this.brightnessTopRight);
                tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                tessellator.func_78380_c(this.brightnessTopLeft);
                tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                tessellator.func_78380_c(this.brightnessBottomLeft);
                tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
            } else if (entitywallpaper.direction == 1) {
                tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                tessellator.func_78380_c(this.brightnessTopRight);
                tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
                tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                tessellator.func_78380_c(this.brightnessTopLeft);
                tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                tessellator.func_78380_c(this.brightnessBottomLeft);
                tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                tessellator.func_78380_c(this.brightnessBottomRight);
                tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
            } else if (entitywallpaper.direction == 3) {
                tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                tessellator.func_78380_c(this.brightnessBottomLeft);
                tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
                tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                tessellator.func_78380_c(this.brightnessBottomRight);
                tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                tessellator.func_78380_c(this.brightnessTopRight);
                tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                tessellator.func_78380_c(this.brightnessTopLeft);
                tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
            }
            if (!entitywallpaper.isBlockLeft) {
                tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                if (entitywallpaper.direction == 0) {
                    tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                    tessellator.func_78380_c(this.brightnessTopLeft);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                    tessellator.func_78380_c(this.brightnessTopRight);
                    tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                    tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                } else if (entitywallpaper.direction == 2) {
                    tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                    tessellator.func_78380_c(this.brightnessTopRight);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                    tessellator.func_78380_c(this.brightnessBottomRight);
                    tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                    tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                } else if (entitywallpaper.direction == 1) {
                    tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                    tessellator.func_78380_c(this.brightnessTopLeft);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                    tessellator.func_78380_c(this.brightnessTopRight);
                    tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                    tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                } else if (entitywallpaper.direction == 3) {
                    tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                    tessellator.func_78380_c(this.brightnessBottomRight);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                    tessellator.func_78380_c(this.brightnessBottomLeft);
                    tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                    tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                }
            }
            if (!entitywallpaper.isBlockUp) {
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                if (entitywallpaper.direction == 0) {
                    tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                    tessellator.func_78380_c(this.brightnessTopLeft);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)(minV + sideUV));
                    tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                    tessellator.func_78380_c(this.brightnessBottomLeft);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)minU, (double)(minV + sideUV));
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                } else if (entitywallpaper.direction == 2) {
                    tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                    tessellator.func_78380_c(this.brightnessTopLeft);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)minU, (double)(minV + sideUV));
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                    tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                    tessellator.func_78380_c(this.brightnessTopRight);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)(minV + sideUV));
                } else if (entitywallpaper.direction == 1) {
                    tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                    tessellator.func_78380_c(this.brightnessBottomLeft);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)minU, (double)(minV + sideUV));
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                    tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                    tessellator.func_78380_c(this.brightnessTopLeft);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)(minV + sideUV));
                } else if (entitywallpaper.direction == 3) {
                    tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                    tessellator.func_78380_c(this.brightnessTopRight);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)minU, (double)(minV + sideUV));
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                    tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                    tessellator.func_78380_c(this.brightnessBottomRight);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                    tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)(minV + sideUV));
                }
            }
            if (!entitywallpaper.isBlockRight) {
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                if (entitywallpaper.direction == 0) {
                    tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                    tessellator.func_78380_c(this.brightnessBottomRight);
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)(minU + sideUV), (double)(minV + maxUV));
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                    tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                    tessellator.func_78380_c(this.brightnessBottomLeft);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)(minU + sideUV), (double)minV);
                } else if (entitywallpaper.direction == 2) {
                    tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                    tessellator.func_78380_c(this.brightnessBottomLeft);
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)(minU + sideUV), (double)(minV + maxUV));
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                    tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                    tessellator.func_78380_c(this.brightnessTopLeft);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)(minU + sideUV), (double)minV);
                } else if (entitywallpaper.direction == 1) {
                    tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                    tessellator.func_78380_c(this.brightnessBottomRight);
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)(minU + sideUV), (double)(minV + maxUV));
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                    tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                    tessellator.func_78380_c(this.brightnessBottomLeft);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)(minU + sideUV), (double)minV);
                } else if (entitywallpaper.direction == 3) {
                    tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                    tessellator.func_78380_c(this.brightnessTopLeft);
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)(minU + sideUV), (double)(minV + maxUV));
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                    tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                    tessellator.func_78380_c(this.brightnessTopRight);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                    tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)(minU + sideUV), (double)minV);
                }
            }
            if (!entitywallpaper.isBlockDown) {
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                if (entitywallpaper.direction == 0) {
                    tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                    tessellator.func_78380_c(this.brightnessTopRight);
                    tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV), (double)(minV + maxUV - sideUV));
                    tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
                    tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                    tessellator.func_78380_c(this.brightnessBottomRight);
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)minU, (double)(minV + maxUV - sideUV));
                } else if (entitywallpaper.direction == 2) {
                    tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                    tessellator.func_78380_c(this.brightnessBottomRight);
                    tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV), (double)(minV + maxUV - sideUV));
                    tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
                    tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                    tessellator.func_78380_c(this.brightnessBottomLeft);
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)minU, (double)(minV + maxUV - sideUV));
                } else if (entitywallpaper.direction == 1) {
                    tessellator.func_78386_a(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
                    tessellator.func_78380_c(this.brightnessTopRight);
                    tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV), (double)(minV + maxUV - sideUV));
                    tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
                    tessellator.func_78386_a(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
                    tessellator.func_78380_c(this.brightnessBottomRight);
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)minU, (double)(minV + maxUV - sideUV));
                } else if (entitywallpaper.direction == 3) {
                    tessellator.func_78386_a(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
                    tessellator.func_78380_c(this.brightnessBottomLeft);
                    tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV), (double)(minV + maxUV - sideUV));
                    tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
                    tessellator.func_78386_a(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
                    tessellator.func_78380_c(this.brightnessTopLeft);
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                    tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)minU, (double)(minV + maxUV - sideUV));
                }
            }
        } else {
            float blockLight = this.field_76990_c.field_78722_g.func_72801_o(x, y, z);
            GL11.glColor3f((float)(blockLight * red), (float)(blockLight * green), (float)(blockLight * blue));
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            tessellator.func_78380_c(this.getMixedBrightnessForBlock(x, y, z));
            tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
            tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
            tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
            tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
            if (!entitywallpaper.isBlockLeft) {
                tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV - sideUV), (double)(minV + maxUV));
                tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)minV);
            }
            if (!entitywallpaper.isBlockUp) {
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                tessellator.func_78374_a((double)minX, (double)maxY, (double)minZ, (double)(minU + maxUV), (double)minV);
                tessellator.func_78374_a((double)minX, (double)maxY, (double)maxZ, (double)(minU + maxUV), (double)(minV + sideUV));
                tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)minU, (double)(minV + sideUV));
            }
            if (!entitywallpaper.isBlockRight) {
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                tessellator.func_78374_a((double)maxX, (double)maxY, (double)minZ, (double)minU, (double)minV);
                tessellator.func_78374_a((double)maxX, (double)maxY, (double)maxZ, (double)(minU + sideUV), (double)minV);
                tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)(minU + sideUV), (double)(minV + maxUV));
            }
            if (!entitywallpaper.isBlockDown) {
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                tessellator.func_78374_a((double)minX, (double)minY, (double)minZ, (double)(minU + maxUV), (double)(minV + maxUV));
                tessellator.func_78374_a((double)maxX, (double)minY, (double)minZ, (double)minU, (double)(minV + maxUV));
                tessellator.func_78374_a((double)maxX, (double)minY, (double)maxZ, (double)minU, (double)(minV + maxUV - sideUV));
                tessellator.func_78374_a((double)minX, (double)minY, (double)maxZ, (double)(minU + maxUV), (double)(minV + maxUV - sideUV));
            }
        }
        tessellator.func_78381_a();
    }

    public boolean renderWithAmbientOcclusion(int x, int y, int z, float red, float green, float blue, int direction) {
        float lightSelf = this.getAmbientOcclusionLightValue(x, y, z);
        int brightnessSelf = this.getMixedBrightnessForBlock(x, y, z);
        if (direction == 0) {
            float lightValueXZNN = this.getAmbientOcclusionLightValue(x - 1, y, z);
            float lightValueYZNN = this.getAmbientOcclusionLightValue(x, y - 1, z);
            float lightValueYZPN = this.getAmbientOcclusionLightValue(x, y + 1, z);
            float lightValueXZPN = this.getAmbientOcclusionLightValue(x + 1, y, z);
            float lightValueXYZNNN = this.getAmbientOcclusionLightValue(x - 1, y - 1, z);
            float lightValueXYZNPN = this.getAmbientOcclusionLightValue(x - 1, y + 1, z);
            float lightValueXYZPNN = this.getAmbientOcclusionLightValue(x + 1, y - 1, z);
            float lightValueXYZPPN = this.getAmbientOcclusionLightValue(x + 1, y + 1, z);
            int brightnessXZNN = this.getMixedBrightnessForBlock(x - 1, y, z);
            int brightnessYZNN = this.getMixedBrightnessForBlock(x, y - 1, z);
            int brightnessYZPN = this.getMixedBrightnessForBlock(x, y + 1, z);
            int brightnessXZPN = this.getMixedBrightnessForBlock(x + 1, y, z);
            int brightnessXYZNNN = this.getMixedBrightnessForBlock(x - 1, y - 1, z);
            int brightnessXYZNPN = this.getMixedBrightnessForBlock(x - 1, y + 1, z);
            int brightnessXYZPNN = this.getMixedBrightnessForBlock(x + 1, y - 1, z);
            int brightnessXYZPPN = this.getMixedBrightnessForBlock(x + 1, y + 1, z);
            float lightTopLeft = (lightSelf + lightValueXZNN + lightValueXYZNPN + lightValueYZPN) / 4.0f;
            float lightBottomLeft = (lightSelf + lightValueYZPN + lightValueXZPN + lightValueXYZPPN) / 4.0f;
            float lightBottomRight = (lightSelf + lightValueYZNN + lightValueXYZPNN + lightValueXZPN) / 4.0f;
            float lightTopRight = (lightSelf + lightValueXZNN + lightValueXYZNNN + lightValueYZNN) / 4.0f;
            this.brightnessTopLeft = this.getAoBrightness(brightnessXZNN, brightnessXYZNPN, brightnessYZPN, brightnessSelf);
            this.brightnessBottomLeft = this.getAoBrightness(brightnessYZPN, brightnessXZPN, brightnessXYZPPN, brightnessSelf);
            this.brightnessBottomRight = this.getAoBrightness(brightnessYZNN, brightnessXYZPNN, brightnessXZPN, brightnessSelf);
            this.brightnessTopRight = this.getAoBrightness(brightnessXZNN, brightnessXYZNNN, brightnessYZNN, brightnessSelf);
            this.colorRedBottomRight = this.colorRedTopRight = red * 0.8f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = green * 0.8f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = blue * 0.8f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= lightTopLeft;
            this.colorGreenTopLeft *= lightTopLeft;
            this.colorBlueTopLeft *= lightTopLeft;
            this.colorRedBottomLeft *= lightBottomLeft;
            this.colorGreenBottomLeft *= lightBottomLeft;
            this.colorBlueBottomLeft *= lightBottomLeft;
            this.colorRedBottomRight *= lightBottomRight;
            this.colorGreenBottomRight *= lightBottomRight;
            this.colorBlueBottomRight *= lightBottomRight;
            this.colorRedTopRight *= lightTopRight;
            this.colorGreenTopRight *= lightTopRight;
            this.colorBlueTopRight *= lightTopRight;
            return true;
        }
        if (direction == 2) {
            float lightValueXZNP = this.getAmbientOcclusionLightValue(x - 1, y, z);
            float lightValueXZPP = this.getAmbientOcclusionLightValue(x + 1, y, z);
            float lightValueYZNP = this.getAmbientOcclusionLightValue(x, y - 1, z);
            float lightValueYZPP = this.getAmbientOcclusionLightValue(x, y + 1, z);
            float lightValueXYZNNP = this.getAmbientOcclusionLightValue(x - 1, y - 1, z);
            float lightValueXYZNPP = this.getAmbientOcclusionLightValue(x - 1, y + 1, z);
            float lightValueXYZPNP = this.getAmbientOcclusionLightValue(x + 1, y - 1, z);
            float lightValueXYZPPP = this.getAmbientOcclusionLightValue(x + 1, y + 1, z);
            int brightnessXZNP = this.getMixedBrightnessForBlock(x - 1, y, z);
            int brightnessXZPP = this.getMixedBrightnessForBlock(x + 1, y, z);
            int brightnessYZNP = this.getMixedBrightnessForBlock(x, y - 1, z);
            int brightnessYZPP = this.getMixedBrightnessForBlock(x, y + 1, z);
            int brightnessXYZNNP = this.getMixedBrightnessForBlock(x - 1, y - 1, z);
            int brightnessXYZNPP = this.getMixedBrightnessForBlock(x - 1, y + 1, z);
            int brightnessXYZPNP = this.getMixedBrightnessForBlock(x + 1, y - 1, z);
            int brightnessXYZPPP = this.getMixedBrightnessForBlock(x + 1, y + 1, z);
            float lightTopLeft = (lightValueXZNP + lightValueXYZNPP + lightSelf + lightValueYZPP) / 4.0f;
            float lightTopRight = (lightSelf + lightValueYZPP + lightValueXZPP + lightValueXYZPPP) / 4.0f;
            float lightBottomRight = (lightValueYZNP + lightSelf + lightValueXYZPNP + lightValueXZPP) / 4.0f;
            float lightBottomLeft = (lightValueXYZNNP + lightValueXZNP + lightValueYZNP + lightSelf) / 4.0f;
            this.brightnessTopLeft = this.getAoBrightness(brightnessXZNP, brightnessXYZNPP, brightnessYZPP, brightnessSelf);
            this.brightnessTopRight = this.getAoBrightness(brightnessYZPP, brightnessXZPP, brightnessXYZPPP, brightnessSelf);
            this.brightnessBottomRight = this.getAoBrightness(brightnessYZNP, brightnessXYZPNP, brightnessXZPP, brightnessSelf);
            this.brightnessBottomLeft = this.getAoBrightness(brightnessXYZNNP, brightnessXZNP, brightnessYZNP, brightnessSelf);
            this.colorRedBottomRight = this.colorRedTopRight = red * 0.8f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = green * 0.8f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = blue * 0.8f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= lightTopLeft;
            this.colorGreenTopLeft *= lightTopLeft;
            this.colorBlueTopLeft *= lightTopLeft;
            this.colorRedBottomLeft *= lightBottomLeft;
            this.colorGreenBottomLeft *= lightBottomLeft;
            this.colorBlueBottomLeft *= lightBottomLeft;
            this.colorRedBottomRight *= lightBottomRight;
            this.colorGreenBottomRight *= lightBottomRight;
            this.colorBlueBottomRight *= lightBottomRight;
            this.colorRedTopRight *= lightTopRight;
            this.colorGreenTopRight *= lightTopRight;
            this.colorBlueTopRight *= lightTopRight;
            return true;
        }
        if (direction == 1) {
            float lightValueXYNN = this.getAmbientOcclusionLightValue(x, y - 1, z);
            float lightValueXZNN = this.getAmbientOcclusionLightValue(x, y, z - 1);
            float lightValueXZNP = this.getAmbientOcclusionLightValue(x, y, z + 1);
            float lightValueXYNP = this.getAmbientOcclusionLightValue(x, y + 1, z);
            float lightValueXYZNNN = this.getAmbientOcclusionLightValue(x, y - 1, z - 1);
            float lightValueXYZNNP = this.getAmbientOcclusionLightValue(x, y - 1, z + 1);
            float lightValueXYZNPN = this.getAmbientOcclusionLightValue(x, y + 1, z - 1);
            float lightValueXYZNPP = this.getAmbientOcclusionLightValue(x, y + 1, z + 1);
            int brightnessXYNN = this.getMixedBrightnessForBlock(x, y - 1, z);
            int brightnessXZNN = this.getMixedBrightnessForBlock(x, y, z - 1);
            int brightnessXZNP = this.getMixedBrightnessForBlock(x, y, z + 1);
            int brightnessXYNP = this.getMixedBrightnessForBlock(x, y + 1, z);
            int brightnessXYZNNN = this.getMixedBrightnessForBlock(x, y - 1, z - 1);
            int brightnessXYZNNP = this.getMixedBrightnessForBlock(x, y - 1, z + 1);
            int brightnessXYZNPN = this.getMixedBrightnessForBlock(x, y + 1, z - 1);
            int brightnessXYZNPP = this.getMixedBrightnessForBlock(x, y + 1, z + 1);
            float lightTopRight = (lightValueXYNN + lightValueXYZNNP + lightSelf + lightValueXZNP) / 4.0f;
            float lightTopLeft = (lightSelf + lightValueXZNP + lightValueXYNP + lightValueXYZNPP) / 4.0f;
            float lightBottomLeft = (lightValueXZNN + lightSelf + lightValueXYZNPN + lightValueXYNP) / 4.0f;
            float lightBottomRight = (lightValueXYZNNN + lightValueXYNN + lightValueXZNN + lightSelf) / 4.0f;
            this.brightnessTopRight = this.getAoBrightness(brightnessXYNN, brightnessXYZNNP, brightnessXZNP, brightnessSelf);
            this.brightnessTopLeft = this.getAoBrightness(brightnessXZNP, brightnessXYNP, brightnessXYZNPP, brightnessSelf);
            this.brightnessBottomLeft = this.getAoBrightness(brightnessXZNN, brightnessXYZNPN, brightnessXYNP, brightnessSelf);
            this.brightnessBottomRight = this.getAoBrightness(brightnessXYZNNN, brightnessXYNN, brightnessXZNN, brightnessSelf);
            this.colorRedBottomRight = this.colorRedTopRight = red * 0.6f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = green * 0.6f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = blue * 0.6f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= lightTopLeft;
            this.colorGreenTopLeft *= lightTopLeft;
            this.colorBlueTopLeft *= lightTopLeft;
            this.colorRedBottomLeft *= lightBottomLeft;
            this.colorGreenBottomLeft *= lightBottomLeft;
            this.colorBlueBottomLeft *= lightBottomLeft;
            this.colorRedBottomRight *= lightBottomRight;
            this.colorGreenBottomRight *= lightBottomRight;
            this.colorBlueBottomRight *= lightBottomRight;
            this.colorRedTopRight *= lightTopRight;
            this.colorGreenTopRight *= lightTopRight;
            this.colorBlueTopRight *= lightTopRight;
            return true;
        }
        if (direction == 3) {
            float lightValueXYPN = this.getAmbientOcclusionLightValue(x, y - 1, z);
            float lightValueXZPN = this.getAmbientOcclusionLightValue(x, y, z - 1);
            float lightValueXZPP = this.getAmbientOcclusionLightValue(x, y, z + 1);
            float lightValueXYPP = this.getAmbientOcclusionLightValue(x, y + 1, z);
            float lightValueXYZPNN = this.getAmbientOcclusionLightValue(x, y - 1, z - 1);
            float lightValueXYZPNP = this.getAmbientOcclusionLightValue(x, y - 1, z + 1);
            float lightValueXYZPPN = this.getAmbientOcclusionLightValue(x, y + 1, z - 1);
            float lightValueXYZPPP = this.getAmbientOcclusionLightValue(x, y + 1, z + 1);
            int brightnessXYPN = this.getMixedBrightnessForBlock(x, y - 1, z);
            int brightnessXZPN = this.getMixedBrightnessForBlock(x, y, z - 1);
            int brightnessXZPP = this.getMixedBrightnessForBlock(x, y, z + 1);
            int brightnessXYPP = this.getMixedBrightnessForBlock(x, y + 1, z);
            int brightnessXYZPNN = this.getMixedBrightnessForBlock(x, y - 1, z - 1);
            int brightnessXYZPNP = this.getMixedBrightnessForBlock(x, y - 1, z + 1);
            int brightnessXYZPPN = this.getMixedBrightnessForBlock(x, y + 1, z - 1);
            int brightnessXYZPPP = this.getMixedBrightnessForBlock(x, y + 1, z + 1);
            float lightTopLeft = (lightValueXYPN + lightValueXYZPNP + lightSelf + lightValueXZPP) / 4.0f;
            float lightTopRight = (lightSelf + lightValueXZPP + lightValueXYPP + lightValueXYZPPP) / 4.0f;
            float lightBottomRight = (lightValueXZPN + lightSelf + lightValueXYZPPN + lightValueXYPP) / 4.0f;
            float lightBottomLeft = (lightValueXYZPNN + lightValueXYPN + lightValueXZPN + lightSelf) / 4.0f;
            this.brightnessTopLeft = this.getAoBrightness(brightnessXYPN, brightnessXYZPNP, brightnessXZPP, brightnessSelf);
            this.brightnessTopRight = this.getAoBrightness(brightnessXZPP, brightnessXYPP, brightnessXYZPPP, brightnessSelf);
            this.brightnessBottomRight = this.getAoBrightness(brightnessXZPN, brightnessXYZPPN, brightnessXYPP, brightnessSelf);
            this.brightnessBottomLeft = this.getAoBrightness(brightnessXYZPNN, brightnessXYPN, brightnessXZPN, brightnessSelf);
            this.colorRedBottomRight = this.colorRedTopRight = red * 0.6f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = green * 0.6f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = blue * 0.6f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= lightTopLeft;
            this.colorGreenTopLeft *= lightTopLeft;
            this.colorBlueTopLeft *= lightTopLeft;
            this.colorRedBottomLeft *= lightBottomLeft;
            this.colorGreenBottomLeft *= lightBottomLeft;
            this.colorBlueBottomLeft *= lightBottomLeft;
            this.colorRedBottomRight *= lightBottomRight;
            this.colorGreenBottomRight *= lightBottomRight;
            this.colorBlueBottomRight *= lightBottomRight;
            this.colorRedTopRight *= lightTopRight;
            this.colorGreenTopRight *= lightTopRight;
            this.colorBlueTopRight *= lightTopRight;
            return true;
        }
        return false;
    }

    public int getAoBrightness(int brightness1, int brightness2, int brightness3, int brightnessSelf) {
        int divisor = 4;
        int light1 = brightness1 % 65536;
        int light2 = brightness2 % 65536;
        int light3 = brightness3 % 65536;
        int light4 = brightnessSelf % 65536;
        if (light1 == 0) {
            --divisor;
        }
        if (light2 == 0) {
            --divisor;
        }
        if (light3 == 0) {
            --divisor;
        }
        int light = (light1 + light2 + light3 + light4) / divisor;
        divisor = 4;
        int shade1 = brightness1 / 65536;
        int shade2 = brightness2 / 65536;
        int shade3 = brightness3 / 65536;
        int shade4 = brightnessSelf / 65536;
        if (shade1 == 0) {
            --divisor;
        }
        if (shade2 == 0) {
            --divisor;
        }
        if (shade3 == 0) {
            --divisor;
        }
        int shade = (shade1 + shade2 + shade3 + shade4) / divisor * 65536;
        return light + shade;
    }

    public float getAmbientOcclusionLightValue(int x, int y, int z) {
        return FMLClientHandler.instance().getClient().field_71441_e.func_147439_a(x, y, z).func_149721_r() ? 0.2f : 1.0f;
    }

    public int getMixedBrightnessForBlock(int x, int y, int z) {
        return this.field_76990_c.field_78722_g.func_72802_i(x, y, z, 0);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float f1) {
        this.initWallpaper((EntityWallpaper)entity, x, y, z, yaw);
    }

    protected ResourceLocation func_110775_a(Entity var1) {
        return this.getEntityTexture((EntityWallpaper)var1);
    }

    protected ResourceLocation getEntityTexture(EntityWallpaper wallpaper) {
        return wallpaperTexture;
    }
}

