/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.passiveenchants.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dmillerw.passiveenchants.PassiveEnchants;
import dmillerw.passiveenchants.core.ModCreativeTab;
import dmillerw.passiveenchants.lib.Color4RGBA;
import dmillerw.passiveenchants.lib.ModInfo;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ItemRing
extends Item {
    public static final String[] DYE_ORE_TAGS = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
    public static final int[] DYE_REVERSE_MAPPING = new int[]{15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
    public static final String[] METALS = new String[]{"Gold", "Iron", "Copper", "Silver", "Tin"};
    public static final int[] METAL_COLORS = new int[METALS.length];
    public static final int[] METAL_STRENGTH = new int[]{128, 64, 64, 64, 64};
    public IIcon iconRing;
    public IIcon iconGem;

    public static ItemStack getRing(int metal, int dye) {
        ItemStack stack = new ItemStack(PassiveEnchants.itemRing);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("metal", metal);
        nbt.func_74768_a("dye", dye);
        nbt.func_74768_a("max_damage", METAL_STRENGTH[metal]);
        nbt.func_74768_a("damage", 0);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static int getRingMaxDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("max_damage");
    }

    public static int getRingDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("damage");
    }

    public static void setRingDamage(ItemStack stack, int damage) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        nbt.func_74768_a("damage", damage);
        stack.func_77982_d(nbt);
    }

    public static int getMetal(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("metal");
    }

    public static int getGem(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("dye");
    }

    public ItemRing() {
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(ModCreativeTab.TAB);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(ItemRing.getRing(0, 0));
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int pass) {
        return pass == 1 ? this.iconGem : this.iconRing;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        return pass == 1 ? ItemDye.field_150922_c[DYE_REVERSE_MAPPING[ItemRing.getGem(stack)]] : METAL_COLORS[ItemRing.getMetal(stack)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.iconRing = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "ring");
        this.iconGem = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "ring_gem");
    }

    public int getDamage(ItemStack stack) {
        return ItemRing.getRingDamage(stack);
    }

    public int getDisplayDamage(ItemStack stack) {
        return this.getDamage(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return ItemRing.getRingMaxDamage(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getDamage(stack) > 0;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage < 0) {
            damage = 0;
        }
        ItemRing.setRingDamage(stack, damage);
    }

    static {
        ItemRing.METAL_COLORS[0] = new Color4RGBA(255.0f, 235.0f, 40.0f).toInt();
        ItemRing.METAL_COLORS[1] = new Color4RGBA(180.0f).toInt();
        ItemRing.METAL_COLORS[2] = new Color4RGBA(185.0f, 100.0f, 30.0f).toInt();
        ItemRing.METAL_COLORS[3] = new Color4RGBA(210.0f, 220.0f, 235.0f).toInt();
        ItemRing.METAL_COLORS[4] = new Color4RGBA(225.0f).toInt();
    }
}

