/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.passiveenchants.lib;

import org.lwjgl.opengl.GL11;

public class Color4RGBA {
    public static final Color4RGBA BLACK = new Color4RGBA(0.0f, 0.0f, 0.0f);
    public static final Color4RGBA WHITE = new Color4RGBA(255.0f, 255.0f, 255.0f);
    public float r;
    public float g;
    public float b;
    public float a;

    public Color4RGBA(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color4RGBA(int color) {
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.a = 255.0f;
    }

    public Color4RGBA(float color) {
        this(color, color, color);
    }

    public Color4RGBA(float r, float g, float b) {
        this(r, g, b, 255.0f);
    }

    public Color4RGBA(Color4RGBA[] colors) {
        float rBucket = 0.0f;
        float gBucket = 0.0f;
        float bBucket = 0.0f;
        for (Color4RGBA color : colors) {
            if (color == null) continue;
            rBucket += color.r;
            gBucket += color.g;
            bBucket += color.b;
        }
        this.r = rBucket / (float)colors.length;
        this.g = gBucket / (float)colors.length;
        this.b = bBucket / (float)colors.length;
        this.a = 255.0f;
    }

    public Color4RGBA add(Color4RGBA[] colors) {
        float rBucket = this.r;
        float gBucket = this.g;
        float bBucket = this.b;
        for (Color4RGBA color : colors) {
            if (color == null) continue;
            rBucket += color.r;
            gBucket += color.g;
            bBucket += color.b;
        }
        this.r = rBucket / (float)colors.length;
        this.g = gBucket / (float)colors.length;
        this.b = bBucket / (float)colors.length;
        this.a = 255.0f;
        return this;
    }

    public Color4RGBA multiply(float value) {
        return this.multiply(value, value, value);
    }

    public Color4RGBA multiply(float r, float g, float b) {
        this.r *= r;
        this.g *= g;
        this.b *= b;
        return this;
    }

    public void apply() {
        GL11.glColor4f((float)(this.r / 255.0f), (float)(this.g / 255.0f), (float)(this.b / 255.0f), (float)(this.a / 255.0f));
    }

    public int toInt() {
        return ((int)this.a & 0xFF) << 24 | ((int)this.r & 0xFF) << 16 | ((int)this.g & 0xFF) << 8 | ((int)this.b & 0xFF) << 0;
    }

    public String toString() {
        return "R: " + this.r + " G: " + this.g + " B: " + this.b + " A: " + this.a;
    }
}

