/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.passiveenchants.tile;

import dmillerw.passiveenchants.PassiveEnchants;
import dmillerw.passiveenchants.enchant.EnchantmentHandler;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAlter
extends TileEntity {
    public static final float BOOK_SLAM_MAX = 90.0f;
    public static final int PROGRESS_MAX = 200;
    private ItemStack material;
    private ItemStack book;
    private ItemStack ring;
    public ForgeDirection bookRotation = ForgeDirection.UNKNOWN;
    public float bookRise = 0.0f;
    public float bookWait = 0.0f;
    public float bookSlam = 0.0f;
    public int progress = 0;
    public boolean finished = false;
    public boolean flaming = false;

    public void setMaterial(ItemStack material) {
        this.material = material;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack getMaterial() {
        return this.material;
    }

    public void setBook(ItemStack book, ForgeDirection bookRotation) {
        this.book = book;
        this.bookRotation = bookRotation;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack getBook() {
        return this.book;
    }

    public void setRing(ItemStack ring) {
        this.ring = ring;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack getRing() {
        return this.ring;
    }

    public void burn() {
        this.flaming = true;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (!this.flaming) {
            this.progress = 0;
            this.bookRise = 0.0f;
            this.bookWait = 0.0f;
            this.bookSlam = 0.0f;
        }
        if (this.flaming && this.progress < 200) {
            ++this.progress;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.progress >= 200) {
                this.progress = 0;
                this.flaming = false;
                int[] enchant = EnchantmentHandler.getEnchantmentData(this.book);
                if (enchant.length == 2) {
                    this.ring.func_77966_a(Enchantment.field_77331_b[enchant[0]], enchant[1]);
                }
                this.book = null;
                this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, PassiveEnchants.blockAlter, 0, 0);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (this.flaming) {
            if (this.bookRise != 1.0f) {
                if (this.bookRise < 1.0f) {
                    this.bookRise += Math.max(this.bookRise / 10.0f, 0.001f);
                }
                if ((double)this.bookRise > 0.999) {
                    this.bookRise = 1.0f;
                }
            } else if (this.bookWait < 1.0f) {
                this.bookWait += 0.1f;
            } else if (this.bookSlam < 90.0f) {
                this.bookSlam += Math.min(10.0f, 90.0f - this.bookSlam % 90.0f);
            }
            Random random = new Random();
            if (this.field_145850_b.func_82737_E() % 5L == 0L || this.bookSlam >= 89.0f) {
                for (int i = 0; i < (this.bookSlam < 1.0f ? 2 : 5); ++i) {
                    float x = (float)this.field_145851_c + 0.0f + random.nextFloat();
                    float y = (float)this.field_145848_d + 1.0f + random.nextFloat() * 6.0f / 16.0f;
                    float z = (float)this.field_145849_e + 0.0f + random.nextFloat();
                    this.field_145850_b.func_72869_a("smoke", (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                    this.field_145850_b.func_72869_a("flame", (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean func_145842_c(int id, int data) {
        Random random = new Random();
        double d0 = random.nextGaussian() * 0.05;
        double d1 = random.nextGaussian() * 0.05;
        for (int i = 0; i < 70; ++i) {
            double d2 = (0.5 + random.nextGaussian() * 0.15 + d0) * (double)(random.nextBoolean() ? 1 : -1);
            double d3 = (0.5 + random.nextGaussian() * 0.15 + d1) * (double)(random.nextBoolean() ? 1 : -1);
            double d4 = (0.5 + random.nextDouble() * 0.5) * (double)(random.nextBoolean() ? 1 : -1);
            float x = (float)this.field_145851_c + 0.0f + random.nextFloat();
            float y = (float)this.field_145848_d + 1.0f + random.nextFloat() * 6.0f / 16.0f;
            float z = (float)this.field_145849_e + 0.0f + random.nextFloat();
            this.field_145850_b.func_72869_a("smoke", (double)x, (double)y, (double)z, d2, d3, d4);
            this.field_145850_b.func_72869_a("flame", (double)x, (double)y, (double)z, d2, d3, d4);
        }
        this.finished = true;
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.material = nbt.func_150297_b("material", 10) ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("material")) : null;
        if (nbt.func_150297_b("book", 10)) {
            this.book = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("book"));
            this.bookRotation = ForgeDirection.getOrientation((int)nbt.func_74771_c("bookRotation"));
        } else {
            this.book = null;
        }
        this.ring = nbt.func_150297_b("ring", 10) ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("ring")) : null;
        this.flaming = nbt.func_74767_n("flaming");
        this.progress = nbt.func_74762_e("progress");
        this.finished = nbt.func_74767_n("finished");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        NBTTagCompound item;
        super.func_145841_b(nbt);
        if (this.material != null) {
            item = new NBTTagCompound();
            this.material.func_77955_b(item);
            nbt.func_74782_a("material", (NBTBase)item);
        }
        if (this.book != null) {
            item = new NBTTagCompound();
            this.book.func_77955_b(item);
            nbt.func_74782_a("book", (NBTBase)item);
            nbt.func_74774_a("bookRotation", (byte)this.bookRotation.ordinal());
        }
        if (this.ring != null) {
            item = new NBTTagCompound();
            this.ring.func_77955_b(item);
            nbt.func_74782_a("ring", (NBTBase)item);
        }
        nbt.func_74757_a("flaming", this.flaming);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74757_a("finished", this.finished);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void breakBlock() {
        EntityItem entityitem;
        double d2;
        double d1;
        double d0;
        float f;
        if (this.getBook() != null && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82736_K().func_82766_b("doTileDrops")) {
            f = 0.7f;
            d0 = (double)(this.field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            d1 = (double)(this.field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            d2 = (double)(this.field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + d0, (double)this.field_145848_d + d1, (double)this.field_145849_e + d2, this.getBook());
            entityitem.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
        if (this.getRing() != null && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82736_K().func_82766_b("doTileDrops")) {
            f = 0.7f;
            d0 = (double)(this.field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            d1 = (double)(this.field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            d2 = (double)(this.field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + d0, (double)this.field_145848_d + d1, (double)this.field_145849_e + d2, this.getRing());
            entityitem.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }
}

